/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.ProviderGetResult;
import com.microsoft.azure.management.resources.models.ProviderListParameters;
import com.microsoft.azure.management.resources.models.ProviderListResult;
import com.microsoft.azure.management.resources.models.ProviderRegistionResult;
import com.microsoft.azure.management.resources.models.ProviderUnregistionResult;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* Operations for managing providers.
*/
public interface ProviderOperations {
    /**
    * Gets a resource provider.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource provider information.
    */
    ProviderGetResult get(String resourceProviderNamespace) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a resource provider.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider information.
    */
    Future<ProviderGetResult> getAsync(String resourceProviderNamespace);
    
    /**
    * Gets a list of resource providers.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource providers.
    */
    ProviderListResult list(ProviderListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a list of resource providers.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @return List of resource providers.
    */
    Future<ProviderListResult> listAsync(ProviderListParameters parameters);
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource providers.
    */
    ProviderListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of resource providers.
    */
    Future<ProviderListResult> listNextAsync(String nextLink);
    
    /**
    * Registers provider to be used with a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource provider registration information.
    */
    ProviderRegistionResult register(String resourceProviderNamespace) throws IOException, ServiceException;
    
    /**
    * Registers provider to be used with a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider registration information.
    */
    Future<ProviderRegistionResult> registerAsync(String resourceProviderNamespace);
    
    /**
    * Unregisters provider from a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource provider registration information.
    */
    ProviderUnregistionResult unregister(String resourceProviderNamespace) throws IOException, ServiceException;
    
    /**
    * Unregisters provider from a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider registration information.
    */
    Future<ProviderUnregistionResult> unregisterAsync(String resourceProviderNamespace);
}
