/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.Operation;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadata;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadataGetResult;
import com.microsoft.azure.management.resources.models.ProviderOperationsMetadataListResult;
import com.microsoft.azure.management.resources.models.ResourceType;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for getting provider operations metadata.
*/
public class ProviderOperationsMetadataOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, ProviderOperationsMetadataOperations {
    /**
    * Initializes a new instance of the
    * ProviderOperationsMetadataOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ProviderOperationsMetadataOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Gets provider operations metadata
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Provider operations metadata
    */
    @Override
    public Future<ProviderOperationsMetadataGetResult> getAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderOperationsMetadataGetResult>() { 
            @Override
            public ProviderOperationsMetadataGetResult call() throws Exception {
                return get(resourceProviderNamespace);
            }
         });
    }
    
    /**
    * Gets provider operations metadata
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Provider operations metadata
    */
    @Override
    public ProviderOperationsMetadataGetResult get(String resourceProviderNamespace) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/Microsoft.Authorization/providerOperations/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-07-01-preview");
        queryParameters.add("$expand=resourceTypes");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderOperationsMetadataGetResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderOperationsMetadataGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ProviderOperationsMetadata providerInstance = new ProviderOperationsMetadata();
                    result.setProvider(providerInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        providerInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        providerInstance.setType(typeInstance);
                    }
                    
                    JsonNode displayNameValue = responseDoc.get("displayName");
                    if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                        String displayNameInstance;
                        displayNameInstance = displayNameValue.getTextValue();
                        providerInstance.setDisplayName(displayNameInstance);
                    }
                    
                    JsonNode resourceTypesArray = responseDoc.get("resourceTypes");
                    if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                        for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                            ResourceType resourceTypeInstance = new ResourceType();
                            providerInstance.getResourceTypes().add(resourceTypeInstance);
                            
                            JsonNode nameValue2 = resourceTypesValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                resourceTypeInstance.setName(nameInstance2);
                            }
                            
                            JsonNode displayNameValue2 = resourceTypesValue.get("displayName");
                            if (displayNameValue2 != null && displayNameValue2 instanceof NullNode == false) {
                                String displayNameInstance2;
                                displayNameInstance2 = displayNameValue2.getTextValue();
                                resourceTypeInstance.setDisplayName(displayNameInstance2);
                            }
                            
                            JsonNode operationsArray = resourceTypesValue.get("operations");
                            if (operationsArray != null && operationsArray instanceof NullNode == false) {
                                for (JsonNode operationsValue : ((ArrayNode) operationsArray)) {
                                    Operation operationInstance = new Operation();
                                    resourceTypeInstance.getOperations().add(operationInstance);
                                    
                                    JsonNode nameValue3 = operationsValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        operationInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode displayNameValue3 = operationsValue.get("displayName");
                                    if (displayNameValue3 != null && displayNameValue3 instanceof NullNode == false) {
                                        String displayNameInstance3;
                                        displayNameInstance3 = displayNameValue3.getTextValue();
                                        operationInstance.setDisplayName(displayNameInstance3);
                                    }
                                    
                                    JsonNode descriptionValue = operationsValue.get("description");
                                    if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                        String descriptionInstance;
                                        descriptionInstance = descriptionValue.getTextValue();
                                        operationInstance.setDescription(descriptionInstance);
                                    }
                                    
                                    JsonNode originValue = operationsValue.get("origin");
                                    if (originValue != null && originValue instanceof NullNode == false) {
                                        String originInstance;
                                        originInstance = originValue.getTextValue();
                                        operationInstance.setOrigin(originInstance);
                                    }
                                    
                                    JsonNode propertiesValue = operationsValue.get("properties");
                                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                        Object propertiesInstance;
                                        propertiesInstance = propertiesValue.getTextValue();
                                        operationInstance.setProperties(propertiesInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode operationsArray2 = responseDoc.get("operations");
                    if (operationsArray2 != null && operationsArray2 instanceof NullNode == false) {
                        for (JsonNode operationsValue2 : ((ArrayNode) operationsArray2)) {
                            Operation operationInstance2 = new Operation();
                            providerInstance.getOperations().add(operationInstance2);
                            
                            JsonNode nameValue4 = operationsValue2.get("name");
                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                String nameInstance4;
                                nameInstance4 = nameValue4.getTextValue();
                                operationInstance2.setName(nameInstance4);
                            }
                            
                            JsonNode displayNameValue4 = operationsValue2.get("displayName");
                            if (displayNameValue4 != null && displayNameValue4 instanceof NullNode == false) {
                                String displayNameInstance4;
                                displayNameInstance4 = displayNameValue4.getTextValue();
                                operationInstance2.setDisplayName(displayNameInstance4);
                            }
                            
                            JsonNode descriptionValue2 = operationsValue2.get("description");
                            if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                String descriptionInstance2;
                                descriptionInstance2 = descriptionValue2.getTextValue();
                                operationInstance2.setDescription(descriptionInstance2);
                            }
                            
                            JsonNode originValue2 = operationsValue2.get("origin");
                            if (originValue2 != null && originValue2 instanceof NullNode == false) {
                                String originInstance2;
                                originInstance2 = originValue2.getTextValue();
                                operationInstance2.setOrigin(originInstance2);
                            }
                            
                            JsonNode propertiesValue2 = operationsValue2.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                Object propertiesInstance2;
                                propertiesInstance2 = propertiesValue2.getTextValue();
                                operationInstance2.setProperties(propertiesInstance2);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets provider operations metadata list
    *
    * @return Provider operations metadata list
    */
    @Override
    public Future<ProviderOperationsMetadataListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ProviderOperationsMetadataListResult>() { 
            @Override
            public ProviderOperationsMetadataListResult call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * Gets provider operations metadata list
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Provider operations metadata list
    */
    @Override
    public ProviderOperationsMetadataListResult list() throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/Microsoft.Authorization/providerOperations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-07-01-preview");
        queryParameters.add("$expand=resourceTypes");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderOperationsMetadataListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderOperationsMetadataListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ProviderOperationsMetadata providerOperationsMetadataInstance = new ProviderOperationsMetadata();
                            result.getProviders().add(providerOperationsMetadataInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                providerOperationsMetadataInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                providerOperationsMetadataInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                providerOperationsMetadataInstance.setType(typeInstance);
                            }
                            
                            JsonNode displayNameValue = valueValue.get("displayName");
                            if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                                String displayNameInstance;
                                displayNameInstance = displayNameValue.getTextValue();
                                providerOperationsMetadataInstance.setDisplayName(displayNameInstance);
                            }
                            
                            JsonNode resourceTypesArray = valueValue.get("resourceTypes");
                            if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                    ResourceType resourceTypeInstance = new ResourceType();
                                    providerOperationsMetadataInstance.getResourceTypes().add(resourceTypeInstance);
                                    
                                    JsonNode nameValue2 = resourceTypesValue.get("name");
                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                        String nameInstance2;
                                        nameInstance2 = nameValue2.getTextValue();
                                        resourceTypeInstance.setName(nameInstance2);
                                    }
                                    
                                    JsonNode displayNameValue2 = resourceTypesValue.get("displayName");
                                    if (displayNameValue2 != null && displayNameValue2 instanceof NullNode == false) {
                                        String displayNameInstance2;
                                        displayNameInstance2 = displayNameValue2.getTextValue();
                                        resourceTypeInstance.setDisplayName(displayNameInstance2);
                                    }
                                    
                                    JsonNode operationsArray = resourceTypesValue.get("operations");
                                    if (operationsArray != null && operationsArray instanceof NullNode == false) {
                                        for (JsonNode operationsValue : ((ArrayNode) operationsArray)) {
                                            Operation operationInstance = new Operation();
                                            resourceTypeInstance.getOperations().add(operationInstance);
                                            
                                            JsonNode nameValue3 = operationsValue.get("name");
                                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                String nameInstance3;
                                                nameInstance3 = nameValue3.getTextValue();
                                                operationInstance.setName(nameInstance3);
                                            }
                                            
                                            JsonNode displayNameValue3 = operationsValue.get("displayName");
                                            if (displayNameValue3 != null && displayNameValue3 instanceof NullNode == false) {
                                                String displayNameInstance3;
                                                displayNameInstance3 = displayNameValue3.getTextValue();
                                                operationInstance.setDisplayName(displayNameInstance3);
                                            }
                                            
                                            JsonNode descriptionValue = operationsValue.get("description");
                                            if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                                String descriptionInstance;
                                                descriptionInstance = descriptionValue.getTextValue();
                                                operationInstance.setDescription(descriptionInstance);
                                            }
                                            
                                            JsonNode originValue = operationsValue.get("origin");
                                            if (originValue != null && originValue instanceof NullNode == false) {
                                                String originInstance;
                                                originInstance = originValue.getTextValue();
                                                operationInstance.setOrigin(originInstance);
                                            }
                                            
                                            JsonNode propertiesValue = operationsValue.get("properties");
                                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                                Object propertiesInstance;
                                                propertiesInstance = propertiesValue.getTextValue();
                                                operationInstance.setProperties(propertiesInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode operationsArray2 = valueValue.get("operations");
                            if (operationsArray2 != null && operationsArray2 instanceof NullNode == false) {
                                for (JsonNode operationsValue2 : ((ArrayNode) operationsArray2)) {
                                    Operation operationInstance2 = new Operation();
                                    providerOperationsMetadataInstance.getOperations().add(operationInstance2);
                                    
                                    JsonNode nameValue4 = operationsValue2.get("name");
                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                        String nameInstance4;
                                        nameInstance4 = nameValue4.getTextValue();
                                        operationInstance2.setName(nameInstance4);
                                    }
                                    
                                    JsonNode displayNameValue4 = operationsValue2.get("displayName");
                                    if (displayNameValue4 != null && displayNameValue4 instanceof NullNode == false) {
                                        String displayNameInstance4;
                                        displayNameInstance4 = displayNameValue4.getTextValue();
                                        operationInstance2.setDisplayName(displayNameInstance4);
                                    }
                                    
                                    JsonNode descriptionValue2 = operationsValue2.get("description");
                                    if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                        String descriptionInstance2;
                                        descriptionInstance2 = descriptionValue2.getTextValue();
                                        operationInstance2.setDescription(descriptionInstance2);
                                    }
                                    
                                    JsonNode originValue2 = operationsValue2.get("origin");
                                    if (originValue2 != null && originValue2 instanceof NullNode == false) {
                                        String originInstance2;
                                        originInstance2 = originValue2.getTextValue();
                                        operationInstance2.setOrigin(originInstance2);
                                    }
                                    
                                    JsonNode propertiesValue2 = operationsValue2.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        Object propertiesInstance2;
                                        propertiesInstance2 = propertiesValue2.getTextValue();
                                        operationInstance2.setProperties(propertiesInstance2);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
