/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.azure.management.resources.models.ResourceGroup;
import com.microsoft.azure.management.resources.models.ResourceGroupCreateOrUpdateResult;
import com.microsoft.azure.management.resources.models.ResourceGroupExistsResult;
import com.microsoft.azure.management.resources.models.ResourceGroupGetResult;
import com.microsoft.azure.management.resources.models.ResourceGroupListParameters;
import com.microsoft.azure.management.resources.models.ResourceGroupListResult;
import com.microsoft.azure.management.resources.models.ResourceGroupPatchResult;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing resource groups.
*/
public interface ResourceGroupOperations {
    /**
    * Begin deleting resource group.To determine whether the operation has
    * finished processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * deleted. The name is case insensitive.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    LongRunningOperationResponse beginDeleting(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * Begin deleting resource group.To determine whether the operation has
    * finished processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * deleted. The name is case insensitive.
    * @return A standard service response for long running operations.
    */
    Future<LongRunningOperationResponse> beginDeletingAsync(String resourceGroupName);
    
    /**
    * Checks whether resource group exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource group information.
    */
    ResourceGroupExistsResult checkExistence(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * Checks whether resource group exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @return Resource group information.
    */
    Future<ResourceGroupExistsResult> checkExistenceAsync(String resourceGroupName);
    
    /**
    * Create a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * created or updated.
    * @param parameters Required. Parameters supplied to the create or update
    * resource group service operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource group information.
    */
    ResourceGroupCreateOrUpdateResult createOrUpdate(String resourceGroupName, ResourceGroup parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Create a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * created or updated.
    * @param parameters Required. Parameters supplied to the create or update
    * resource group service operation.
    * @return Resource group information.
    */
    Future<ResourceGroupCreateOrUpdateResult> createOrUpdateAsync(String resourceGroupName, ResourceGroup parameters);
    
    /**
    * Delete resource group and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * deleted. The name is case insensitive.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Delete resource group and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * deleted. The name is case insensitive.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName);
    
    /**
    * Get a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource group information.
    */
    ResourceGroupGetResult get(String resourceGroupName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @return Resource group information.
    */
    Future<ResourceGroupGetResult> getAsync(String resourceGroupName);
    
    /**
    * Gets a collection of resource groups.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all resource groups.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource groups.
    */
    ResourceGroupListResult list(ResourceGroupListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a collection of resource groups.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all resource groups.
    * @return List of resource groups.
    */
    Future<ResourceGroupListResult> listAsync(ResourceGroupListParameters parameters);
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource groups.
    */
    ResourceGroupListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of resource groups.
    */
    Future<ResourceGroupListResult> listNextAsync(String nextLink);
    
    /**
    * Resource groups can be updated through a simple PATCH operation to a
    * group address. The format of the request is the same as that for
    * creating a resource groups, though if a field is unspecified current
    * value will be carried over.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * created or updated. The name is case insensitive.
    * @param parameters Required. Parameters supplied to the update state
    * resource group service operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource group information.
    */
    ResourceGroupPatchResult patch(String resourceGroupName, ResourceGroup parameters) throws IOException, ServiceException;
    
    /**
    * Resource groups can be updated through a simple PATCH operation to a
    * group address. The format of the request is the same as that for
    * creating a resource groups, though if a field is unspecified current
    * value will be carried over.
    *
    * @param resourceGroupName Required. The name of the resource group to be
    * created or updated. The name is case insensitive.
    * @param parameters Required. Parameters supplied to the update state
    * resource group service operation.
    * @return Resource group information.
    */
    Future<ResourceGroupPatchResult> patchAsync(String resourceGroupName, ResourceGroup parameters);
}
