/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;

public interface ResourceManagementClient extends Closeable, FilterableService<ResourceManagementClient> {
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    String getApiVersion();
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    URI getBaseUri();
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    SubscriptionCloudCredentials getCredentials();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    int getLongRunningOperationInitialTimeout();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue);
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    int getLongRunningOperationRetryTimeout();
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue);
    /**
    * Operations for managing deployment operations.
    * @return The DeploymentOperationsOperations value.
    */
    DeploymentOperationOperations getDeploymentOperationsOperations();
    
    /**
    * Operations for managing deployments.
    * @return The DeploymentsOperations value.
    */
    DeploymentOperations getDeploymentsOperations();
    
    /**
    * Operations for managing providers.
    * @return The ProvidersOperations value.
    */
    ProviderOperations getProvidersOperations();
    
    /**
    * Operations for getting provider operations metadata.
    * @return The ProviderOperationsMetadataOperations value.
    */
    ProviderOperationsMetadataOperations getProviderOperationsMetadataOperations();
    
    /**
    * Operations for managing resource groups.
    * @return The ResourceGroupsOperations value.
    */
    ResourceGroupOperations getResourceGroupsOperations();
    
    /**
    * Operations for managing resources.
    * @return The ResourcesOperations value.
    */
    ResourceOperations getResourcesOperations();
    
    /**
    * Operations for managing Resource provider operations.
    * @return The ResourceProviderOperationDetailsOperations value.
    */
    ResourceProviderOperationDetailsOperations getResourceProviderOperationDetailsOperations();
    
    /**
    * Operations for managing tags.
    * @return The TagsOperations value.
    */
    TagOperations getTagsOperations();
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    LongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return A standard service response for long running operations.
    */
    Future<LongRunningOperationResponse> getLongRunningOperationStatusAsync(String operationStatusLink);
}
