/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.TagCreateResult;
import com.microsoft.azure.management.resources.models.TagCreateValueResult;
import com.microsoft.azure.management.resources.models.TagsListResult;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing tags.
*/
public interface TagOperations {
    /**
    * Create a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Tag information.
    */
    TagCreateResult createOrUpdate(String tagName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Create a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @return Tag information.
    */
    Future<TagCreateResult> createOrUpdateAsync(String tagName);
    
    /**
    * Create a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Tag information.
    */
    TagCreateValueResult createOrUpdateValue(String tagName, String tagValue) throws IOException, ServiceException;
    
    /**
    * Create a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @return Tag information.
    */
    Future<TagCreateValueResult> createOrUpdateValueAsync(String tagName, String tagValue);
    
    /**
    * Delete a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String tagName) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Delete a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String tagName);
    
    /**
    * Delete a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse deleteValue(String tagName, String tagValue) throws IOException, ServiceException;
    
    /**
    * Delete a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteValueAsync(String tagName, String tagValue);
    
    /**
    * Get a list of subscription resource tags.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of subscription tags.
    */
    TagsListResult list() throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of subscription resource tags.
    *
    * @return List of subscription tags.
    */
    Future<TagsListResult> listAsync();
    
    /**
    * Get a list of tags under a subscription.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of subscription tags.
    */
    TagsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of tags under a subscription.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of subscription tags.
    */
    Future<TagsListResult> listNextAsync(String nextLink);
}
