/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

public class ResourceManagementErrorWithDetails extends ResourceManagementError {
    private ArrayList<ResourceManagementError> details;
    
    /**
    * Optional. Gets or sets validation error.
    * @return The Details value.
    */
    public ArrayList<ResourceManagementError> getDetails() {
        return this.details;
    }
    
    /**
    * Optional. Gets or sets validation error.
    * @param detailsValue The Details value.
    */
    public void setDetails(final ArrayList<ResourceManagementError> detailsValue) {
        this.details = detailsValue;
    }
    
    /**
    * Initializes a new instance of the ResourceManagementErrorWithDetails
    * class.
    *
    */
    public ResourceManagementErrorWithDetails() {
        super();
        this.setDetails(new LazyArrayList<ResourceManagementError>());
    }
    
    /**
    * Initializes a new instance of the ResourceManagementErrorWithDetails
    * class with required arguments.
    *
    * @param code Gets or sets the error code returned from the server.
    * @param message Gets or sets the error message returned from the server.
    */
    public ResourceManagementErrorWithDetails(String code, String message) {
        this();
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.setCode(code);
        this.setMessage(message);
    }
}
