/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.subscriptions;

import com.microsoft.azure.subscriptions.models.GetSubscriptionResult;
import com.microsoft.azure.subscriptions.models.Subscription;
import com.microsoft.azure.subscriptions.models.SubscriptionListResult;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing subscriptions.
*/
public class SubscriptionOperationsImpl implements ServiceOperations<SubscriptionClientImpl>, SubscriptionOperations {
    /**
    * Initializes a new instance of the SubscriptionOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    SubscriptionOperationsImpl(SubscriptionClientImpl client) {
        this.client = client;
    }
    
    private SubscriptionClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.subscriptions.SubscriptionClientImpl.
    * @return The Client value.
    */
    public SubscriptionClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Gets details about particular subscription.
    *
    * @param subscriptionId Required. Id of the subscription.
    * @return Subscription detailed information.
    */
    @Override
    public Future<GetSubscriptionResult> getAsync(final String subscriptionId) {
        return this.getClient().getExecutorService().submit(new Callable<GetSubscriptionResult>() { 
            @Override
            public GetSubscriptionResult call() throws Exception {
                return get(subscriptionId);
            }
         });
    }
    
    /**
    * Gets details about particular subscription.
    *
    * @param subscriptionId Required. Id of the subscription.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Subscription detailed information.
    */
    @Override
    public GetSubscriptionResult get(String subscriptionId) throws IOException, ServiceException {
        // Validate
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("subscriptionId", subscriptionId);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        url = url + URLEncoder.encode(subscriptionId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetSubscriptionResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new GetSubscriptionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Subscription subscriptionInstance = new Subscription();
                    result.setSubscription(subscriptionInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        subscriptionInstance.setId(idInstance);
                    }
                    
                    JsonNode subscriptionIdValue = responseDoc.get("subscriptionId");
                    if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                        String subscriptionIdInstance;
                        subscriptionIdInstance = subscriptionIdValue.getTextValue();
                        subscriptionInstance.setSubscriptionId(subscriptionIdInstance);
                    }
                    
                    JsonNode displayNameValue = responseDoc.get("displayName");
                    if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                        String displayNameInstance;
                        displayNameInstance = displayNameValue.getTextValue();
                        subscriptionInstance.setDisplayName(displayNameInstance);
                    }
                    
                    JsonNode stateValue = responseDoc.get("state");
                    if (stateValue != null && stateValue instanceof NullNode == false) {
                        String stateInstance;
                        stateInstance = stateValue.getTextValue();
                        subscriptionInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of the subscriptionIds.
    *
    * @return Subscription list operation response.
    */
    @Override
    public Future<SubscriptionListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionListResult>() { 
            @Override
            public SubscriptionListResult call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * Gets a list of the subscriptionIds.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Subscription list operation response.
    */
    @Override
    public SubscriptionListResult list() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubscriptionListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            Subscription subscriptionInstance = new Subscription();
                            result.getSubscriptions().add(subscriptionInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                subscriptionInstance.setId(idInstance);
                            }
                            
                            JsonNode subscriptionIdValue = valueValue.get("subscriptionId");
                            if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                                String subscriptionIdInstance;
                                subscriptionIdInstance = subscriptionIdValue.getTextValue();
                                subscriptionInstance.setSubscriptionId(subscriptionIdInstance);
                            }
                            
                            JsonNode displayNameValue = valueValue.get("displayName");
                            if (displayNameValue != null && displayNameValue instanceof NullNode == false) {
                                String displayNameInstance;
                                displayNameInstance = displayNameValue.getTextValue();
                                subscriptionInstance.setDisplayName(displayNameInstance);
                            }
                            
                            JsonNode stateValue = valueValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                String stateInstance;
                                stateInstance = stateValue.getTextValue();
                                subscriptionInstance.setState(stateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
