/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DatabaseAuditingPolicy;
import com.microsoft.azure.management.sql.models.DatabaseAuditingPolicyCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.DatabaseAuditingPolicyGetResponse;
import com.microsoft.azure.management.sql.models.DatabaseAuditingPolicyProperties;
import com.microsoft.azure.management.sql.models.ServerAuditingPolicy;
import com.microsoft.azure.management.sql.models.ServerAuditingPolicyCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.ServerAuditingPolicyGetResponse;
import com.microsoft.azure.management.sql.models.ServerAuditingPolicyProperties;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents all the operations to manage Azure SQL Database and Database
* Server Audit policy.  Contains operations to: Create, Retrieve and Update
* audit policy.
*/
public class AuditingPolicyOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, AuditingPolicyOperations {
    /**
    * Initializes a new instance of the AuditingPolicyOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    AuditingPolicyOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates or updates an Azure SQL Database auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the auditing policy applies.
    * @param parameters Required. The required parameters for createing or
    * updating a Azure SQL Database auditing policy.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> createOrUpdateDatebasePolicyAsync(final String resourceGroupName, final String serverName, final String databaseName, final DatabaseAuditingPolicyCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return createOrUpdateDatebasePolicy(resourceGroupName, serverName, databaseName, parameters);
            }
         });
    }
    
    /**
    * Creates or updates an Azure SQL Database auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the auditing policy applies.
    * @param parameters Required. The required parameters for createing or
    * updating a Azure SQL Database auditing policy.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse createOrUpdateDatebasePolicy(String resourceGroupName, String serverName, String databaseName, DatabaseAuditingPolicyCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateDatebasePolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/auditingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode databaseAuditingPolicyCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = databaseAuditingPolicyCreateOrUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) databaseAuditingPolicyCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getUseServerDefault() != null) {
            ((ObjectNode) propertiesValue).put("useServerDefault", parameters.getProperties().getUseServerDefault());
        }
        
        if (parameters.getProperties().getAuditingState() != null) {
            ((ObjectNode) propertiesValue).put("auditingState", parameters.getProperties().getAuditingState());
        }
        
        if (parameters.getProperties().getEventTypesToAudit() != null) {
            ((ObjectNode) propertiesValue).put("eventTypesToAudit", parameters.getProperties().getEventTypesToAudit());
        }
        
        if (parameters.getProperties().getStorageAccountName() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountName", parameters.getProperties().getStorageAccountName());
        }
        
        if (parameters.getProperties().getStorageAccountKey() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountKey", parameters.getProperties().getStorageAccountKey());
        }
        
        if (parameters.getProperties().getStorageAccountSecondaryKey() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountSecondaryKey", parameters.getProperties().getStorageAccountSecondaryKey());
        }
        
        if (parameters.getProperties().getStorageTableEndpoint() != null) {
            ((ObjectNode) propertiesValue).put("storageTableEndpoint", parameters.getProperties().getStorageTableEndpoint());
        }
        
        if (parameters.getProperties().getStorageAccountResourceGroupName() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountResourceGroupName", parameters.getProperties().getStorageAccountResourceGroupName());
        }
        
        if (parameters.getProperties().getStorageAccountSubscriptionId() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountSubscriptionId", parameters.getProperties().getStorageAccountSubscriptionId());
        }
        
        if (parameters.getProperties().getRetentionDays() != null) {
            ((ObjectNode) propertiesValue).put("retentionDays", parameters.getProperties().getRetentionDays());
        }
        
        if (parameters.getProperties().getAuditLogsTableName() != null) {
            ((ObjectNode) propertiesValue).put("auditLogsTableName", parameters.getProperties().getAuditLogsTableName());
        }
        
        if (parameters.getProperties().getFullAuditLogsTableName() != null) {
            ((ObjectNode) propertiesValue).put("fullAuditLogsTableName", parameters.getProperties().getFullAuditLogsTableName());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates or updates an Azure SQL Database Server auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param parameters Required. The required parameters for createing or
    * updating a Azure SQL Database Server auditing policy.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> createOrUpdateServerPolicyAsync(final String resourceGroupName, final String serverName, final ServerAuditingPolicyCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return createOrUpdateServerPolicy(resourceGroupName, serverName, parameters);
            }
         });
    }
    
    /**
    * Creates or updates an Azure SQL Database Server auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param parameters Required. The required parameters for createing or
    * updating a Azure SQL Database Server auditing policy.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse createOrUpdateServerPolicy(String resourceGroupName, String serverName, ServerAuditingPolicyCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateServerPolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/auditingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode serverAuditingPolicyCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = serverAuditingPolicyCreateOrUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) serverAuditingPolicyCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getAuditingState() != null) {
            ((ObjectNode) propertiesValue).put("auditingState", parameters.getProperties().getAuditingState());
        }
        
        if (parameters.getProperties().getEventTypesToAudit() != null) {
            ((ObjectNode) propertiesValue).put("eventTypesToAudit", parameters.getProperties().getEventTypesToAudit());
        }
        
        if (parameters.getProperties().getStorageAccountName() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountName", parameters.getProperties().getStorageAccountName());
        }
        
        if (parameters.getProperties().getStorageAccountKey() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountKey", parameters.getProperties().getStorageAccountKey());
        }
        
        if (parameters.getProperties().getStorageAccountSecondaryKey() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountSecondaryKey", parameters.getProperties().getStorageAccountSecondaryKey());
        }
        
        if (parameters.getProperties().getStorageTableEndpoint() != null) {
            ((ObjectNode) propertiesValue).put("storageTableEndpoint", parameters.getProperties().getStorageTableEndpoint());
        }
        
        if (parameters.getProperties().getStorageAccountResourceGroupName() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountResourceGroupName", parameters.getProperties().getStorageAccountResourceGroupName());
        }
        
        if (parameters.getProperties().getStorageAccountSubscriptionId() != null) {
            ((ObjectNode) propertiesValue).put("storageAccountSubscriptionId", parameters.getProperties().getStorageAccountSubscriptionId());
        }
        
        if (parameters.getProperties().getRetentionDays() != null) {
            ((ObjectNode) propertiesValue).put("retentionDays", parameters.getProperties().getRetentionDays());
        }
        
        if (parameters.getProperties().getAuditLogsTableName() != null) {
            ((ObjectNode) propertiesValue).put("auditLogsTableName", parameters.getProperties().getAuditLogsTableName());
        }
        
        if (parameters.getProperties().getFullAuditLogsTableName() != null) {
            ((ObjectNode) propertiesValue).put("fullAuditLogsTableName", parameters.getProperties().getFullAuditLogsTableName());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns an Azure SQL Database auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the auditing policy applies.
    * @return Represents the response to a get database auditing policy request.
    */
    @Override
    public Future<DatabaseAuditingPolicyGetResponse> getDatabasePolicyAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseAuditingPolicyGetResponse>() { 
            @Override
            public DatabaseAuditingPolicyGetResponse call() throws Exception {
                return getDatabasePolicy(resourceGroupName, serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns an Azure SQL Database auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the auditing policy applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a get database auditing policy request.
    */
    @Override
    public DatabaseAuditingPolicyGetResponse getDatabasePolicy(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "getDatabasePolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/auditingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseAuditingPolicyGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseAuditingPolicyGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DatabaseAuditingPolicy auditingPolicyInstance = new DatabaseAuditingPolicy();
                    result.setAuditingPolicy(auditingPolicyInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DatabaseAuditingPolicyProperties propertiesInstance = new DatabaseAuditingPolicyProperties();
                        auditingPolicyInstance.setProperties(propertiesInstance);
                        
                        JsonNode useServerDefaultValue = propertiesValue.get("useServerDefault");
                        if (useServerDefaultValue != null && useServerDefaultValue instanceof NullNode == false) {
                            String useServerDefaultInstance;
                            useServerDefaultInstance = useServerDefaultValue.getTextValue();
                            propertiesInstance.setUseServerDefault(useServerDefaultInstance);
                        }
                        
                        JsonNode auditingStateValue = propertiesValue.get("auditingState");
                        if (auditingStateValue != null && auditingStateValue instanceof NullNode == false) {
                            String auditingStateInstance;
                            auditingStateInstance = auditingStateValue.getTextValue();
                            propertiesInstance.setAuditingState(auditingStateInstance);
                        }
                        
                        JsonNode eventTypesToAuditValue = propertiesValue.get("eventTypesToAudit");
                        if (eventTypesToAuditValue != null && eventTypesToAuditValue instanceof NullNode == false) {
                            String eventTypesToAuditInstance;
                            eventTypesToAuditInstance = eventTypesToAuditValue.getTextValue();
                            propertiesInstance.setEventTypesToAudit(eventTypesToAuditInstance);
                        }
                        
                        JsonNode storageAccountNameValue = propertiesValue.get("storageAccountName");
                        if (storageAccountNameValue != null && storageAccountNameValue instanceof NullNode == false) {
                            String storageAccountNameInstance;
                            storageAccountNameInstance = storageAccountNameValue.getTextValue();
                            propertiesInstance.setStorageAccountName(storageAccountNameInstance);
                        }
                        
                        JsonNode storageAccountKeyValue = propertiesValue.get("storageAccountKey");
                        if (storageAccountKeyValue != null && storageAccountKeyValue instanceof NullNode == false) {
                            String storageAccountKeyInstance;
                            storageAccountKeyInstance = storageAccountKeyValue.getTextValue();
                            propertiesInstance.setStorageAccountKey(storageAccountKeyInstance);
                        }
                        
                        JsonNode storageAccountSecondaryKeyValue = propertiesValue.get("storageAccountSecondaryKey");
                        if (storageAccountSecondaryKeyValue != null && storageAccountSecondaryKeyValue instanceof NullNode == false) {
                            String storageAccountSecondaryKeyInstance;
                            storageAccountSecondaryKeyInstance = storageAccountSecondaryKeyValue.getTextValue();
                            propertiesInstance.setStorageAccountSecondaryKey(storageAccountSecondaryKeyInstance);
                        }
                        
                        JsonNode storageTableEndpointValue = propertiesValue.get("storageTableEndpoint");
                        if (storageTableEndpointValue != null && storageTableEndpointValue instanceof NullNode == false) {
                            String storageTableEndpointInstance;
                            storageTableEndpointInstance = storageTableEndpointValue.getTextValue();
                            propertiesInstance.setStorageTableEndpoint(storageTableEndpointInstance);
                        }
                        
                        JsonNode storageAccountResourceGroupNameValue = propertiesValue.get("storageAccountResourceGroupName");
                        if (storageAccountResourceGroupNameValue != null && storageAccountResourceGroupNameValue instanceof NullNode == false) {
                            String storageAccountResourceGroupNameInstance;
                            storageAccountResourceGroupNameInstance = storageAccountResourceGroupNameValue.getTextValue();
                            propertiesInstance.setStorageAccountResourceGroupName(storageAccountResourceGroupNameInstance);
                        }
                        
                        JsonNode storageAccountSubscriptionIdValue = propertiesValue.get("storageAccountSubscriptionId");
                        if (storageAccountSubscriptionIdValue != null && storageAccountSubscriptionIdValue instanceof NullNode == false) {
                            String storageAccountSubscriptionIdInstance;
                            storageAccountSubscriptionIdInstance = storageAccountSubscriptionIdValue.getTextValue();
                            propertiesInstance.setStorageAccountSubscriptionId(storageAccountSubscriptionIdInstance);
                        }
                        
                        JsonNode retentionDaysValue = propertiesValue.get("retentionDays");
                        if (retentionDaysValue != null && retentionDaysValue instanceof NullNode == false) {
                            String retentionDaysInstance;
                            retentionDaysInstance = retentionDaysValue.getTextValue();
                            propertiesInstance.setRetentionDays(retentionDaysInstance);
                        }
                        
                        JsonNode auditLogsTableNameValue = propertiesValue.get("auditLogsTableName");
                        if (auditLogsTableNameValue != null && auditLogsTableNameValue instanceof NullNode == false) {
                            String auditLogsTableNameInstance;
                            auditLogsTableNameInstance = auditLogsTableNameValue.getTextValue();
                            propertiesInstance.setAuditLogsTableName(auditLogsTableNameInstance);
                        }
                        
                        JsonNode fullAuditLogsTableNameValue = propertiesValue.get("fullAuditLogsTableName");
                        if (fullAuditLogsTableNameValue != null && fullAuditLogsTableNameValue instanceof NullNode == false) {
                            String fullAuditLogsTableNameInstance;
                            fullAuditLogsTableNameInstance = fullAuditLogsTableNameValue.getTextValue();
                            propertiesInstance.setFullAuditLogsTableName(fullAuditLogsTableNameInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        auditingPolicyInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        auditingPolicyInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        auditingPolicyInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        auditingPolicyInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            auditingPolicyInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns an Azure SQL Database server auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @return Represents the response to a get database auditing policy request.
    */
    @Override
    public Future<ServerAuditingPolicyGetResponse> getServerPolicyAsync(final String resourceGroupName, final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<ServerAuditingPolicyGetResponse>() { 
            @Override
            public ServerAuditingPolicyGetResponse call() throws Exception {
                return getServerPolicy(resourceGroupName, serverName);
            }
         });
    }
    
    /**
    * Returns an Azure SQL Database server auditing policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a get database auditing policy request.
    */
    @Override
    public ServerAuditingPolicyGetResponse getServerPolicy(String resourceGroupName, String serverName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter(invocationId, this, "getServerPolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/auditingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServerAuditingPolicyGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServerAuditingPolicyGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ServerAuditingPolicy auditingPolicyInstance = new ServerAuditingPolicy();
                    result.setAuditingPolicy(auditingPolicyInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        ServerAuditingPolicyProperties propertiesInstance = new ServerAuditingPolicyProperties();
                        auditingPolicyInstance.setProperties(propertiesInstance);
                        
                        JsonNode auditingStateValue = propertiesValue.get("auditingState");
                        if (auditingStateValue != null && auditingStateValue instanceof NullNode == false) {
                            String auditingStateInstance;
                            auditingStateInstance = auditingStateValue.getTextValue();
                            propertiesInstance.setAuditingState(auditingStateInstance);
                        }
                        
                        JsonNode eventTypesToAuditValue = propertiesValue.get("eventTypesToAudit");
                        if (eventTypesToAuditValue != null && eventTypesToAuditValue instanceof NullNode == false) {
                            String eventTypesToAuditInstance;
                            eventTypesToAuditInstance = eventTypesToAuditValue.getTextValue();
                            propertiesInstance.setEventTypesToAudit(eventTypesToAuditInstance);
                        }
                        
                        JsonNode storageAccountNameValue = propertiesValue.get("storageAccountName");
                        if (storageAccountNameValue != null && storageAccountNameValue instanceof NullNode == false) {
                            String storageAccountNameInstance;
                            storageAccountNameInstance = storageAccountNameValue.getTextValue();
                            propertiesInstance.setStorageAccountName(storageAccountNameInstance);
                        }
                        
                        JsonNode storageAccountKeyValue = propertiesValue.get("storageAccountKey");
                        if (storageAccountKeyValue != null && storageAccountKeyValue instanceof NullNode == false) {
                            String storageAccountKeyInstance;
                            storageAccountKeyInstance = storageAccountKeyValue.getTextValue();
                            propertiesInstance.setStorageAccountKey(storageAccountKeyInstance);
                        }
                        
                        JsonNode storageAccountSecondaryKeyValue = propertiesValue.get("storageAccountSecondaryKey");
                        if (storageAccountSecondaryKeyValue != null && storageAccountSecondaryKeyValue instanceof NullNode == false) {
                            String storageAccountSecondaryKeyInstance;
                            storageAccountSecondaryKeyInstance = storageAccountSecondaryKeyValue.getTextValue();
                            propertiesInstance.setStorageAccountSecondaryKey(storageAccountSecondaryKeyInstance);
                        }
                        
                        JsonNode storageTableEndpointValue = propertiesValue.get("storageTableEndpoint");
                        if (storageTableEndpointValue != null && storageTableEndpointValue instanceof NullNode == false) {
                            String storageTableEndpointInstance;
                            storageTableEndpointInstance = storageTableEndpointValue.getTextValue();
                            propertiesInstance.setStorageTableEndpoint(storageTableEndpointInstance);
                        }
                        
                        JsonNode storageAccountResourceGroupNameValue = propertiesValue.get("storageAccountResourceGroupName");
                        if (storageAccountResourceGroupNameValue != null && storageAccountResourceGroupNameValue instanceof NullNode == false) {
                            String storageAccountResourceGroupNameInstance;
                            storageAccountResourceGroupNameInstance = storageAccountResourceGroupNameValue.getTextValue();
                            propertiesInstance.setStorageAccountResourceGroupName(storageAccountResourceGroupNameInstance);
                        }
                        
                        JsonNode storageAccountSubscriptionIdValue = propertiesValue.get("storageAccountSubscriptionId");
                        if (storageAccountSubscriptionIdValue != null && storageAccountSubscriptionIdValue instanceof NullNode == false) {
                            String storageAccountSubscriptionIdInstance;
                            storageAccountSubscriptionIdInstance = storageAccountSubscriptionIdValue.getTextValue();
                            propertiesInstance.setStorageAccountSubscriptionId(storageAccountSubscriptionIdInstance);
                        }
                        
                        JsonNode retentionDaysValue = propertiesValue.get("retentionDays");
                        if (retentionDaysValue != null && retentionDaysValue instanceof NullNode == false) {
                            String retentionDaysInstance;
                            retentionDaysInstance = retentionDaysValue.getTextValue();
                            propertiesInstance.setRetentionDays(retentionDaysInstance);
                        }
                        
                        JsonNode auditLogsTableNameValue = propertiesValue.get("auditLogsTableName");
                        if (auditLogsTableNameValue != null && auditLogsTableNameValue instanceof NullNode == false) {
                            String auditLogsTableNameInstance;
                            auditLogsTableNameInstance = auditLogsTableNameValue.getTextValue();
                            propertiesInstance.setAuditLogsTableName(auditLogsTableNameInstance);
                        }
                        
                        JsonNode fullAuditLogsTableNameValue = propertiesValue.get("fullAuditLogsTableName");
                        if (fullAuditLogsTableNameValue != null && fullAuditLogsTableNameValue instanceof NullNode == false) {
                            String fullAuditLogsTableNameInstance;
                            fullAuditLogsTableNameInstance = fullAuditLogsTableNameValue.getTextValue();
                            propertiesInstance.setFullAuditLogsTableName(fullAuditLogsTableNameInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        auditingPolicyInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        auditingPolicyInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        auditingPolicyInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        auditingPolicyInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            auditingPolicyInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
