/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.EditionCapability;
import com.microsoft.azure.management.sql.models.LocationCapability;
import com.microsoft.azure.management.sql.models.MaxSizeCapability;
import com.microsoft.azure.management.sql.models.ServerVersionCapability;
import com.microsoft.azure.management.sql.models.ServiceObjectiveCapability;
import com.microsoft.azure.management.sql.responses.LocationCapabilitiesGetResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents all the operations for determining the set of capabilites
* available in a specified region.
*/
public class CapabilitiesOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, CapabilitiesOperations {
    /**
    * Initializes a new instance of the CapabilitiesOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    CapabilitiesOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Returns information about the Azure SQL capabilities available for the
    * specified region.
    *
    * @param locationName Required. The name of the region for which the Azure
    * SQL capabilities are retrieved.
    * @return Represents the response to a Get Azure Sql capabilities request
    */
    @Override
    public Future<LocationCapabilitiesGetResponse> getAsync(final String locationName) {
        return this.getClient().getExecutorService().submit(new Callable<LocationCapabilitiesGetResponse>() { 
            @Override
            public LocationCapabilitiesGetResponse call() throws Exception {
                return get(locationName);
            }
         });
    }
    
    /**
    * Returns information about the Azure SQL capabilities available for the
    * specified region.
    *
    * @param locationName Required. The name of the region for which the Azure
    * SQL capabilities are retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql capabilities request
    */
    @Override
    public LocationCapabilitiesGetResponse get(String locationName) throws IOException, ServiceException {
        // Validate
        if (locationName == null) {
            throw new NullPointerException("locationName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("locationName", locationName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/locations/";
        url = url + URLEncoder.encode(locationName, "UTF-8");
        url = url + "/capabilities";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LocationCapabilitiesGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LocationCapabilitiesGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    LocationCapability capabilitiesInstance = new LocationCapability();
                    result.setCapabilities(capabilitiesInstance);
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        capabilitiesInstance.setName(nameInstance);
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        String statusInstance;
                        statusInstance = statusValue.getTextValue();
                        capabilitiesInstance.setStatus(statusInstance);
                    }
                    
                    JsonNode supportedServerVersionsArray = responseDoc.get("supportedServerVersions");
                    if (supportedServerVersionsArray != null && supportedServerVersionsArray instanceof NullNode == false) {
                        for (JsonNode supportedServerVersionsValue : ((ArrayNode) supportedServerVersionsArray)) {
                            ServerVersionCapability serverVersionCapabilityInstance = new ServerVersionCapability();
                            capabilitiesInstance.getSupportedServerVersions().add(serverVersionCapabilityInstance);
                            
                            JsonNode nameValue2 = supportedServerVersionsValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                serverVersionCapabilityInstance.setName(nameInstance2);
                            }
                            
                            JsonNode statusValue2 = supportedServerVersionsValue.get("status");
                            if (statusValue2 != null && statusValue2 instanceof NullNode == false) {
                                String statusInstance2;
                                statusInstance2 = statusValue2.getTextValue();
                                serverVersionCapabilityInstance.setStatus(statusInstance2);
                            }
                            
                            JsonNode supportedEditionsArray = supportedServerVersionsValue.get("supportedEditions");
                            if (supportedEditionsArray != null && supportedEditionsArray instanceof NullNode == false) {
                                for (JsonNode supportedEditionsValue : ((ArrayNode) supportedEditionsArray)) {
                                    EditionCapability editionCapabilityInstance = new EditionCapability();
                                    serverVersionCapabilityInstance.getSupportedEditions().add(editionCapabilityInstance);
                                    
                                    JsonNode nameValue3 = supportedEditionsValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        editionCapabilityInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode statusValue3 = supportedEditionsValue.get("status");
                                    if (statusValue3 != null && statusValue3 instanceof NullNode == false) {
                                        String statusInstance3;
                                        statusInstance3 = statusValue3.getTextValue();
                                        editionCapabilityInstance.setStatus(statusInstance3);
                                    }
                                    
                                    JsonNode supportedServiceLevelObjectivesArray = supportedEditionsValue.get("supportedServiceLevelObjectives");
                                    if (supportedServiceLevelObjectivesArray != null && supportedServiceLevelObjectivesArray instanceof NullNode == false) {
                                        for (JsonNode supportedServiceLevelObjectivesValue : ((ArrayNode) supportedServiceLevelObjectivesArray)) {
                                            ServiceObjectiveCapability serviceObjectiveCapabilityInstance = new ServiceObjectiveCapability();
                                            editionCapabilityInstance.getSupportedServiceObjectives().add(serviceObjectiveCapabilityInstance);
                                            
                                            JsonNode nameValue4 = supportedServiceLevelObjectivesValue.get("name");
                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                String nameInstance4;
                                                nameInstance4 = nameValue4.getTextValue();
                                                serviceObjectiveCapabilityInstance.setName(nameInstance4);
                                            }
                                            
                                            JsonNode statusValue4 = supportedServiceLevelObjectivesValue.get("status");
                                            if (statusValue4 != null && statusValue4 instanceof NullNode == false) {
                                                String statusInstance4;
                                                statusInstance4 = statusValue4.getTextValue();
                                                serviceObjectiveCapabilityInstance.setStatus(statusInstance4);
                                            }
                                            
                                            JsonNode idValue = supportedServiceLevelObjectivesValue.get("id");
                                            if (idValue != null && idValue instanceof NullNode == false) {
                                                String idInstance;
                                                idInstance = idValue.getTextValue();
                                                serviceObjectiveCapabilityInstance.setId(idInstance);
                                            }
                                            
                                            JsonNode supportedMaxSizesArray = supportedServiceLevelObjectivesValue.get("supportedMaxSizes");
                                            if (supportedMaxSizesArray != null && supportedMaxSizesArray instanceof NullNode == false) {
                                                for (JsonNode supportedMaxSizesValue : ((ArrayNode) supportedMaxSizesArray)) {
                                                    MaxSizeCapability maxSizeCapabilityInstance = new MaxSizeCapability();
                                                    serviceObjectiveCapabilityInstance.getSupportedMaxSizes().add(maxSizeCapabilityInstance);
                                                    
                                                    JsonNode limitValue = supportedMaxSizesValue.get("limit");
                                                    if (limitValue != null && limitValue instanceof NullNode == false) {
                                                        int limitInstance;
                                                        limitInstance = limitValue.getIntValue();
                                                        maxSizeCapabilityInstance.setLimit(limitInstance);
                                                    }
                                                    
                                                    JsonNode unitValue = supportedMaxSizesValue.get("unit");
                                                    if (unitValue != null && unitValue instanceof NullNode == false) {
                                                        String unitInstance;
                                                        unitInstance = unitValue.getTextValue();
                                                        maxSizeCapabilityInstance.setUnit(unitInstance);
                                                    }
                                                    
                                                    JsonNode statusValue5 = supportedMaxSizesValue.get("status");
                                                    if (statusValue5 != null && statusValue5 instanceof NullNode == false) {
                                                        String statusInstance5;
                                                        statusInstance5 = statusValue5.getTextValue();
                                                        maxSizeCapabilityInstance.setStatus(statusInstance5);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
