/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DataMaskingPolicyCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.DataMaskingPolicyGetResponse;
import com.microsoft.azure.management.sql.models.DataMaskingRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.DataMaskingRuleGetResponse;
import com.microsoft.azure.management.sql.models.DataMaskingRuleListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database data
* masking. Contains operations to: Create, Retrieve, Update, and Delete data
* masking rules, as well as Create, Retreive and Update data masking policy.
*/
public interface DataMaskingOperations {
    /**
    * Creates or updates an Azure SQL Database data masking policy
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse createOrUpdatePolicy(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Creates or updates an Azure SQL Database data masking policy
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> createOrUpdatePolicyAsync(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyCreateOrUpdateParameters parameters);
    
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database data
    * masking rule.
    * @param parameters Required. The required parameters for createing or
    * updating a data masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse createOrUpdateRule(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule, DataMaskingRuleCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database data
    * masking rule.
    * @param parameters Required. The required parameters for createing or
    * updating a data masking rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> createOrUpdateRuleAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule, DataMaskingRuleCreateOrUpdateParameters parameters);
    
    /**
    * Deletes an Azure SQL Server data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Deletes an Azure SQL Server data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule);
    
    /**
    * Returns an Azure SQL Database data masking policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking policy applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a data masking policy get request.
    */
    DataMaskingPolicyGetResponse getPolicy(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Database data masking policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking policy applies.
    * @return Represents the response to a data masking policy get request.
    */
    Future<DataMaskingPolicyGetResponse> getPolicyAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Returns an Azure SQL Database data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a data masking rule get request.
    */
    DataMaskingRuleGetResponse getRule(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Database data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @return Represents the response to a data masking rule get request.
    */
    Future<DataMaskingRuleGetResponse> getRuleAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule);
    
    /**
    * Returns a list of Azure SQL Database data masking rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rules applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List data masking rules request.
    */
    DataMaskingRuleListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns a list of Azure SQL Database data masking rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rules applies.
    * @return Represents the response to a List data masking rules request.
    */
    Future<DataMaskingRuleListResponse> listAsync(String resourceGroupName, String serverName, String databaseName);
}
