/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DataMaskingPolicy;
import com.microsoft.azure.management.sql.models.DataMaskingPolicyCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.DataMaskingPolicyGetResponse;
import com.microsoft.azure.management.sql.models.DataMaskingPolicyProperties;
import com.microsoft.azure.management.sql.models.DataMaskingRule;
import com.microsoft.azure.management.sql.models.DataMaskingRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.DataMaskingRuleGetResponse;
import com.microsoft.azure.management.sql.models.DataMaskingRuleListResponse;
import com.microsoft.azure.management.sql.models.DataMaskingRuleProperties;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database data
* masking. Contains operations to: Create, Retrieve, Update, and Delete data
* masking rules, as well as Create, Retreive and Update data masking policy.
*/
public class DataMaskingOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, DataMaskingOperations {
    /**
    * Initializes a new instance of the DataMaskingOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DataMaskingOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates or updates an Azure SQL Database data masking policy
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> createOrUpdatePolicyAsync(final String resourceGroupName, final String serverName, final String databaseName, final DataMaskingPolicyCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return createOrUpdatePolicy(resourceGroupName, serverName, databaseName, parameters);
            }
         });
    }
    
    /**
    * Creates or updates an Azure SQL Database data masking policy
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse createOrUpdatePolicy(String resourceGroupName, String serverName, String databaseName, DataMaskingPolicyCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        if (parameters.getProperties().getDataMaskingState() == null) {
            throw new NullPointerException("parameters.Properties.DataMaskingState");
        }
        if (parameters.getProperties().getExemptPrincipals() == null) {
            throw new NullPointerException("parameters.Properties.ExemptPrincipals");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdatePolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode dataMaskingPolicyCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = dataMaskingPolicyCreateOrUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) dataMaskingPolicyCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("dataMaskingState", parameters.getProperties().getDataMaskingState());
        
        ((ObjectNode) propertiesValue).put("exemptPrincipals", parameters.getProperties().getExemptPrincipals());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database data
    * masking rule.
    * @param parameters Required. The required parameters for createing or
    * updating a data masking rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> createOrUpdateRuleAsync(final String resourceGroupName, final String serverName, final String databaseName, final String dataMaskingRule, final DataMaskingRuleCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return createOrUpdateRule(resourceGroupName, serverName, databaseName, dataMaskingRule, parameters);
            }
         });
    }
    
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database data
    * masking rule.
    * @param parameters Required. The required parameters for createing or
    * updating a data masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse createOrUpdateRule(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule, DataMaskingRuleCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (dataMaskingRule == null) {
            throw new NullPointerException("dataMaskingRule");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        if (parameters.getProperties().getId() == null) {
            throw new NullPointerException("parameters.Properties.Id");
        }
        if (parameters.getProperties().getMaskingFunction() == null) {
            throw new NullPointerException("parameters.Properties.MaskingFunction");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("dataMaskingRule", dataMaskingRule);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default/rules/";
        url = url + URLEncoder.encode(dataMaskingRule, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode dataMaskingRuleCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = dataMaskingRuleCreateOrUpdateParametersValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) dataMaskingRuleCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("id", parameters.getProperties().getId());
        
        if (parameters.getProperties().getSchemaName() != null) {
            ((ObjectNode) propertiesValue).put("schemaName", parameters.getProperties().getSchemaName());
        }
        
        if (parameters.getProperties().getTableName() != null) {
            ((ObjectNode) propertiesValue).put("tableName", parameters.getProperties().getTableName());
        }
        
        if (parameters.getProperties().getColumnName() != null) {
            ((ObjectNode) propertiesValue).put("columnName", parameters.getProperties().getColumnName());
        }
        
        ((ObjectNode) propertiesValue).put("maskingFunction", parameters.getProperties().getMaskingFunction());
        
        if (parameters.getProperties().getNumberFrom() != null) {
            ((ObjectNode) propertiesValue).put("numberFrom", parameters.getProperties().getNumberFrom());
        }
        
        if (parameters.getProperties().getNumberTo() != null) {
            ((ObjectNode) propertiesValue).put("numberTo", parameters.getProperties().getNumberTo());
        }
        
        if (parameters.getProperties().getPrefixSize() != null) {
            ((ObjectNode) propertiesValue).put("prefixSize", parameters.getProperties().getPrefixSize());
        }
        
        if (parameters.getProperties().getSuffixSize() != null) {
            ((ObjectNode) propertiesValue).put("suffixSize", parameters.getProperties().getSuffixSize());
        }
        
        if (parameters.getProperties().getReplacementString() != null) {
            ((ObjectNode) propertiesValue).put("replacementString", parameters.getProperties().getReplacementString());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes an Azure SQL Server data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String serverName, final String databaseName, final String dataMaskingRule) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, serverName, databaseName, dataMaskingRule);
            }
         });
    }
    
    /**
    * Deletes an Azure SQL Server data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule) throws IOException, ServiceException, InterruptedException, ExecutionException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (dataMaskingRule == null) {
            throw new NullPointerException("dataMaskingRule");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("dataMaskingRule", dataMaskingRule);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default/rules/";
        url = url + URLEncoder.encode(dataMaskingRule, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns an Azure SQL Database data masking policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking policy applies.
    * @return Represents the response to a data masking policy get request.
    */
    @Override
    public Future<DataMaskingPolicyGetResponse> getPolicyAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DataMaskingPolicyGetResponse>() { 
            @Override
            public DataMaskingPolicyGetResponse call() throws Exception {
                return getPolicy(resourceGroupName, serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns an Azure SQL Database data masking policy.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking policy applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a data masking policy get request.
    */
    @Override
    public DataMaskingPolicyGetResponse getPolicy(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "getPolicyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DataMaskingPolicyGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DataMaskingPolicyGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DataMaskingPolicy dataMaskingPolicyInstance = new DataMaskingPolicy();
                    result.setDataMaskingPolicy(dataMaskingPolicyInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DataMaskingPolicyProperties propertiesInstance = new DataMaskingPolicyProperties();
                        dataMaskingPolicyInstance.setProperties(propertiesInstance);
                        
                        JsonNode dataMaskingStateValue = propertiesValue.get("dataMaskingState");
                        if (dataMaskingStateValue != null && dataMaskingStateValue instanceof NullNode == false) {
                            String dataMaskingStateInstance;
                            dataMaskingStateInstance = dataMaskingStateValue.getTextValue();
                            propertiesInstance.setDataMaskingState(dataMaskingStateInstance);
                        }
                        
                        JsonNode exemptPrincipalsValue = propertiesValue.get("exemptPrincipals");
                        if (exemptPrincipalsValue != null && exemptPrincipalsValue instanceof NullNode == false) {
                            String exemptPrincipalsInstance;
                            exemptPrincipalsInstance = exemptPrincipalsValue.getTextValue();
                            propertiesInstance.setExemptPrincipals(exemptPrincipalsInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        dataMaskingPolicyInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        dataMaskingPolicyInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        dataMaskingPolicyInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        dataMaskingPolicyInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            dataMaskingPolicyInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns an Azure SQL Database data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @return Represents the response to a data masking rule get request.
    */
    @Override
    public Future<DataMaskingRuleGetResponse> getRuleAsync(final String resourceGroupName, final String serverName, final String databaseName, final String dataMaskingRule) {
        return this.getClient().getExecutorService().submit(new Callable<DataMaskingRuleGetResponse>() { 
            @Override
            public DataMaskingRuleGetResponse call() throws Exception {
                return getRule(resourceGroupName, serverName, databaseName, dataMaskingRule);
            }
         });
    }
    
    /**
    * Returns an Azure SQL Database data masking rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rule applies.
    * @param dataMaskingRule Required. The name of the Azure SQL Database  data
    * masking rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a data masking rule get request.
    */
    @Override
    public DataMaskingRuleGetResponse getRule(String resourceGroupName, String serverName, String databaseName, String dataMaskingRule) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (dataMaskingRule == null) {
            throw new NullPointerException("dataMaskingRule");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("dataMaskingRule", dataMaskingRule);
            CloudTracing.enter(invocationId, this, "getRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default/rules/";
        url = url + URLEncoder.encode(dataMaskingRule, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DataMaskingRuleGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DataMaskingRuleGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DataMaskingRule dataMaskingRuleInstance = new DataMaskingRule();
                    result.setDataMaskingRule(dataMaskingRuleInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DataMaskingRuleProperties propertiesInstance = new DataMaskingRuleProperties();
                        dataMaskingRuleInstance.setProperties(propertiesInstance);
                        
                        JsonNode idValue = propertiesValue.get("id");
                        if (idValue != null && idValue instanceof NullNode == false) {
                            String idInstance;
                            idInstance = idValue.getTextValue();
                            propertiesInstance.setId(idInstance);
                        }
                        
                        JsonNode schemaNameValue = propertiesValue.get("schemaName");
                        if (schemaNameValue != null && schemaNameValue instanceof NullNode == false) {
                            String schemaNameInstance;
                            schemaNameInstance = schemaNameValue.getTextValue();
                            propertiesInstance.setSchemaName(schemaNameInstance);
                        }
                        
                        JsonNode tableNameValue = propertiesValue.get("tableName");
                        if (tableNameValue != null && tableNameValue instanceof NullNode == false) {
                            String tableNameInstance;
                            tableNameInstance = tableNameValue.getTextValue();
                            propertiesInstance.setTableName(tableNameInstance);
                        }
                        
                        JsonNode columnNameValue = propertiesValue.get("columnName");
                        if (columnNameValue != null && columnNameValue instanceof NullNode == false) {
                            String columnNameInstance;
                            columnNameInstance = columnNameValue.getTextValue();
                            propertiesInstance.setColumnName(columnNameInstance);
                        }
                        
                        JsonNode maskingFunctionValue = propertiesValue.get("maskingFunction");
                        if (maskingFunctionValue != null && maskingFunctionValue instanceof NullNode == false) {
                            String maskingFunctionInstance;
                            maskingFunctionInstance = maskingFunctionValue.getTextValue();
                            propertiesInstance.setMaskingFunction(maskingFunctionInstance);
                        }
                        
                        JsonNode numberFromValue = propertiesValue.get("numberFrom");
                        if (numberFromValue != null && numberFromValue instanceof NullNode == false) {
                            String numberFromInstance;
                            numberFromInstance = numberFromValue.getTextValue();
                            propertiesInstance.setNumberFrom(numberFromInstance);
                        }
                        
                        JsonNode numberToValue = propertiesValue.get("numberTo");
                        if (numberToValue != null && numberToValue instanceof NullNode == false) {
                            String numberToInstance;
                            numberToInstance = numberToValue.getTextValue();
                            propertiesInstance.setNumberTo(numberToInstance);
                        }
                        
                        JsonNode prefixSizeValue = propertiesValue.get("prefixSize");
                        if (prefixSizeValue != null && prefixSizeValue instanceof NullNode == false) {
                            String prefixSizeInstance;
                            prefixSizeInstance = prefixSizeValue.getTextValue();
                            propertiesInstance.setPrefixSize(prefixSizeInstance);
                        }
                        
                        JsonNode suffixSizeValue = propertiesValue.get("suffixSize");
                        if (suffixSizeValue != null && suffixSizeValue instanceof NullNode == false) {
                            String suffixSizeInstance;
                            suffixSizeInstance = suffixSizeValue.getTextValue();
                            propertiesInstance.setSuffixSize(suffixSizeInstance);
                        }
                        
                        JsonNode replacementStringValue = propertiesValue.get("replacementString");
                        if (replacementStringValue != null && replacementStringValue instanceof NullNode == false) {
                            String replacementStringInstance;
                            replacementStringInstance = replacementStringValue.getTextValue();
                            propertiesInstance.setReplacementString(replacementStringInstance);
                        }
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        dataMaskingRuleInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        dataMaskingRuleInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        dataMaskingRuleInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        dataMaskingRuleInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            dataMaskingRuleInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns a list of Azure SQL Database data masking rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rules applies.
    * @return Represents the response to a List data masking rules request.
    */
    @Override
    public Future<DataMaskingRuleListResponse> listAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DataMaskingRuleListResponse>() { 
            @Override
            public DataMaskingRuleListResponse call() throws Exception {
                return list(resourceGroupName, serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns a list of Azure SQL Database data masking rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the data masking rules applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List data masking rules request.
    */
    @Override
    public DataMaskingRuleListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/dataMaskingPolicies/Default/Rules";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DataMaskingRuleListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DataMaskingRuleListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            DataMaskingRule dataMaskingRuleInstance = new DataMaskingRule();
                            result.getDataMaskingRules().add(dataMaskingRuleInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DataMaskingRuleProperties propertiesInstance = new DataMaskingRuleProperties();
                                dataMaskingRuleInstance.setProperties(propertiesInstance);
                                
                                JsonNode idValue = propertiesValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    propertiesInstance.setId(idInstance);
                                }
                                
                                JsonNode schemaNameValue = propertiesValue.get("schemaName");
                                if (schemaNameValue != null && schemaNameValue instanceof NullNode == false) {
                                    String schemaNameInstance;
                                    schemaNameInstance = schemaNameValue.getTextValue();
                                    propertiesInstance.setSchemaName(schemaNameInstance);
                                }
                                
                                JsonNode tableNameValue = propertiesValue.get("tableName");
                                if (tableNameValue != null && tableNameValue instanceof NullNode == false) {
                                    String tableNameInstance;
                                    tableNameInstance = tableNameValue.getTextValue();
                                    propertiesInstance.setTableName(tableNameInstance);
                                }
                                
                                JsonNode columnNameValue = propertiesValue.get("columnName");
                                if (columnNameValue != null && columnNameValue instanceof NullNode == false) {
                                    String columnNameInstance;
                                    columnNameInstance = columnNameValue.getTextValue();
                                    propertiesInstance.setColumnName(columnNameInstance);
                                }
                                
                                JsonNode maskingFunctionValue = propertiesValue.get("maskingFunction");
                                if (maskingFunctionValue != null && maskingFunctionValue instanceof NullNode == false) {
                                    String maskingFunctionInstance;
                                    maskingFunctionInstance = maskingFunctionValue.getTextValue();
                                    propertiesInstance.setMaskingFunction(maskingFunctionInstance);
                                }
                                
                                JsonNode numberFromValue = propertiesValue.get("numberFrom");
                                if (numberFromValue != null && numberFromValue instanceof NullNode == false) {
                                    String numberFromInstance;
                                    numberFromInstance = numberFromValue.getTextValue();
                                    propertiesInstance.setNumberFrom(numberFromInstance);
                                }
                                
                                JsonNode numberToValue = propertiesValue.get("numberTo");
                                if (numberToValue != null && numberToValue instanceof NullNode == false) {
                                    String numberToInstance;
                                    numberToInstance = numberToValue.getTextValue();
                                    propertiesInstance.setNumberTo(numberToInstance);
                                }
                                
                                JsonNode prefixSizeValue = propertiesValue.get("prefixSize");
                                if (prefixSizeValue != null && prefixSizeValue instanceof NullNode == false) {
                                    String prefixSizeInstance;
                                    prefixSizeInstance = prefixSizeValue.getTextValue();
                                    propertiesInstance.setPrefixSize(prefixSizeInstance);
                                }
                                
                                JsonNode suffixSizeValue = propertiesValue.get("suffixSize");
                                if (suffixSizeValue != null && suffixSizeValue instanceof NullNode == false) {
                                    String suffixSizeInstance;
                                    suffixSizeInstance = suffixSizeValue.getTextValue();
                                    propertiesInstance.setSuffixSize(suffixSizeInstance);
                                }
                                
                                JsonNode replacementStringValue = propertiesValue.get("replacementString");
                                if (replacementStringValue != null && replacementStringValue instanceof NullNode == false) {
                                    String replacementStringInstance;
                                    replacementStringInstance = replacementStringValue.getTextValue();
                                    propertiesInstance.setReplacementString(replacementStringInstance);
                                }
                            }
                            
                            JsonNode idValue2 = valueValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                dataMaskingRuleInstance.setId(idInstance2);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                dataMaskingRuleInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                dataMaskingRuleInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                dataMaskingRuleInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    dataMaskingRuleInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
