/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DatabaseCreateOrUpdateResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating pertaining to activation on Azure
* SQL Data Warehouse databases. Contains operations to: Pause and Resume
* databases
*/
public interface DatabaseActivationOperations {
    /**
    * Start an Azure SQL Data Warehouse database pause operation.To determine
    * the status of the operation call GetDatabaseActivationOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to pause.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database operations.
    */
    DatabaseCreateOrUpdateResponse beginPause(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Start an Azure SQL Data Warehouse database pause operation.To determine
    * the status of the operation call GetDatabaseActivationOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to pause.
    * @return Response for long running Azure Sql Database operations.
    */
    Future<DatabaseCreateOrUpdateResponse> beginPauseAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Start an Azure SQL Data Warehouse database resume operation. To determine
    * the status of the operation call GetDatabaseActivationOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to resume.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database operations.
    */
    DatabaseCreateOrUpdateResponse beginResume(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Start an Azure SQL Data Warehouse database resume operation. To determine
    * the status of the operation call GetDatabaseActivationOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to resume.
    * @return Response for long running Azure Sql Database operations.
    */
    Future<DatabaseCreateOrUpdateResponse> beginResumeAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Gets the status of an Azure SQL Data Warehouse Database pause or resume
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database operations.
    */
    DatabaseCreateOrUpdateResponse getDatabaseActivationOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * Gets the status of an Azure SQL Data Warehouse Database pause or resume
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure Sql Database operations.
    */
    Future<DatabaseCreateOrUpdateResponse> getDatabaseActivationOperationStatusAsync(String operationStatusLink);
    
    /**
    * Start an Azure SQL Data Warehouse database pause operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to pause.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database operations.
    */
    DatabaseCreateOrUpdateResponse pause(String resourceGroupName, String serverName, String databaseName) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * Start an Azure SQL Data Warehouse database pause operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to pause.
    * @return Response for long running Azure Sql Database operations.
    */
    Future<DatabaseCreateOrUpdateResponse> pauseAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Start an Azure SQL Data Warehouse database resume operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to resume.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database operations.
    */
    DatabaseCreateOrUpdateResponse resume(String resourceGroupName, String serverName, String databaseName) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * Start an Azure SQL Data Warehouse database resume operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * data warehouse database is hosted.
    * @param databaseName Required. The name of the Azure SQL Data Warehouse
    * database to resume.
    * @return Response for long running Azure Sql Database operations.
    */
    Future<DatabaseCreateOrUpdateResponse> resumeAsync(String resourceGroupName, String serverName, String databaseName);
}
