/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DatabaseGetResponse;
import com.microsoft.azure.management.sql.models.DatabaseListResponse;
import com.microsoft.azure.management.sql.models.ElasticPoolActivityListResponse;
import com.microsoft.azure.management.sql.models.ElasticPoolCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.ElasticPoolCreateOrUpdateResponse;
import com.microsoft.azure.management.sql.models.ElasticPoolDatabaseActivityListResponse;
import com.microsoft.azure.management.sql.models.ElasticPoolGetResponse;
import com.microsoft.azure.management.sql.models.ElasticPoolListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database Elastic
* Pools.  Contains operations to: Create, Retrieve, Update, and Delete.
*/
public interface ElasticPoolOperations {
    /**
    * Begins creating a new Azure SQL Database Elastic Pool or updating an
    * existing Azure SQL Database Elastic Pool. To determine the status of the
    * operation call GetElasticPoolOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be operated on (Updated or created).
    * @param parameters Required. The required parameters for createing or
    * updating an Elastic Pool.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    ElasticPoolCreateOrUpdateResponse beginCreateOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Begins creating a new Azure SQL Database Elastic Pool or updating an
    * existing Azure SQL Database Elastic Pool. To determine the status of the
    * operation call GetElasticPoolOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be operated on (Updated or created).
    * @param parameters Required. The required parameters for createing or
    * updating an Elastic Pool.
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    Future<ElasticPoolCreateOrUpdateResponse> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolCreateOrUpdateParameters parameters);
    
    /**
    * Creates a new Azure SQL Database Elastic Pool or updates an existing
    * Azure SQL Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be operated on (updated or created).
    * @param parameters Required. The required parameters for createing or
    * updating an Azure Sql Databaser Elastic Pool.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    ElasticPoolCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolCreateOrUpdateParameters parameters) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Creates a new Azure SQL Database Elastic Pool or updates an existing
    * Azure SQL Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be operated on (updated or created).
    * @param parameters Required. The required parameters for createing or
    * updating an Azure Sql Databaser Elastic Pool.
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    Future<ElasticPoolCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolCreateOrUpdateParameters parameters);
    
    /**
    * Deletes the Azure SQL Database Elastic Pool with the given name.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String serverName, String elasticPoolName) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Deletes the Azure SQL Database Elastic Pool with the given name.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String serverName, String elasticPoolName);
    
    /**
    * Returns information about an Azure SQL Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Elastic Pool request.
    */
    ElasticPoolGetResponse get(String resourceGroupName, String serverName, String elasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @return Represents the response to a Get Azure Sql Elastic Pool request.
    */
    Future<ElasticPoolGetResponse> getAsync(String resourceGroupName, String serverName, String elasticPoolName);
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    DatabaseGetResponse getDatabases(String resourceGroupName, String serverName, String elasticPoolName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    Future<DatabaseGetResponse> getDatabasesAsync(String resourceGroupName, String serverName, String elasticPoolName, String databaseName);
    
    /**
    * Gets the status of an Azure Sql Database Elastic Pool create or update
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    ElasticPoolCreateOrUpdateResponse getElasticPoolOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * Gets the status of an Azure Sql Database Elastic Pool create or update
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure Sql Database Elastic Pool
    * operation.
    */
    Future<ElasticPoolCreateOrUpdateResponse> getElasticPoolOperationStatusAsync(String operationStatusLink);
    
    /**
    * Returns information about Azure SQL Database Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Database Elastic Pools are hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Elastic Pool request.
    */
    ElasticPoolListResponse list(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Database Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Database Elastic Pools are hosted.
    * @return Represents the response to a List Azure Sql Elastic Pool request.
    */
    Future<ElasticPoolListResponse> listAsync(String resourceGroupName, String serverName);
    
    /**
    * Returns information about Azure SQL Database Elastic Pool Activity.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Database Elastic Pools are hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool for which to get the current activity.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Elastic Pool Activity
    * request.
    */
    ElasticPoolActivityListResponse listActivity(String resourceGroupName, String serverName, String elasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Database Elastic Pool Activity.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Database Elastic Pools are hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool for which to get the current activity.
    * @return Represents the response to a List Azure Sql Elastic Pool Activity
    * request.
    */
    Future<ElasticPoolActivityListResponse> listActivityAsync(String resourceGroupName, String serverName, String elasticPoolName);
    
    /**
    * Returns information about activity on Azure SQL Databases inside of an
    * Azure Sql Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Elastic Pool Database
    * Activity request.
    */
    ElasticPoolDatabaseActivityListResponse listDatabaseActivity(String resourceGroupName, String serverName, String elasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about activity on Azure SQL Databases inside of an
    * Azure Sql Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Elastic Pool is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool.
    * @return Represents the response to a List Azure Sql Elastic Pool Database
    * Activity request.
    */
    Future<ElasticPoolDatabaseActivityListResponse> listDatabaseActivityAsync(String resourceGroupName, String serverName, String elasticPoolName);
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database request.
    */
    DatabaseListResponse listDatabases(String resourceGroupName, String serverName, String elasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Database Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param elasticPoolName Required. The name of the Azure SQL Database
    * Elastic Pool to be retrieved.
    * @return Represents the response to a List Azure Sql Database request.
    */
    Future<DatabaseListResponse> listDatabasesAsync(String resourceGroupName, String serverName, String elasticPoolName);
}
