/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.FirewallRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.FirewallRuleGetResponse;
import com.microsoft.azure.management.sql.models.FirewallRuleListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database Server
* Firewall Rules.  Contains operations to: Create, Retrieve, Update, and
* Delete firewall rules.
*/
public interface FirewallRuleOperations {
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Firewall Rules request.
    */
    FirewallRuleGetResponse createOrUpdate(String resourceGroupName, String serverName, String firewallRule, FirewallRuleCreateOrUpdateParameters parameters) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Creates or updates an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @param parameters Required. The required parameters for createing or
    * updating a firewall rule.
    * @return Represents the response to a List Firewall Rules request.
    */
    Future<FirewallRuleGetResponse> createOrUpdateAsync(String resourceGroupName, String serverName, String firewallRule, FirewallRuleCreateOrUpdateParameters parameters);
    
    /**
    * Deletes an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String serverName, String firewallRule) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Deletes an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String serverName, String firewallRule);
    
    /**
    * Returns an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Firewall Rules request.
    */
    FirewallRuleGetResponse get(String resourceGroupName, String serverName, String firewallRule) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Database Server Firewall rule.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param firewallRule Required. The name of the Azure SQL Database Server
    * Firewall Rule.
    * @return Represents the response to a List Firewall Rules request.
    */
    Future<FirewallRuleGetResponse> getAsync(String resourceGroupName, String serverName, String firewallRule);
    
    /**
    * Returns a list of Azure SQL Database Server Firewall rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Firewall Rules request.
    */
    FirewallRuleListResponse list(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns a list of Azure SQL Database Server Firewall rules.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @return Represents the response to a List Firewall Rules request.
    */
    Future<FirewallRuleListResponse> listAsync(String resourceGroupName, String serverName);
}
