/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DatabaseGetResponse;
import com.microsoft.azure.management.sql.models.DatabaseListResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolGetResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolListMetricsResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolListResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Recommended Elastic
* Pools.  Contains operations to: Retrieve.
*/
public interface RecommendedElasticPoolOperations {
    /**
    * Returns information about an Azure SQL Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server for
    * which the Azure SQL Recommended Elastic Pool is.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Recommended Resource
    * pool request.
    */
    RecommendedElasticPoolGetResponse get(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server for
    * which the Azure SQL Recommended Elastic Pool is.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a Get Azure Sql Recommended Resource
    * pool request.
    */
    Future<RecommendedElasticPoolGetResponse> getAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName);
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Database Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    DatabaseGetResponse getDatabases(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Database Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    Future<DatabaseGetResponse> getDatabasesAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName);
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    RecommendedElasticPoolListResponse list(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    Future<RecommendedElasticPoolListResponse> listAsync(String resourceGroupName, String serverName);
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database request.
    */
    DatabaseListResponse listDatabases(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a List Azure Sql Database request.
    */
    Future<DatabaseListResponse> listDatabasesAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName);
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @param expand Required. The comma separated list of child objects that we
    * want to expand on in response.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    RecommendedElasticPoolListResponse listExpanded(String resourceGroupName, String serverName, String expand) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @param expand Required. The comma separated list of child objects that we
    * want to expand on in response.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    Future<RecommendedElasticPoolListResponse> listExpandedAsync(String resourceGroupName, String serverName, String expand);
    
    /**
    * Returns information about an recommended elastic pool metrics.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool metrics request.
    */
    RecommendedElasticPoolListMetricsResponse listMetrics(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException;
    
    /**
    * Returns information about an recommended elastic pool metrics.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool metrics request.
    */
    Future<RecommendedElasticPoolListMetricsResponse> listMetricsAsync(String resourceGroupName, String serverName, String recommendedElasticPoolName);
}
