/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.Column;
import com.microsoft.azure.management.sql.models.ColumnProperties;
import com.microsoft.azure.management.sql.models.Database;
import com.microsoft.azure.management.sql.models.DatabaseGetResponse;
import com.microsoft.azure.management.sql.models.DatabaseListResponse;
import com.microsoft.azure.management.sql.models.DatabaseProperties;
import com.microsoft.azure.management.sql.models.OperationImpact;
import com.microsoft.azure.management.sql.models.RecommendedElasticPool;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolGetResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolListMetricsResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolListResponse;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolMetric;
import com.microsoft.azure.management.sql.models.RecommendedElasticPoolProperties;
import com.microsoft.azure.management.sql.models.RecommendedIndex;
import com.microsoft.azure.management.sql.models.RecommendedIndexProperties;
import com.microsoft.azure.management.sql.models.Schema;
import com.microsoft.azure.management.sql.models.SchemaProperties;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisorProperties;
import com.microsoft.azure.management.sql.models.SloUsageMetric;
import com.microsoft.azure.management.sql.models.Table;
import com.microsoft.azure.management.sql.models.TableProperties;
import com.microsoft.azure.management.sql.models.UpgradeHint;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Recommended Elastic
* Pools.  Contains operations to: Retrieve.
*/
public class RecommendedElasticPoolOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, RecommendedElasticPoolOperations {
    /**
    * Initializes a new instance of the RecommendedElasticPoolOperationsImpl
    * class.
    *
    * @param client Reference to the service client.
    */
    RecommendedElasticPoolOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Returns information about an Azure SQL Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server for
    * which the Azure SQL Recommended Elastic Pool is.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a Get Azure Sql Recommended Resource
    * pool request.
    */
    @Override
    public Future<RecommendedElasticPoolGetResponse> getAsync(final String resourceGroupName, final String serverName, final String recommendedElasticPoolName) {
        return this.getClient().getExecutorService().submit(new Callable<RecommendedElasticPoolGetResponse>() { 
            @Override
            public RecommendedElasticPoolGetResponse call() throws Exception {
                return get(resourceGroupName, serverName, recommendedElasticPoolName);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server for
    * which the Azure SQL Recommended Elastic Pool is.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Recommended Resource
    * pool request.
    */
    @Override
    public RecommendedElasticPoolGetResponse get(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (recommendedElasticPoolName == null) {
            throw new NullPointerException("recommendedElasticPoolName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("recommendedElasticPoolName", recommendedElasticPoolName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools/";
        url = url + URLEncoder.encode(recommendedElasticPoolName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            RecommendedElasticPoolGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecommendedElasticPoolGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    RecommendedElasticPool recommendedElasticPoolInstance = new RecommendedElasticPool();
                    result.setRecommendedElasticPool(recommendedElasticPoolInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        RecommendedElasticPoolProperties propertiesInstance = new RecommendedElasticPoolProperties();
                        recommendedElasticPoolInstance.setProperties(propertiesInstance);
                        
                        JsonNode databaseEditionValue = propertiesValue.get("databaseEdition");
                        if (databaseEditionValue != null && databaseEditionValue instanceof NullNode == false) {
                            String databaseEditionInstance;
                            databaseEditionInstance = databaseEditionValue.getTextValue();
                            propertiesInstance.setDatabaseEdition(databaseEditionInstance);
                        }
                        
                        JsonNode dtuValue = propertiesValue.get("dtu");
                        if (dtuValue != null && dtuValue instanceof NullNode == false) {
                            double dtuInstance;
                            dtuInstance = dtuValue.getDoubleValue();
                            propertiesInstance.setDtu(dtuInstance);
                        }
                        
                        JsonNode databaseDtuMinValue = propertiesValue.get("databaseDtuMin");
                        if (databaseDtuMinValue != null && databaseDtuMinValue instanceof NullNode == false) {
                            double databaseDtuMinInstance;
                            databaseDtuMinInstance = databaseDtuMinValue.getDoubleValue();
                            propertiesInstance.setDatabaseDtuMin(databaseDtuMinInstance);
                        }
                        
                        JsonNode databaseDtuMaxValue = propertiesValue.get("databaseDtuMax");
                        if (databaseDtuMaxValue != null && databaseDtuMaxValue instanceof NullNode == false) {
                            double databaseDtuMaxInstance;
                            databaseDtuMaxInstance = databaseDtuMaxValue.getDoubleValue();
                            propertiesInstance.setDatabaseDtuMax(databaseDtuMaxInstance);
                        }
                        
                        JsonNode storageMBValue = propertiesValue.get("storageMB");
                        if (storageMBValue != null && storageMBValue instanceof NullNode == false) {
                            double storageMBInstance;
                            storageMBInstance = storageMBValue.getDoubleValue();
                            propertiesInstance.setStorageMB(storageMBInstance);
                        }
                        
                        JsonNode observationPeriodStartValue = propertiesValue.get("observationPeriodStart");
                        if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                            Calendar observationPeriodStartInstance;
                            observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                            propertiesInstance.setObservationPeriodStart(observationPeriodStartInstance);
                        }
                        
                        JsonNode observationPeriodEndValue = propertiesValue.get("observationPeriodEnd");
                        if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                            Calendar observationPeriodEndInstance;
                            observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                            propertiesInstance.setObservationPeriodEnd(observationPeriodEndInstance);
                        }
                        
                        JsonNode maxObservedDtuValue = propertiesValue.get("maxObservedDtu");
                        if (maxObservedDtuValue != null && maxObservedDtuValue instanceof NullNode == false) {
                            double maxObservedDtuInstance;
                            maxObservedDtuInstance = maxObservedDtuValue.getDoubleValue();
                            propertiesInstance.setMaxObservedDtu(maxObservedDtuInstance);
                        }
                        
                        JsonNode maxObservedStorageMBValue = propertiesValue.get("maxObservedStorageMB");
                        if (maxObservedStorageMBValue != null && maxObservedStorageMBValue instanceof NullNode == false) {
                            double maxObservedStorageMBInstance;
                            maxObservedStorageMBInstance = maxObservedStorageMBValue.getDoubleValue();
                            propertiesInstance.setMaxObservedStorageMB(maxObservedStorageMBInstance);
                        }
                        
                        JsonNode databasesArray = propertiesValue.get("databases");
                        if (databasesArray != null && databasesArray instanceof NullNode == false) {
                            for (JsonNode databasesValue : ((ArrayNode) databasesArray)) {
                                Database databaseInstance = new Database();
                                propertiesInstance.getDatabases().add(databaseInstance);
                                
                                JsonNode propertiesValue2 = databasesValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    DatabaseProperties propertiesInstance2 = new DatabaseProperties();
                                    databaseInstance.setProperties(propertiesInstance2);
                                    
                                    JsonNode collationValue = propertiesValue2.get("collation");
                                    if (collationValue != null && collationValue instanceof NullNode == false) {
                                        String collationInstance;
                                        collationInstance = collationValue.getTextValue();
                                        propertiesInstance2.setCollation(collationInstance);
                                    }
                                    
                                    JsonNode creationDateValue = propertiesValue2.get("creationDate");
                                    if (creationDateValue != null && creationDateValue instanceof NullNode == false) {
                                        Calendar creationDateInstance;
                                        creationDateInstance = DatatypeConverter.parseDateTime(creationDateValue.getTextValue());
                                        propertiesInstance2.setCreationDate(creationDateInstance);
                                    }
                                    
                                    JsonNode currentServiceObjectiveIdValue = propertiesValue2.get("currentServiceObjectiveId");
                                    if (currentServiceObjectiveIdValue != null && currentServiceObjectiveIdValue instanceof NullNode == false) {
                                        String currentServiceObjectiveIdInstance;
                                        currentServiceObjectiveIdInstance = currentServiceObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setCurrentServiceObjectiveId(currentServiceObjectiveIdInstance);
                                    }
                                    
                                    JsonNode databaseIdValue = propertiesValue2.get("databaseId");
                                    if (databaseIdValue != null && databaseIdValue instanceof NullNode == false) {
                                        String databaseIdInstance;
                                        databaseIdInstance = databaseIdValue.getTextValue();
                                        propertiesInstance2.setDatabaseId(databaseIdInstance);
                                    }
                                    
                                    JsonNode earliestRestoreDateValue = propertiesValue2.get("earliestRestoreDate");
                                    if (earliestRestoreDateValue != null && earliestRestoreDateValue instanceof NullNode == false) {
                                        Calendar earliestRestoreDateInstance;
                                        earliestRestoreDateInstance = DatatypeConverter.parseDateTime(earliestRestoreDateValue.getTextValue());
                                        propertiesInstance2.setEarliestRestoreDate(earliestRestoreDateInstance);
                                    }
                                    
                                    JsonNode editionValue = propertiesValue2.get("edition");
                                    if (editionValue != null && editionValue instanceof NullNode == false) {
                                        String editionInstance;
                                        editionInstance = editionValue.getTextValue();
                                        propertiesInstance2.setEdition(editionInstance);
                                    }
                                    
                                    JsonNode maxSizeBytesValue = propertiesValue2.get("maxSizeBytes");
                                    if (maxSizeBytesValue != null && maxSizeBytesValue instanceof NullNode == false) {
                                        long maxSizeBytesInstance;
                                        maxSizeBytesInstance = maxSizeBytesValue.getLongValue();
                                        propertiesInstance2.setMaxSizeBytes(maxSizeBytesInstance);
                                    }
                                    
                                    JsonNode requestedServiceObjectiveIdValue = propertiesValue2.get("requestedServiceObjectiveId");
                                    if (requestedServiceObjectiveIdValue != null && requestedServiceObjectiveIdValue instanceof NullNode == false) {
                                        String requestedServiceObjectiveIdInstance;
                                        requestedServiceObjectiveIdInstance = requestedServiceObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setRequestedServiceObjectiveId(requestedServiceObjectiveIdInstance);
                                    }
                                    
                                    JsonNode requestedServiceObjectiveNameValue = propertiesValue2.get("requestedServiceObjectiveName");
                                    if (requestedServiceObjectiveNameValue != null && requestedServiceObjectiveNameValue instanceof NullNode == false) {
                                        String requestedServiceObjectiveNameInstance;
                                        requestedServiceObjectiveNameInstance = requestedServiceObjectiveNameValue.getTextValue();
                                        propertiesInstance2.setRequestedServiceObjectiveName(requestedServiceObjectiveNameInstance);
                                    }
                                    
                                    JsonNode serviceLevelObjectiveValue = propertiesValue2.get("serviceLevelObjective");
                                    if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                        String serviceLevelObjectiveInstance;
                                        serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setServiceObjective(serviceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode statusValue = propertiesValue2.get("status");
                                    if (statusValue != null && statusValue instanceof NullNode == false) {
                                        String statusInstance;
                                        statusInstance = statusValue.getTextValue();
                                        propertiesInstance2.setStatus(statusInstance);
                                    }
                                    
                                    JsonNode elasticPoolNameValue = propertiesValue2.get("elasticPoolName");
                                    if (elasticPoolNameValue != null && elasticPoolNameValue instanceof NullNode == false) {
                                        String elasticPoolNameInstance;
                                        elasticPoolNameInstance = elasticPoolNameValue.getTextValue();
                                        propertiesInstance2.setElasticPoolName(elasticPoolNameInstance);
                                    }
                                    
                                    JsonNode serviceTierAdvisorsArray = propertiesValue2.get("serviceTierAdvisors");
                                    if (serviceTierAdvisorsArray != null && serviceTierAdvisorsArray instanceof NullNode == false) {
                                        for (JsonNode serviceTierAdvisorsValue : ((ArrayNode) serviceTierAdvisorsArray)) {
                                            ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                                            propertiesInstance2.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                                            
                                            JsonNode propertiesValue3 = serviceTierAdvisorsValue.get("properties");
                                            if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                                ServiceTierAdvisorProperties propertiesInstance3 = new ServiceTierAdvisorProperties();
                                                serviceTierAdvisorInstance.setProperties(propertiesInstance3);
                                                
                                                JsonNode observationPeriodStartValue2 = propertiesValue3.get("observationPeriodStart");
                                                if (observationPeriodStartValue2 != null && observationPeriodStartValue2 instanceof NullNode == false) {
                                                    Calendar observationPeriodStartInstance2;
                                                    observationPeriodStartInstance2 = DatatypeConverter.parseDateTime(observationPeriodStartValue2.getTextValue());
                                                    propertiesInstance3.setObservationPeriodStart(observationPeriodStartInstance2);
                                                }
                                                
                                                JsonNode observationPeriodEndValue2 = propertiesValue3.get("observationPeriodEnd");
                                                if (observationPeriodEndValue2 != null && observationPeriodEndValue2 instanceof NullNode == false) {
                                                    Calendar observationPeriodEndInstance2;
                                                    observationPeriodEndInstance2 = DatatypeConverter.parseDateTime(observationPeriodEndValue2.getTextValue());
                                                    propertiesInstance3.setObservationPeriodEnd(observationPeriodEndInstance2);
                                                }
                                                
                                                JsonNode activeTimeRatioValue = propertiesValue3.get("activeTimeRatio");
                                                if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                                    double activeTimeRatioInstance;
                                                    activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                                    propertiesInstance3.setActiveTimeRatio(activeTimeRatioInstance);
                                                }
                                                
                                                JsonNode minDtuValue = propertiesValue3.get("minDtu");
                                                if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                                    double minDtuInstance;
                                                    minDtuInstance = minDtuValue.getDoubleValue();
                                                    propertiesInstance3.setMinDtu(minDtuInstance);
                                                }
                                                
                                                JsonNode avgDtuValue = propertiesValue3.get("avgDtu");
                                                if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                                    double avgDtuInstance;
                                                    avgDtuInstance = avgDtuValue.getDoubleValue();
                                                    propertiesInstance3.setAvgDtu(avgDtuInstance);
                                                }
                                                
                                                JsonNode maxDtuValue = propertiesValue3.get("maxDtu");
                                                if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                                    double maxDtuInstance;
                                                    maxDtuInstance = maxDtuValue.getDoubleValue();
                                                    propertiesInstance3.setMaxDtu(maxDtuInstance);
                                                }
                                                
                                                JsonNode maxSizeInGBValue = propertiesValue3.get("maxSizeInGB");
                                                if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                                    double maxSizeInGBInstance;
                                                    maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                                    propertiesInstance3.setMaxSizeInGB(maxSizeInGBInstance);
                                                }
                                                
                                                JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue3.get("serviceLevelObjectiveUsageMetrics");
                                                if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                                    for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                                        SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                                        propertiesInstance3.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                                        
                                                        JsonNode serviceLevelObjectiveValue2 = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                                        if (serviceLevelObjectiveValue2 != null && serviceLevelObjectiveValue2 instanceof NullNode == false) {
                                                            String serviceLevelObjectiveInstance2;
                                                            serviceLevelObjectiveInstance2 = serviceLevelObjectiveValue2.getTextValue();
                                                            sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance2);
                                                        }
                                                        
                                                        JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                                        if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String serviceLevelObjectiveIdInstance;
                                                            serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                                            sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                                        if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                                            double inRangeTimeRatioInstance;
                                                            inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                                            sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                                        }
                                                        
                                                        JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                                        if (idValue != null && idValue instanceof NullNode == false) {
                                                            String idInstance;
                                                            idInstance = idValue.getTextValue();
                                                            sloUsageMetricInstance.setId(idInstance);
                                                        }
                                                        
                                                        JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                                            String nameInstance;
                                                            nameInstance = nameValue.getTextValue();
                                                            sloUsageMetricInstance.setName(nameInstance);
                                                        }
                                                        
                                                        JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                                        if (typeValue != null && typeValue instanceof NullNode == false) {
                                                            String typeInstance;
                                                            typeInstance = typeValue.getTextValue();
                                                            sloUsageMetricInstance.setType(typeInstance);
                                                        }
                                                        
                                                        JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                                        if (locationValue != null && locationValue instanceof NullNode == false) {
                                                            String locationInstance;
                                                            locationInstance = locationValue.getTextValue();
                                                            sloUsageMetricInstance.setLocation(locationInstance);
                                                        }
                                                        
                                                        JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                                            while (itr.hasNext()) {
                                                                Map.Entry<String, JsonNode> property = itr.next();
                                                                String tagsKey = property.getKey();
                                                                String tagsValue = property.getValue().getTextValue();
                                                                sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                                            }
                                                        }
                                                    }
                                                }
                                                
                                                JsonNode currentServiceLevelObjectiveValue = propertiesValue3.get("currentServiceLevelObjective");
                                                if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String currentServiceLevelObjectiveInstance;
                                                    currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                                    propertiesInstance3.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode currentServiceLevelObjectiveIdValue = propertiesValue3.get("currentServiceLevelObjectiveId");
                                                if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String currentServiceLevelObjectiveIdInstance;
                                                    currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                                    propertiesInstance3.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjective");
                                                if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String usageBasedRecommendationServiceLevelObjectiveInstance;
                                                    usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                    propertiesInstance3.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjectiveId");
                                                if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                                    usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                    propertiesInstance3.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                                if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                                    databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                    propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                                if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                                    databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                    propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                                if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                                    disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                    propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                                if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                                    disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                    propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue3.get("overallRecommendationServiceLevelObjective");
                                                if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String overallRecommendationServiceLevelObjectiveInstance;
                                                    overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                                    propertiesInstance3.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("overallRecommendationServiceLevelObjectiveId");
                                                if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String overallRecommendationServiceLevelObjectiveIdInstance;
                                                    overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                    propertiesInstance3.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode confidenceValue = propertiesValue3.get("confidence");
                                                if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                                    double confidenceInstance;
                                                    confidenceInstance = confidenceValue.getDoubleValue();
                                                    propertiesInstance3.setConfidence(confidenceInstance);
                                                }
                                            }
                                            
                                            JsonNode idValue2 = serviceTierAdvisorsValue.get("id");
                                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                String idInstance2;
                                                idInstance2 = idValue2.getTextValue();
                                                serviceTierAdvisorInstance.setId(idInstance2);
                                            }
                                            
                                            JsonNode nameValue2 = serviceTierAdvisorsValue.get("name");
                                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                                String nameInstance2;
                                                nameInstance2 = nameValue2.getTextValue();
                                                serviceTierAdvisorInstance.setName(nameInstance2);
                                            }
                                            
                                            JsonNode typeValue2 = serviceTierAdvisorsValue.get("type");
                                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                String typeInstance2;
                                                typeInstance2 = typeValue2.getTextValue();
                                                serviceTierAdvisorInstance.setType(typeInstance2);
                                            }
                                            
                                            JsonNode locationValue2 = serviceTierAdvisorsValue.get("location");
                                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                                String locationInstance2;
                                                locationInstance2 = locationValue2.getTextValue();
                                                serviceTierAdvisorInstance.setLocation(locationInstance2);
                                            }
                                            
                                            JsonNode tagsSequenceElement2 = ((JsonNode) serviceTierAdvisorsValue.get("tags"));
                                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                                while (itr2.hasNext()) {
                                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                                    String tagsKey2 = property2.getKey();
                                                    String tagsValue2 = property2.getValue().getTextValue();
                                                    serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode upgradeHintValue = propertiesValue2.get("upgradeHint");
                                    if (upgradeHintValue != null && upgradeHintValue instanceof NullNode == false) {
                                        UpgradeHint upgradeHintInstance = new UpgradeHint();
                                        propertiesInstance2.setUpgradeHint(upgradeHintInstance);
                                        
                                        JsonNode targetServiceLevelObjectiveValue = upgradeHintValue.get("targetServiceLevelObjective");
                                        if (targetServiceLevelObjectiveValue != null && targetServiceLevelObjectiveValue instanceof NullNode == false) {
                                            String targetServiceLevelObjectiveInstance;
                                            targetServiceLevelObjectiveInstance = targetServiceLevelObjectiveValue.getTextValue();
                                            upgradeHintInstance.setTargetServiceLevelObjective(targetServiceLevelObjectiveInstance);
                                        }
                                        
                                        JsonNode targetServiceLevelObjectiveIdValue = upgradeHintValue.get("targetServiceLevelObjectiveId");
                                        if (targetServiceLevelObjectiveIdValue != null && targetServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                            String targetServiceLevelObjectiveIdInstance;
                                            targetServiceLevelObjectiveIdInstance = targetServiceLevelObjectiveIdValue.getTextValue();
                                            upgradeHintInstance.setTargetServiceLevelObjectiveId(targetServiceLevelObjectiveIdInstance);
                                        }
                                        
                                        JsonNode idValue3 = upgradeHintValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            upgradeHintInstance.setId(idInstance3);
                                        }
                                        
                                        JsonNode nameValue3 = upgradeHintValue.get("name");
                                        if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                            String nameInstance3;
                                            nameInstance3 = nameValue3.getTextValue();
                                            upgradeHintInstance.setName(nameInstance3);
                                        }
                                        
                                        JsonNode typeValue3 = upgradeHintValue.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            String typeInstance3;
                                            typeInstance3 = typeValue3.getTextValue();
                                            upgradeHintInstance.setType(typeInstance3);
                                        }
                                        
                                        JsonNode locationValue3 = upgradeHintValue.get("location");
                                        if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                            String locationInstance3;
                                            locationInstance3 = locationValue3.getTextValue();
                                            upgradeHintInstance.setLocation(locationInstance3);
                                        }
                                        
                                        JsonNode tagsSequenceElement3 = ((JsonNode) upgradeHintValue.get("tags"));
                                        if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                            while (itr3.hasNext()) {
                                                Map.Entry<String, JsonNode> property3 = itr3.next();
                                                String tagsKey3 = property3.getKey();
                                                String tagsValue3 = property3.getValue().getTextValue();
                                                upgradeHintInstance.getTags().put(tagsKey3, tagsValue3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode schemasArray = propertiesValue2.get("schemas");
                                    if (schemasArray != null && schemasArray instanceof NullNode == false) {
                                        for (JsonNode schemasValue : ((ArrayNode) schemasArray)) {
                                            Schema schemaInstance = new Schema();
                                            propertiesInstance2.getSchemas().add(schemaInstance);
                                            
                                            JsonNode propertiesValue4 = schemasValue.get("properties");
                                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                                SchemaProperties propertiesInstance4 = new SchemaProperties();
                                                schemaInstance.setProperties(propertiesInstance4);
                                                
                                                JsonNode tablesArray = propertiesValue4.get("tables");
                                                if (tablesArray != null && tablesArray instanceof NullNode == false) {
                                                    for (JsonNode tablesValue : ((ArrayNode) tablesArray)) {
                                                        Table tableInstance = new Table();
                                                        propertiesInstance4.getTables().add(tableInstance);
                                                        
                                                        JsonNode propertiesValue5 = tablesValue.get("properties");
                                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                                            TableProperties propertiesInstance5 = new TableProperties();
                                                            tableInstance.setProperties(propertiesInstance5);
                                                            
                                                            JsonNode tableTypeValue = propertiesValue5.get("tableType");
                                                            if (tableTypeValue != null && tableTypeValue instanceof NullNode == false) {
                                                                String tableTypeInstance;
                                                                tableTypeInstance = tableTypeValue.getTextValue();
                                                                propertiesInstance5.setTableType(tableTypeInstance);
                                                            }
                                                            
                                                            JsonNode columnsArray = propertiesValue5.get("columns");
                                                            if (columnsArray != null && columnsArray instanceof NullNode == false) {
                                                                for (JsonNode columnsValue : ((ArrayNode) columnsArray)) {
                                                                    Column columnInstance = new Column();
                                                                    propertiesInstance5.getColumns().add(columnInstance);
                                                                    
                                                                    JsonNode propertiesValue6 = columnsValue.get("properties");
                                                                    if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                                                        ColumnProperties propertiesInstance6 = new ColumnProperties();
                                                                        columnInstance.setProperties(propertiesInstance6);
                                                                        
                                                                        JsonNode columnTypeValue = propertiesValue6.get("columnType");
                                                                        if (columnTypeValue != null && columnTypeValue instanceof NullNode == false) {
                                                                            String columnTypeInstance;
                                                                            columnTypeInstance = columnTypeValue.getTextValue();
                                                                            propertiesInstance6.setColumnType(columnTypeInstance);
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode idValue4 = columnsValue.get("id");
                                                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                                        String idInstance4;
                                                                        idInstance4 = idValue4.getTextValue();
                                                                        columnInstance.setId(idInstance4);
                                                                    }
                                                                    
                                                                    JsonNode nameValue4 = columnsValue.get("name");
                                                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                                        String nameInstance4;
                                                                        nameInstance4 = nameValue4.getTextValue();
                                                                        columnInstance.setName(nameInstance4);
                                                                    }
                                                                    
                                                                    JsonNode typeValue4 = columnsValue.get("type");
                                                                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                                        String typeInstance4;
                                                                        typeInstance4 = typeValue4.getTextValue();
                                                                        columnInstance.setType(typeInstance4);
                                                                    }
                                                                    
                                                                    JsonNode locationValue4 = columnsValue.get("location");
                                                                    if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                                                        String locationInstance4;
                                                                        locationInstance4 = locationValue4.getTextValue();
                                                                        columnInstance.setLocation(locationInstance4);
                                                                    }
                                                                    
                                                                    JsonNode tagsSequenceElement4 = ((JsonNode) columnsValue.get("tags"));
                                                                    if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                                                        Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                                                        while (itr4.hasNext()) {
                                                                            Map.Entry<String, JsonNode> property4 = itr4.next();
                                                                            String tagsKey4 = property4.getKey();
                                                                            String tagsValue4 = property4.getValue().getTextValue();
                                                                            columnInstance.getTags().put(tagsKey4, tagsValue4);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            
                                                            JsonNode recommendedIndexesArray = propertiesValue5.get("recommendedIndexes");
                                                            if (recommendedIndexesArray != null && recommendedIndexesArray instanceof NullNode == false) {
                                                                for (JsonNode recommendedIndexesValue : ((ArrayNode) recommendedIndexesArray)) {
                                                                    RecommendedIndex recommendedIndexInstance = new RecommendedIndex();
                                                                    propertiesInstance5.getRecommendedIndexes().add(recommendedIndexInstance);
                                                                    
                                                                    JsonNode propertiesValue7 = recommendedIndexesValue.get("properties");
                                                                    if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                                                        RecommendedIndexProperties propertiesInstance7 = new RecommendedIndexProperties();
                                                                        recommendedIndexInstance.setProperties(propertiesInstance7);
                                                                        
                                                                        JsonNode actionValue = propertiesValue7.get("action");
                                                                        if (actionValue != null && actionValue instanceof NullNode == false) {
                                                                            String actionInstance;
                                                                            actionInstance = actionValue.getTextValue();
                                                                            propertiesInstance7.setAction(actionInstance);
                                                                        }
                                                                        
                                                                        JsonNode stateValue = propertiesValue7.get("state");
                                                                        if (stateValue != null && stateValue instanceof NullNode == false) {
                                                                            String stateInstance;
                                                                            stateInstance = stateValue.getTextValue();
                                                                            propertiesInstance7.setState(stateInstance);
                                                                        }
                                                                        
                                                                        JsonNode createdValue = propertiesValue7.get("created");
                                                                        if (createdValue != null && createdValue instanceof NullNode == false) {
                                                                            Calendar createdInstance;
                                                                            createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                                                            propertiesInstance7.setCreated(createdInstance);
                                                                        }
                                                                        
                                                                        JsonNode lastModifiedValue = propertiesValue7.get("lastModified");
                                                                        if (lastModifiedValue != null && lastModifiedValue instanceof NullNode == false) {
                                                                            Calendar lastModifiedInstance;
                                                                            lastModifiedInstance = DatatypeConverter.parseDateTime(lastModifiedValue.getTextValue());
                                                                            propertiesInstance7.setLastModified(lastModifiedInstance);
                                                                        }
                                                                        
                                                                        JsonNode indexTypeValue = propertiesValue7.get("indexType");
                                                                        if (indexTypeValue != null && indexTypeValue instanceof NullNode == false) {
                                                                            String indexTypeInstance;
                                                                            indexTypeInstance = indexTypeValue.getTextValue();
                                                                            propertiesInstance7.setIndexType(indexTypeInstance);
                                                                        }
                                                                        
                                                                        JsonNode schemaValue = propertiesValue7.get("schema");
                                                                        if (schemaValue != null && schemaValue instanceof NullNode == false) {
                                                                            String schemaInstance2;
                                                                            schemaInstance2 = schemaValue.getTextValue();
                                                                            propertiesInstance7.setSchema(schemaInstance2);
                                                                        }
                                                                        
                                                                        JsonNode tableValue = propertiesValue7.get("table");
                                                                        if (tableValue != null && tableValue instanceof NullNode == false) {
                                                                            String tableInstance2;
                                                                            tableInstance2 = tableValue.getTextValue();
                                                                            propertiesInstance7.setTable(tableInstance2);
                                                                        }
                                                                        
                                                                        JsonNode columnsArray2 = propertiesValue7.get("columns");
                                                                        if (columnsArray2 != null && columnsArray2 instanceof NullNode == false) {
                                                                            for (JsonNode columnsValue2 : ((ArrayNode) columnsArray2)) {
                                                                                propertiesInstance7.getColumns().add(columnsValue2.getTextValue());
                                                                            }
                                                                        }
                                                                        
                                                                        JsonNode includedColumnsArray = propertiesValue7.get("includedColumns");
                                                                        if (includedColumnsArray != null && includedColumnsArray instanceof NullNode == false) {
                                                                            for (JsonNode includedColumnsValue : ((ArrayNode) includedColumnsArray)) {
                                                                                propertiesInstance7.getIncludedColumns().add(includedColumnsValue.getTextValue());
                                                                            }
                                                                        }
                                                                        
                                                                        JsonNode indexScriptValue = propertiesValue7.get("indexScript");
                                                                        if (indexScriptValue != null && indexScriptValue instanceof NullNode == false) {
                                                                            String indexScriptInstance;
                                                                            indexScriptInstance = indexScriptValue.getTextValue();
                                                                            propertiesInstance7.setIndexScript(indexScriptInstance);
                                                                        }
                                                                        
                                                                        JsonNode estimatedImpactArray = propertiesValue7.get("estimatedImpact");
                                                                        if (estimatedImpactArray != null && estimatedImpactArray instanceof NullNode == false) {
                                                                            for (JsonNode estimatedImpactValue : ((ArrayNode) estimatedImpactArray)) {
                                                                                OperationImpact operationImpactInstance = new OperationImpact();
                                                                                propertiesInstance7.getEstimatedImpact().add(operationImpactInstance);
                                                                                
                                                                                JsonNode nameValue5 = estimatedImpactValue.get("name");
                                                                                if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                                                    String nameInstance5;
                                                                                    nameInstance5 = nameValue5.getTextValue();
                                                                                    operationImpactInstance.setName(nameInstance5);
                                                                                }
                                                                                
                                                                                JsonNode unitValue = estimatedImpactValue.get("unit");
                                                                                if (unitValue != null && unitValue instanceof NullNode == false) {
                                                                                    String unitInstance;
                                                                                    unitInstance = unitValue.getTextValue();
                                                                                    operationImpactInstance.setUnit(unitInstance);
                                                                                }
                                                                                
                                                                                JsonNode changeValueAbsoluteValue = estimatedImpactValue.get("changeValueAbsolute");
                                                                                if (changeValueAbsoluteValue != null && changeValueAbsoluteValue instanceof NullNode == false) {
                                                                                    double changeValueAbsoluteInstance;
                                                                                    changeValueAbsoluteInstance = changeValueAbsoluteValue.getDoubleValue();
                                                                                    operationImpactInstance.setChangeValueAbsolute(changeValueAbsoluteInstance);
                                                                                }
                                                                                
                                                                                JsonNode changeValueRelativeValue = estimatedImpactValue.get("changeValueRelative");
                                                                                if (changeValueRelativeValue != null && changeValueRelativeValue instanceof NullNode == false) {
                                                                                    double changeValueRelativeInstance;
                                                                                    changeValueRelativeInstance = changeValueRelativeValue.getDoubleValue();
                                                                                    operationImpactInstance.setChangeValueRelative(changeValueRelativeInstance);
                                                                                }
                                                                            }
                                                                        }
                                                                        
                                                                        JsonNode reportedImpactArray = propertiesValue7.get("reportedImpact");
                                                                        if (reportedImpactArray != null && reportedImpactArray instanceof NullNode == false) {
                                                                            for (JsonNode reportedImpactValue : ((ArrayNode) reportedImpactArray)) {
                                                                                OperationImpact operationImpactInstance2 = new OperationImpact();
                                                                                propertiesInstance7.getReportedImpact().add(operationImpactInstance2);
                                                                                
                                                                                JsonNode nameValue6 = reportedImpactValue.get("name");
                                                                                if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                                                    String nameInstance6;
                                                                                    nameInstance6 = nameValue6.getTextValue();
                                                                                    operationImpactInstance2.setName(nameInstance6);
                                                                                }
                                                                                
                                                                                JsonNode unitValue2 = reportedImpactValue.get("unit");
                                                                                if (unitValue2 != null && unitValue2 instanceof NullNode == false) {
                                                                                    String unitInstance2;
                                                                                    unitInstance2 = unitValue2.getTextValue();
                                                                                    operationImpactInstance2.setUnit(unitInstance2);
                                                                                }
                                                                                
                                                                                JsonNode changeValueAbsoluteValue2 = reportedImpactValue.get("changeValueAbsolute");
                                                                                if (changeValueAbsoluteValue2 != null && changeValueAbsoluteValue2 instanceof NullNode == false) {
                                                                                    double changeValueAbsoluteInstance2;
                                                                                    changeValueAbsoluteInstance2 = changeValueAbsoluteValue2.getDoubleValue();
                                                                                    operationImpactInstance2.setChangeValueAbsolute(changeValueAbsoluteInstance2);
                                                                                }
                                                                                
                                                                                JsonNode changeValueRelativeValue2 = reportedImpactValue.get("changeValueRelative");
                                                                                if (changeValueRelativeValue2 != null && changeValueRelativeValue2 instanceof NullNode == false) {
                                                                                    double changeValueRelativeInstance2;
                                                                                    changeValueRelativeInstance2 = changeValueRelativeValue2.getDoubleValue();
                                                                                    operationImpactInstance2.setChangeValueRelative(changeValueRelativeInstance2);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode idValue5 = recommendedIndexesValue.get("id");
                                                                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                                        String idInstance5;
                                                                        idInstance5 = idValue5.getTextValue();
                                                                        recommendedIndexInstance.setId(idInstance5);
                                                                    }
                                                                    
                                                                    JsonNode nameValue7 = recommendedIndexesValue.get("name");
                                                                    if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                                                        String nameInstance7;
                                                                        nameInstance7 = nameValue7.getTextValue();
                                                                        recommendedIndexInstance.setName(nameInstance7);
                                                                    }
                                                                    
                                                                    JsonNode typeValue5 = recommendedIndexesValue.get("type");
                                                                    if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                                        String typeInstance5;
                                                                        typeInstance5 = typeValue5.getTextValue();
                                                                        recommendedIndexInstance.setType(typeInstance5);
                                                                    }
                                                                    
                                                                    JsonNode locationValue5 = recommendedIndexesValue.get("location");
                                                                    if (locationValue5 != null && locationValue5 instanceof NullNode == false) {
                                                                        String locationInstance5;
                                                                        locationInstance5 = locationValue5.getTextValue();
                                                                        recommendedIndexInstance.setLocation(locationInstance5);
                                                                    }
                                                                    
                                                                    JsonNode tagsSequenceElement5 = ((JsonNode) recommendedIndexesValue.get("tags"));
                                                                    if (tagsSequenceElement5 != null && tagsSequenceElement5 instanceof NullNode == false) {
                                                                        Iterator<Map.Entry<String, JsonNode>> itr5 = tagsSequenceElement5.getFields();
                                                                        while (itr5.hasNext()) {
                                                                            Map.Entry<String, JsonNode> property5 = itr5.next();
                                                                            String tagsKey5 = property5.getKey();
                                                                            String tagsValue5 = property5.getValue().getTextValue();
                                                                            recommendedIndexInstance.getTags().put(tagsKey5, tagsValue5);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        JsonNode idValue6 = tablesValue.get("id");
                                                        if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                            String idInstance6;
                                                            idInstance6 = idValue6.getTextValue();
                                                            tableInstance.setId(idInstance6);
                                                        }
                                                        
                                                        JsonNode nameValue8 = tablesValue.get("name");
                                                        if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                                            String nameInstance8;
                                                            nameInstance8 = nameValue8.getTextValue();
                                                            tableInstance.setName(nameInstance8);
                                                        }
                                                        
                                                        JsonNode typeValue6 = tablesValue.get("type");
                                                        if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                            String typeInstance6;
                                                            typeInstance6 = typeValue6.getTextValue();
                                                            tableInstance.setType(typeInstance6);
                                                        }
                                                        
                                                        JsonNode locationValue6 = tablesValue.get("location");
                                                        if (locationValue6 != null && locationValue6 instanceof NullNode == false) {
                                                            String locationInstance6;
                                                            locationInstance6 = locationValue6.getTextValue();
                                                            tableInstance.setLocation(locationInstance6);
                                                        }
                                                        
                                                        JsonNode tagsSequenceElement6 = ((JsonNode) tablesValue.get("tags"));
                                                        if (tagsSequenceElement6 != null && tagsSequenceElement6 instanceof NullNode == false) {
                                                            Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement6.getFields();
                                                            while (itr6.hasNext()) {
                                                                Map.Entry<String, JsonNode> property6 = itr6.next();
                                                                String tagsKey6 = property6.getKey();
                                                                String tagsValue6 = property6.getValue().getTextValue();
                                                                tableInstance.getTags().put(tagsKey6, tagsValue6);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode idValue7 = schemasValue.get("id");
                                            if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                String idInstance7;
                                                idInstance7 = idValue7.getTextValue();
                                                schemaInstance.setId(idInstance7);
                                            }
                                            
                                            JsonNode nameValue9 = schemasValue.get("name");
                                            if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                                String nameInstance9;
                                                nameInstance9 = nameValue9.getTextValue();
                                                schemaInstance.setName(nameInstance9);
                                            }
                                            
                                            JsonNode typeValue7 = schemasValue.get("type");
                                            if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                String typeInstance7;
                                                typeInstance7 = typeValue7.getTextValue();
                                                schemaInstance.setType(typeInstance7);
                                            }
                                            
                                            JsonNode locationValue7 = schemasValue.get("location");
                                            if (locationValue7 != null && locationValue7 instanceof NullNode == false) {
                                                String locationInstance7;
                                                locationInstance7 = locationValue7.getTextValue();
                                                schemaInstance.setLocation(locationInstance7);
                                            }
                                            
                                            JsonNode tagsSequenceElement7 = ((JsonNode) schemasValue.get("tags"));
                                            if (tagsSequenceElement7 != null && tagsSequenceElement7 instanceof NullNode == false) {
                                                Iterator<Map.Entry<String, JsonNode>> itr7 = tagsSequenceElement7.getFields();
                                                while (itr7.hasNext()) {
                                                    Map.Entry<String, JsonNode> property7 = itr7.next();
                                                    String tagsKey7 = property7.getKey();
                                                    String tagsValue7 = property7.getValue().getTextValue();
                                                    schemaInstance.getTags().put(tagsKey7, tagsValue7);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode defaultSecondaryLocationValue = propertiesValue2.get("defaultSecondaryLocation");
                                    if (defaultSecondaryLocationValue != null && defaultSecondaryLocationValue instanceof NullNode == false) {
                                        String defaultSecondaryLocationInstance;
                                        defaultSecondaryLocationInstance = defaultSecondaryLocationValue.getTextValue();
                                        propertiesInstance2.setDefaultSecondaryLocation(defaultSecondaryLocationInstance);
                                    }
                                }
                                
                                JsonNode idValue8 = databasesValue.get("id");
                                if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                    String idInstance8;
                                    idInstance8 = idValue8.getTextValue();
                                    databaseInstance.setId(idInstance8);
                                }
                                
                                JsonNode nameValue10 = databasesValue.get("name");
                                if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                    String nameInstance10;
                                    nameInstance10 = nameValue10.getTextValue();
                                    databaseInstance.setName(nameInstance10);
                                }
                                
                                JsonNode typeValue8 = databasesValue.get("type");
                                if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                    String typeInstance8;
                                    typeInstance8 = typeValue8.getTextValue();
                                    databaseInstance.setType(typeInstance8);
                                }
                                
                                JsonNode locationValue8 = databasesValue.get("location");
                                if (locationValue8 != null && locationValue8 instanceof NullNode == false) {
                                    String locationInstance8;
                                    locationInstance8 = locationValue8.getTextValue();
                                    databaseInstance.setLocation(locationInstance8);
                                }
                                
                                JsonNode tagsSequenceElement8 = ((JsonNode) databasesValue.get("tags"));
                                if (tagsSequenceElement8 != null && tagsSequenceElement8 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr8 = tagsSequenceElement8.getFields();
                                    while (itr8.hasNext()) {
                                        Map.Entry<String, JsonNode> property8 = itr8.next();
                                        String tagsKey8 = property8.getKey();
                                        String tagsValue8 = property8.getValue().getTextValue();
                                        databaseInstance.getTags().put(tagsKey8, tagsValue8);
                                    }
                                }
                            }
                        }
                        
                        JsonNode metricsArray = propertiesValue.get("metrics");
                        if (metricsArray != null && metricsArray instanceof NullNode == false) {
                            for (JsonNode metricsValue : ((ArrayNode) metricsArray)) {
                                RecommendedElasticPoolMetric recommendedElasticPoolMetricInstance = new RecommendedElasticPoolMetric();
                                propertiesInstance.getMetrics().add(recommendedElasticPoolMetricInstance);
                                
                                JsonNode dateTimeValue = metricsValue.get("dateTime");
                                if (dateTimeValue != null && dateTimeValue instanceof NullNode == false) {
                                    Calendar dateTimeInstance;
                                    dateTimeInstance = DatatypeConverter.parseDateTime(dateTimeValue.getTextValue());
                                    recommendedElasticPoolMetricInstance.setDateTime(dateTimeInstance);
                                }
                                
                                JsonNode dtuValue2 = metricsValue.get("dtu");
                                if (dtuValue2 != null && dtuValue2 instanceof NullNode == false) {
                                    double dtuInstance2;
                                    dtuInstance2 = dtuValue2.getDoubleValue();
                                    recommendedElasticPoolMetricInstance.setDtu(dtuInstance2);
                                }
                                
                                JsonNode sizeGBValue = metricsValue.get("sizeGB");
                                if (sizeGBValue != null && sizeGBValue instanceof NullNode == false) {
                                    double sizeGBInstance;
                                    sizeGBInstance = sizeGBValue.getDoubleValue();
                                    recommendedElasticPoolMetricInstance.setSizeGB(sizeGBInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue9 = responseDoc.get("id");
                    if (idValue9 != null && idValue9 instanceof NullNode == false) {
                        String idInstance9;
                        idInstance9 = idValue9.getTextValue();
                        recommendedElasticPoolInstance.setId(idInstance9);
                    }
                    
                    JsonNode nameValue11 = responseDoc.get("name");
                    if (nameValue11 != null && nameValue11 instanceof NullNode == false) {
                        String nameInstance11;
                        nameInstance11 = nameValue11.getTextValue();
                        recommendedElasticPoolInstance.setName(nameInstance11);
                    }
                    
                    JsonNode typeValue9 = responseDoc.get("type");
                    if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                        String typeInstance9;
                        typeInstance9 = typeValue9.getTextValue();
                        recommendedElasticPoolInstance.setType(typeInstance9);
                    }
                    
                    JsonNode locationValue9 = responseDoc.get("location");
                    if (locationValue9 != null && locationValue9 instanceof NullNode == false) {
                        String locationInstance9;
                        locationInstance9 = locationValue9.getTextValue();
                        recommendedElasticPoolInstance.setLocation(locationInstance9);
                    }
                    
                    JsonNode tagsSequenceElement9 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement9 != null && tagsSequenceElement9 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr9 = tagsSequenceElement9.getFields();
                        while (itr9.hasNext()) {
                            Map.Entry<String, JsonNode> property9 = itr9.next();
                            String tagsKey9 = property9.getKey();
                            String tagsValue9 = property9.getValue().getTextValue();
                            recommendedElasticPoolInstance.getTags().put(tagsKey9, tagsValue9);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Database Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    @Override
    public Future<DatabaseGetResponse> getDatabasesAsync(final String resourceGroupName, final String serverName, final String recommendedElasticPoolName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseGetResponse>() { 
            @Override
            public DatabaseGetResponse call() throws Exception {
                return getDatabases(resourceGroupName, serverName, recommendedElasticPoolName, databaseName);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Database Elastic Pool to be retrieved.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database request.
    */
    @Override
    public DatabaseGetResponse getDatabases(String resourceGroupName, String serverName, String recommendedElasticPoolName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (recommendedElasticPoolName == null) {
            throw new NullPointerException("recommendedElasticPoolName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("recommendedElasticPoolName", recommendedElasticPoolName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "getDatabasesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools/";
        url = url + URLEncoder.encode(recommendedElasticPoolName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Database databaseInstance = new Database();
                    result.setDatabase(databaseInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DatabaseProperties propertiesInstance = new DatabaseProperties();
                        databaseInstance.setProperties(propertiesInstance);
                        
                        JsonNode collationValue = propertiesValue.get("collation");
                        if (collationValue != null && collationValue instanceof NullNode == false) {
                            String collationInstance;
                            collationInstance = collationValue.getTextValue();
                            propertiesInstance.setCollation(collationInstance);
                        }
                        
                        JsonNode creationDateValue = propertiesValue.get("creationDate");
                        if (creationDateValue != null && creationDateValue instanceof NullNode == false) {
                            Calendar creationDateInstance;
                            creationDateInstance = DatatypeConverter.parseDateTime(creationDateValue.getTextValue());
                            propertiesInstance.setCreationDate(creationDateInstance);
                        }
                        
                        JsonNode currentServiceObjectiveIdValue = propertiesValue.get("currentServiceObjectiveId");
                        if (currentServiceObjectiveIdValue != null && currentServiceObjectiveIdValue instanceof NullNode == false) {
                            String currentServiceObjectiveIdInstance;
                            currentServiceObjectiveIdInstance = currentServiceObjectiveIdValue.getTextValue();
                            propertiesInstance.setCurrentServiceObjectiveId(currentServiceObjectiveIdInstance);
                        }
                        
                        JsonNode databaseIdValue = propertiesValue.get("databaseId");
                        if (databaseIdValue != null && databaseIdValue instanceof NullNode == false) {
                            String databaseIdInstance;
                            databaseIdInstance = databaseIdValue.getTextValue();
                            propertiesInstance.setDatabaseId(databaseIdInstance);
                        }
                        
                        JsonNode earliestRestoreDateValue = propertiesValue.get("earliestRestoreDate");
                        if (earliestRestoreDateValue != null && earliestRestoreDateValue instanceof NullNode == false) {
                            Calendar earliestRestoreDateInstance;
                            earliestRestoreDateInstance = DatatypeConverter.parseDateTime(earliestRestoreDateValue.getTextValue());
                            propertiesInstance.setEarliestRestoreDate(earliestRestoreDateInstance);
                        }
                        
                        JsonNode editionValue = propertiesValue.get("edition");
                        if (editionValue != null && editionValue instanceof NullNode == false) {
                            String editionInstance;
                            editionInstance = editionValue.getTextValue();
                            propertiesInstance.setEdition(editionInstance);
                        }
                        
                        JsonNode maxSizeBytesValue = propertiesValue.get("maxSizeBytes");
                        if (maxSizeBytesValue != null && maxSizeBytesValue instanceof NullNode == false) {
                            long maxSizeBytesInstance;
                            maxSizeBytesInstance = maxSizeBytesValue.getLongValue();
                            propertiesInstance.setMaxSizeBytes(maxSizeBytesInstance);
                        }
                        
                        JsonNode requestedServiceObjectiveIdValue = propertiesValue.get("requestedServiceObjectiveId");
                        if (requestedServiceObjectiveIdValue != null && requestedServiceObjectiveIdValue instanceof NullNode == false) {
                            String requestedServiceObjectiveIdInstance;
                            requestedServiceObjectiveIdInstance = requestedServiceObjectiveIdValue.getTextValue();
                            propertiesInstance.setRequestedServiceObjectiveId(requestedServiceObjectiveIdInstance);
                        }
                        
                        JsonNode requestedServiceObjectiveNameValue = propertiesValue.get("requestedServiceObjectiveName");
                        if (requestedServiceObjectiveNameValue != null && requestedServiceObjectiveNameValue instanceof NullNode == false) {
                            String requestedServiceObjectiveNameInstance;
                            requestedServiceObjectiveNameInstance = requestedServiceObjectiveNameValue.getTextValue();
                            propertiesInstance.setRequestedServiceObjectiveName(requestedServiceObjectiveNameInstance);
                        }
                        
                        JsonNode serviceLevelObjectiveValue = propertiesValue.get("serviceLevelObjective");
                        if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                            String serviceLevelObjectiveInstance;
                            serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setServiceObjective(serviceLevelObjectiveInstance);
                        }
                        
                        JsonNode statusValue = propertiesValue.get("status");
                        if (statusValue != null && statusValue instanceof NullNode == false) {
                            String statusInstance;
                            statusInstance = statusValue.getTextValue();
                            propertiesInstance.setStatus(statusInstance);
                        }
                        
                        JsonNode elasticPoolNameValue = propertiesValue.get("elasticPoolName");
                        if (elasticPoolNameValue != null && elasticPoolNameValue instanceof NullNode == false) {
                            String elasticPoolNameInstance;
                            elasticPoolNameInstance = elasticPoolNameValue.getTextValue();
                            propertiesInstance.setElasticPoolName(elasticPoolNameInstance);
                        }
                        
                        JsonNode serviceTierAdvisorsArray = propertiesValue.get("serviceTierAdvisors");
                        if (serviceTierAdvisorsArray != null && serviceTierAdvisorsArray instanceof NullNode == false) {
                            for (JsonNode serviceTierAdvisorsValue : ((ArrayNode) serviceTierAdvisorsArray)) {
                                ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                                propertiesInstance.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                                
                                JsonNode propertiesValue2 = serviceTierAdvisorsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    ServiceTierAdvisorProperties propertiesInstance2 = new ServiceTierAdvisorProperties();
                                    serviceTierAdvisorInstance.setProperties(propertiesInstance2);
                                    
                                    JsonNode observationPeriodStartValue = propertiesValue2.get("observationPeriodStart");
                                    if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                                        Calendar observationPeriodStartInstance;
                                        observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                                        propertiesInstance2.setObservationPeriodStart(observationPeriodStartInstance);
                                    }
                                    
                                    JsonNode observationPeriodEndValue = propertiesValue2.get("observationPeriodEnd");
                                    if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                                        Calendar observationPeriodEndInstance;
                                        observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                                        propertiesInstance2.setObservationPeriodEnd(observationPeriodEndInstance);
                                    }
                                    
                                    JsonNode activeTimeRatioValue = propertiesValue2.get("activeTimeRatio");
                                    if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                        double activeTimeRatioInstance;
                                        activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                        propertiesInstance2.setActiveTimeRatio(activeTimeRatioInstance);
                                    }
                                    
                                    JsonNode minDtuValue = propertiesValue2.get("minDtu");
                                    if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                        double minDtuInstance;
                                        minDtuInstance = minDtuValue.getDoubleValue();
                                        propertiesInstance2.setMinDtu(minDtuInstance);
                                    }
                                    
                                    JsonNode avgDtuValue = propertiesValue2.get("avgDtu");
                                    if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                        double avgDtuInstance;
                                        avgDtuInstance = avgDtuValue.getDoubleValue();
                                        propertiesInstance2.setAvgDtu(avgDtuInstance);
                                    }
                                    
                                    JsonNode maxDtuValue = propertiesValue2.get("maxDtu");
                                    if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                        double maxDtuInstance;
                                        maxDtuInstance = maxDtuValue.getDoubleValue();
                                        propertiesInstance2.setMaxDtu(maxDtuInstance);
                                    }
                                    
                                    JsonNode maxSizeInGBValue = propertiesValue2.get("maxSizeInGB");
                                    if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                        double maxSizeInGBInstance;
                                        maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                        propertiesInstance2.setMaxSizeInGB(maxSizeInGBInstance);
                                    }
                                    
                                    JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue2.get("serviceLevelObjectiveUsageMetrics");
                                    if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                        for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                            SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                            propertiesInstance2.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                            
                                            JsonNode serviceLevelObjectiveValue2 = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                            if (serviceLevelObjectiveValue2 != null && serviceLevelObjectiveValue2 instanceof NullNode == false) {
                                                String serviceLevelObjectiveInstance2;
                                                serviceLevelObjectiveInstance2 = serviceLevelObjectiveValue2.getTextValue();
                                                sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance2);
                                            }
                                            
                                            JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                            if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String serviceLevelObjectiveIdInstance;
                                                serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                                sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                            if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                                double inRangeTimeRatioInstance;
                                                inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                                sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                            }
                                            
                                            JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                            if (idValue != null && idValue instanceof NullNode == false) {
                                                String idInstance;
                                                idInstance = idValue.getTextValue();
                                                sloUsageMetricInstance.setId(idInstance);
                                            }
                                            
                                            JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                                String nameInstance;
                                                nameInstance = nameValue.getTextValue();
                                                sloUsageMetricInstance.setName(nameInstance);
                                            }
                                            
                                            JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                                String typeInstance;
                                                typeInstance = typeValue.getTextValue();
                                                sloUsageMetricInstance.setType(typeInstance);
                                            }
                                            
                                            JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                                String locationInstance;
                                                locationInstance = locationValue.getTextValue();
                                                sloUsageMetricInstance.setLocation(locationInstance);
                                            }
                                            
                                            JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                                while (itr.hasNext()) {
                                                    Map.Entry<String, JsonNode> property = itr.next();
                                                    String tagsKey = property.getKey();
                                                    String tagsValue = property.getValue().getTextValue();
                                                    sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode currentServiceLevelObjectiveValue = propertiesValue2.get("currentServiceLevelObjective");
                                    if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String currentServiceLevelObjectiveInstance;
                                        currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode currentServiceLevelObjectiveIdValue = propertiesValue2.get("currentServiceLevelObjectiveId");
                                    if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String currentServiceLevelObjectiveIdInstance;
                                        currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("usageBasedRecommendationServiceLevelObjective");
                                    if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String usageBasedRecommendationServiceLevelObjectiveInstance;
                                        usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("usageBasedRecommendationServiceLevelObjectiveId");
                                    if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                        usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                    if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                        databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                    if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                        databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                    if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                        disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                    if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                        disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue2.get("overallRecommendationServiceLevelObjective");
                                    if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String overallRecommendationServiceLevelObjectiveInstance;
                                        overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                        propertiesInstance2.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("overallRecommendationServiceLevelObjectiveId");
                                    if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String overallRecommendationServiceLevelObjectiveIdInstance;
                                        overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                        propertiesInstance2.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode confidenceValue = propertiesValue2.get("confidence");
                                    if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                        double confidenceInstance;
                                        confidenceInstance = confidenceValue.getDoubleValue();
                                        propertiesInstance2.setConfidence(confidenceInstance);
                                    }
                                }
                                
                                JsonNode idValue2 = serviceTierAdvisorsValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    serviceTierAdvisorInstance.setId(idInstance2);
                                }
                                
                                JsonNode nameValue2 = serviceTierAdvisorsValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    serviceTierAdvisorInstance.setName(nameInstance2);
                                }
                                
                                JsonNode typeValue2 = serviceTierAdvisorsValue.get("type");
                                if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                    String typeInstance2;
                                    typeInstance2 = typeValue2.getTextValue();
                                    serviceTierAdvisorInstance.setType(typeInstance2);
                                }
                                
                                JsonNode locationValue2 = serviceTierAdvisorsValue.get("location");
                                if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                    String locationInstance2;
                                    locationInstance2 = locationValue2.getTextValue();
                                    serviceTierAdvisorInstance.setLocation(locationInstance2);
                                }
                                
                                JsonNode tagsSequenceElement2 = ((JsonNode) serviceTierAdvisorsValue.get("tags"));
                                if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                    while (itr2.hasNext()) {
                                        Map.Entry<String, JsonNode> property2 = itr2.next();
                                        String tagsKey2 = property2.getKey();
                                        String tagsValue2 = property2.getValue().getTextValue();
                                        serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode upgradeHintValue = propertiesValue.get("upgradeHint");
                        if (upgradeHintValue != null && upgradeHintValue instanceof NullNode == false) {
                            UpgradeHint upgradeHintInstance = new UpgradeHint();
                            propertiesInstance.setUpgradeHint(upgradeHintInstance);
                            
                            JsonNode targetServiceLevelObjectiveValue = upgradeHintValue.get("targetServiceLevelObjective");
                            if (targetServiceLevelObjectiveValue != null && targetServiceLevelObjectiveValue instanceof NullNode == false) {
                                String targetServiceLevelObjectiveInstance;
                                targetServiceLevelObjectiveInstance = targetServiceLevelObjectiveValue.getTextValue();
                                upgradeHintInstance.setTargetServiceLevelObjective(targetServiceLevelObjectiveInstance);
                            }
                            
                            JsonNode targetServiceLevelObjectiveIdValue = upgradeHintValue.get("targetServiceLevelObjectiveId");
                            if (targetServiceLevelObjectiveIdValue != null && targetServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                String targetServiceLevelObjectiveIdInstance;
                                targetServiceLevelObjectiveIdInstance = targetServiceLevelObjectiveIdValue.getTextValue();
                                upgradeHintInstance.setTargetServiceLevelObjectiveId(targetServiceLevelObjectiveIdInstance);
                            }
                            
                            JsonNode idValue3 = upgradeHintValue.get("id");
                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                String idInstance3;
                                idInstance3 = idValue3.getTextValue();
                                upgradeHintInstance.setId(idInstance3);
                            }
                            
                            JsonNode nameValue3 = upgradeHintValue.get("name");
                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                String nameInstance3;
                                nameInstance3 = nameValue3.getTextValue();
                                upgradeHintInstance.setName(nameInstance3);
                            }
                            
                            JsonNode typeValue3 = upgradeHintValue.get("type");
                            if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                String typeInstance3;
                                typeInstance3 = typeValue3.getTextValue();
                                upgradeHintInstance.setType(typeInstance3);
                            }
                            
                            JsonNode locationValue3 = upgradeHintValue.get("location");
                            if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                String locationInstance3;
                                locationInstance3 = locationValue3.getTextValue();
                                upgradeHintInstance.setLocation(locationInstance3);
                            }
                            
                            JsonNode tagsSequenceElement3 = ((JsonNode) upgradeHintValue.get("tags"));
                            if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry<String, JsonNode> property3 = itr3.next();
                                    String tagsKey3 = property3.getKey();
                                    String tagsValue3 = property3.getValue().getTextValue();
                                    upgradeHintInstance.getTags().put(tagsKey3, tagsValue3);
                                }
                            }
                        }
                        
                        JsonNode schemasArray = propertiesValue.get("schemas");
                        if (schemasArray != null && schemasArray instanceof NullNode == false) {
                            for (JsonNode schemasValue : ((ArrayNode) schemasArray)) {
                                Schema schemaInstance = new Schema();
                                propertiesInstance.getSchemas().add(schemaInstance);
                                
                                JsonNode propertiesValue3 = schemasValue.get("properties");
                                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                    SchemaProperties propertiesInstance3 = new SchemaProperties();
                                    schemaInstance.setProperties(propertiesInstance3);
                                    
                                    JsonNode tablesArray = propertiesValue3.get("tables");
                                    if (tablesArray != null && tablesArray instanceof NullNode == false) {
                                        for (JsonNode tablesValue : ((ArrayNode) tablesArray)) {
                                            Table tableInstance = new Table();
                                            propertiesInstance3.getTables().add(tableInstance);
                                            
                                            JsonNode propertiesValue4 = tablesValue.get("properties");
                                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                                TableProperties propertiesInstance4 = new TableProperties();
                                                tableInstance.setProperties(propertiesInstance4);
                                                
                                                JsonNode tableTypeValue = propertiesValue4.get("tableType");
                                                if (tableTypeValue != null && tableTypeValue instanceof NullNode == false) {
                                                    String tableTypeInstance;
                                                    tableTypeInstance = tableTypeValue.getTextValue();
                                                    propertiesInstance4.setTableType(tableTypeInstance);
                                                }
                                                
                                                JsonNode columnsArray = propertiesValue4.get("columns");
                                                if (columnsArray != null && columnsArray instanceof NullNode == false) {
                                                    for (JsonNode columnsValue : ((ArrayNode) columnsArray)) {
                                                        Column columnInstance = new Column();
                                                        propertiesInstance4.getColumns().add(columnInstance);
                                                        
                                                        JsonNode propertiesValue5 = columnsValue.get("properties");
                                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                                            ColumnProperties propertiesInstance5 = new ColumnProperties();
                                                            columnInstance.setProperties(propertiesInstance5);
                                                            
                                                            JsonNode columnTypeValue = propertiesValue5.get("columnType");
                                                            if (columnTypeValue != null && columnTypeValue instanceof NullNode == false) {
                                                                String columnTypeInstance;
                                                                columnTypeInstance = columnTypeValue.getTextValue();
                                                                propertiesInstance5.setColumnType(columnTypeInstance);
                                                            }
                                                        }
                                                        
                                                        JsonNode idValue4 = columnsValue.get("id");
                                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                            String idInstance4;
                                                            idInstance4 = idValue4.getTextValue();
                                                            columnInstance.setId(idInstance4);
                                                        }
                                                        
                                                        JsonNode nameValue4 = columnsValue.get("name");
                                                        if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                            String nameInstance4;
                                                            nameInstance4 = nameValue4.getTextValue();
                                                            columnInstance.setName(nameInstance4);
                                                        }
                                                        
                                                        JsonNode typeValue4 = columnsValue.get("type");
                                                        if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                            String typeInstance4;
                                                            typeInstance4 = typeValue4.getTextValue();
                                                            columnInstance.setType(typeInstance4);
                                                        }
                                                        
                                                        JsonNode locationValue4 = columnsValue.get("location");
                                                        if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                                            String locationInstance4;
                                                            locationInstance4 = locationValue4.getTextValue();
                                                            columnInstance.setLocation(locationInstance4);
                                                        }
                                                        
                                                        JsonNode tagsSequenceElement4 = ((JsonNode) columnsValue.get("tags"));
                                                        if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                                            Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                                            while (itr4.hasNext()) {
                                                                Map.Entry<String, JsonNode> property4 = itr4.next();
                                                                String tagsKey4 = property4.getKey();
                                                                String tagsValue4 = property4.getValue().getTextValue();
                                                                columnInstance.getTags().put(tagsKey4, tagsValue4);
                                                            }
                                                        }
                                                    }
                                                }
                                                
                                                JsonNode recommendedIndexesArray = propertiesValue4.get("recommendedIndexes");
                                                if (recommendedIndexesArray != null && recommendedIndexesArray instanceof NullNode == false) {
                                                    for (JsonNode recommendedIndexesValue : ((ArrayNode) recommendedIndexesArray)) {
                                                        RecommendedIndex recommendedIndexInstance = new RecommendedIndex();
                                                        propertiesInstance4.getRecommendedIndexes().add(recommendedIndexInstance);
                                                        
                                                        JsonNode propertiesValue6 = recommendedIndexesValue.get("properties");
                                                        if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                                            RecommendedIndexProperties propertiesInstance6 = new RecommendedIndexProperties();
                                                            recommendedIndexInstance.setProperties(propertiesInstance6);
                                                            
                                                            JsonNode actionValue = propertiesValue6.get("action");
                                                            if (actionValue != null && actionValue instanceof NullNode == false) {
                                                                String actionInstance;
                                                                actionInstance = actionValue.getTextValue();
                                                                propertiesInstance6.setAction(actionInstance);
                                                            }
                                                            
                                                            JsonNode stateValue = propertiesValue6.get("state");
                                                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                                                String stateInstance;
                                                                stateInstance = stateValue.getTextValue();
                                                                propertiesInstance6.setState(stateInstance);
                                                            }
                                                            
                                                            JsonNode createdValue = propertiesValue6.get("created");
                                                            if (createdValue != null && createdValue instanceof NullNode == false) {
                                                                Calendar createdInstance;
                                                                createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                                                propertiesInstance6.setCreated(createdInstance);
                                                            }
                                                            
                                                            JsonNode lastModifiedValue = propertiesValue6.get("lastModified");
                                                            if (lastModifiedValue != null && lastModifiedValue instanceof NullNode == false) {
                                                                Calendar lastModifiedInstance;
                                                                lastModifiedInstance = DatatypeConverter.parseDateTime(lastModifiedValue.getTextValue());
                                                                propertiesInstance6.setLastModified(lastModifiedInstance);
                                                            }
                                                            
                                                            JsonNode indexTypeValue = propertiesValue6.get("indexType");
                                                            if (indexTypeValue != null && indexTypeValue instanceof NullNode == false) {
                                                                String indexTypeInstance;
                                                                indexTypeInstance = indexTypeValue.getTextValue();
                                                                propertiesInstance6.setIndexType(indexTypeInstance);
                                                            }
                                                            
                                                            JsonNode schemaValue = propertiesValue6.get("schema");
                                                            if (schemaValue != null && schemaValue instanceof NullNode == false) {
                                                                String schemaInstance2;
                                                                schemaInstance2 = schemaValue.getTextValue();
                                                                propertiesInstance6.setSchema(schemaInstance2);
                                                            }
                                                            
                                                            JsonNode tableValue = propertiesValue6.get("table");
                                                            if (tableValue != null && tableValue instanceof NullNode == false) {
                                                                String tableInstance2;
                                                                tableInstance2 = tableValue.getTextValue();
                                                                propertiesInstance6.setTable(tableInstance2);
                                                            }
                                                            
                                                            JsonNode columnsArray2 = propertiesValue6.get("columns");
                                                            if (columnsArray2 != null && columnsArray2 instanceof NullNode == false) {
                                                                for (JsonNode columnsValue2 : ((ArrayNode) columnsArray2)) {
                                                                    propertiesInstance6.getColumns().add(columnsValue2.getTextValue());
                                                                }
                                                            }
                                                            
                                                            JsonNode includedColumnsArray = propertiesValue6.get("includedColumns");
                                                            if (includedColumnsArray != null && includedColumnsArray instanceof NullNode == false) {
                                                                for (JsonNode includedColumnsValue : ((ArrayNode) includedColumnsArray)) {
                                                                    propertiesInstance6.getIncludedColumns().add(includedColumnsValue.getTextValue());
                                                                }
                                                            }
                                                            
                                                            JsonNode indexScriptValue = propertiesValue6.get("indexScript");
                                                            if (indexScriptValue != null && indexScriptValue instanceof NullNode == false) {
                                                                String indexScriptInstance;
                                                                indexScriptInstance = indexScriptValue.getTextValue();
                                                                propertiesInstance6.setIndexScript(indexScriptInstance);
                                                            }
                                                            
                                                            JsonNode estimatedImpactArray = propertiesValue6.get("estimatedImpact");
                                                            if (estimatedImpactArray != null && estimatedImpactArray instanceof NullNode == false) {
                                                                for (JsonNode estimatedImpactValue : ((ArrayNode) estimatedImpactArray)) {
                                                                    OperationImpact operationImpactInstance = new OperationImpact();
                                                                    propertiesInstance6.getEstimatedImpact().add(operationImpactInstance);
                                                                    
                                                                    JsonNode nameValue5 = estimatedImpactValue.get("name");
                                                                    if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                                        String nameInstance5;
                                                                        nameInstance5 = nameValue5.getTextValue();
                                                                        operationImpactInstance.setName(nameInstance5);
                                                                    }
                                                                    
                                                                    JsonNode unitValue = estimatedImpactValue.get("unit");
                                                                    if (unitValue != null && unitValue instanceof NullNode == false) {
                                                                        String unitInstance;
                                                                        unitInstance = unitValue.getTextValue();
                                                                        operationImpactInstance.setUnit(unitInstance);
                                                                    }
                                                                    
                                                                    JsonNode changeValueAbsoluteValue = estimatedImpactValue.get("changeValueAbsolute");
                                                                    if (changeValueAbsoluteValue != null && changeValueAbsoluteValue instanceof NullNode == false) {
                                                                        double changeValueAbsoluteInstance;
                                                                        changeValueAbsoluteInstance = changeValueAbsoluteValue.getDoubleValue();
                                                                        operationImpactInstance.setChangeValueAbsolute(changeValueAbsoluteInstance);
                                                                    }
                                                                    
                                                                    JsonNode changeValueRelativeValue = estimatedImpactValue.get("changeValueRelative");
                                                                    if (changeValueRelativeValue != null && changeValueRelativeValue instanceof NullNode == false) {
                                                                        double changeValueRelativeInstance;
                                                                        changeValueRelativeInstance = changeValueRelativeValue.getDoubleValue();
                                                                        operationImpactInstance.setChangeValueRelative(changeValueRelativeInstance);
                                                                    }
                                                                }
                                                            }
                                                            
                                                            JsonNode reportedImpactArray = propertiesValue6.get("reportedImpact");
                                                            if (reportedImpactArray != null && reportedImpactArray instanceof NullNode == false) {
                                                                for (JsonNode reportedImpactValue : ((ArrayNode) reportedImpactArray)) {
                                                                    OperationImpact operationImpactInstance2 = new OperationImpact();
                                                                    propertiesInstance6.getReportedImpact().add(operationImpactInstance2);
                                                                    
                                                                    JsonNode nameValue6 = reportedImpactValue.get("name");
                                                                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                                        String nameInstance6;
                                                                        nameInstance6 = nameValue6.getTextValue();
                                                                        operationImpactInstance2.setName(nameInstance6);
                                                                    }
                                                                    
                                                                    JsonNode unitValue2 = reportedImpactValue.get("unit");
                                                                    if (unitValue2 != null && unitValue2 instanceof NullNode == false) {
                                                                        String unitInstance2;
                                                                        unitInstance2 = unitValue2.getTextValue();
                                                                        operationImpactInstance2.setUnit(unitInstance2);
                                                                    }
                                                                    
                                                                    JsonNode changeValueAbsoluteValue2 = reportedImpactValue.get("changeValueAbsolute");
                                                                    if (changeValueAbsoluteValue2 != null && changeValueAbsoluteValue2 instanceof NullNode == false) {
                                                                        double changeValueAbsoluteInstance2;
                                                                        changeValueAbsoluteInstance2 = changeValueAbsoluteValue2.getDoubleValue();
                                                                        operationImpactInstance2.setChangeValueAbsolute(changeValueAbsoluteInstance2);
                                                                    }
                                                                    
                                                                    JsonNode changeValueRelativeValue2 = reportedImpactValue.get("changeValueRelative");
                                                                    if (changeValueRelativeValue2 != null && changeValueRelativeValue2 instanceof NullNode == false) {
                                                                        double changeValueRelativeInstance2;
                                                                        changeValueRelativeInstance2 = changeValueRelativeValue2.getDoubleValue();
                                                                        operationImpactInstance2.setChangeValueRelative(changeValueRelativeInstance2);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        JsonNode idValue5 = recommendedIndexesValue.get("id");
                                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                            String idInstance5;
                                                            idInstance5 = idValue5.getTextValue();
                                                            recommendedIndexInstance.setId(idInstance5);
                                                        }
                                                        
                                                        JsonNode nameValue7 = recommendedIndexesValue.get("name");
                                                        if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                                            String nameInstance7;
                                                            nameInstance7 = nameValue7.getTextValue();
                                                            recommendedIndexInstance.setName(nameInstance7);
                                                        }
                                                        
                                                        JsonNode typeValue5 = recommendedIndexesValue.get("type");
                                                        if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                            String typeInstance5;
                                                            typeInstance5 = typeValue5.getTextValue();
                                                            recommendedIndexInstance.setType(typeInstance5);
                                                        }
                                                        
                                                        JsonNode locationValue5 = recommendedIndexesValue.get("location");
                                                        if (locationValue5 != null && locationValue5 instanceof NullNode == false) {
                                                            String locationInstance5;
                                                            locationInstance5 = locationValue5.getTextValue();
                                                            recommendedIndexInstance.setLocation(locationInstance5);
                                                        }
                                                        
                                                        JsonNode tagsSequenceElement5 = ((JsonNode) recommendedIndexesValue.get("tags"));
                                                        if (tagsSequenceElement5 != null && tagsSequenceElement5 instanceof NullNode == false) {
                                                            Iterator<Map.Entry<String, JsonNode>> itr5 = tagsSequenceElement5.getFields();
                                                            while (itr5.hasNext()) {
                                                                Map.Entry<String, JsonNode> property5 = itr5.next();
                                                                String tagsKey5 = property5.getKey();
                                                                String tagsValue5 = property5.getValue().getTextValue();
                                                                recommendedIndexInstance.getTags().put(tagsKey5, tagsValue5);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode idValue6 = tablesValue.get("id");
                                            if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                String idInstance6;
                                                idInstance6 = idValue6.getTextValue();
                                                tableInstance.setId(idInstance6);
                                            }
                                            
                                            JsonNode nameValue8 = tablesValue.get("name");
                                            if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                                String nameInstance8;
                                                nameInstance8 = nameValue8.getTextValue();
                                                tableInstance.setName(nameInstance8);
                                            }
                                            
                                            JsonNode typeValue6 = tablesValue.get("type");
                                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                String typeInstance6;
                                                typeInstance6 = typeValue6.getTextValue();
                                                tableInstance.setType(typeInstance6);
                                            }
                                            
                                            JsonNode locationValue6 = tablesValue.get("location");
                                            if (locationValue6 != null && locationValue6 instanceof NullNode == false) {
                                                String locationInstance6;
                                                locationInstance6 = locationValue6.getTextValue();
                                                tableInstance.setLocation(locationInstance6);
                                            }
                                            
                                            JsonNode tagsSequenceElement6 = ((JsonNode) tablesValue.get("tags"));
                                            if (tagsSequenceElement6 != null && tagsSequenceElement6 instanceof NullNode == false) {
                                                Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement6.getFields();
                                                while (itr6.hasNext()) {
                                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                                    String tagsKey6 = property6.getKey();
                                                    String tagsValue6 = property6.getValue().getTextValue();
                                                    tableInstance.getTags().put(tagsKey6, tagsValue6);
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode idValue7 = schemasValue.get("id");
                                if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                    String idInstance7;
                                    idInstance7 = idValue7.getTextValue();
                                    schemaInstance.setId(idInstance7);
                                }
                                
                                JsonNode nameValue9 = schemasValue.get("name");
                                if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                    String nameInstance9;
                                    nameInstance9 = nameValue9.getTextValue();
                                    schemaInstance.setName(nameInstance9);
                                }
                                
                                JsonNode typeValue7 = schemasValue.get("type");
                                if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                    String typeInstance7;
                                    typeInstance7 = typeValue7.getTextValue();
                                    schemaInstance.setType(typeInstance7);
                                }
                                
                                JsonNode locationValue7 = schemasValue.get("location");
                                if (locationValue7 != null && locationValue7 instanceof NullNode == false) {
                                    String locationInstance7;
                                    locationInstance7 = locationValue7.getTextValue();
                                    schemaInstance.setLocation(locationInstance7);
                                }
                                
                                JsonNode tagsSequenceElement7 = ((JsonNode) schemasValue.get("tags"));
                                if (tagsSequenceElement7 != null && tagsSequenceElement7 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr7 = tagsSequenceElement7.getFields();
                                    while (itr7.hasNext()) {
                                        Map.Entry<String, JsonNode> property7 = itr7.next();
                                        String tagsKey7 = property7.getKey();
                                        String tagsValue7 = property7.getValue().getTextValue();
                                        schemaInstance.getTags().put(tagsKey7, tagsValue7);
                                    }
                                }
                            }
                        }
                        
                        JsonNode defaultSecondaryLocationValue = propertiesValue.get("defaultSecondaryLocation");
                        if (defaultSecondaryLocationValue != null && defaultSecondaryLocationValue instanceof NullNode == false) {
                            String defaultSecondaryLocationInstance;
                            defaultSecondaryLocationInstance = defaultSecondaryLocationValue.getTextValue();
                            propertiesInstance.setDefaultSecondaryLocation(defaultSecondaryLocationInstance);
                        }
                    }
                    
                    JsonNode idValue8 = responseDoc.get("id");
                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                        String idInstance8;
                        idInstance8 = idValue8.getTextValue();
                        databaseInstance.setId(idInstance8);
                    }
                    
                    JsonNode nameValue10 = responseDoc.get("name");
                    if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                        String nameInstance10;
                        nameInstance10 = nameValue10.getTextValue();
                        databaseInstance.setName(nameInstance10);
                    }
                    
                    JsonNode typeValue8 = responseDoc.get("type");
                    if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                        String typeInstance8;
                        typeInstance8 = typeValue8.getTextValue();
                        databaseInstance.setType(typeInstance8);
                    }
                    
                    JsonNode locationValue8 = responseDoc.get("location");
                    if (locationValue8 != null && locationValue8 instanceof NullNode == false) {
                        String locationInstance8;
                        locationInstance8 = locationValue8.getTextValue();
                        databaseInstance.setLocation(locationInstance8);
                    }
                    
                    JsonNode tagsSequenceElement8 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement8 != null && tagsSequenceElement8 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr8 = tagsSequenceElement8.getFields();
                        while (itr8.hasNext()) {
                            Map.Entry<String, JsonNode> property8 = itr8.next();
                            String tagsKey8 = property8.getKey();
                            String tagsValue8 = property8.getValue().getTextValue();
                            databaseInstance.getTags().put(tagsKey8, tagsValue8);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    @Override
    public Future<RecommendedElasticPoolListResponse> listAsync(final String resourceGroupName, final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<RecommendedElasticPoolListResponse>() { 
            @Override
            public RecommendedElasticPoolListResponse call() throws Exception {
                return list(resourceGroupName, serverName);
            }
         });
    }
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    @Override
    public RecommendedElasticPoolListResponse list(String resourceGroupName, String serverName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            RecommendedElasticPoolListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecommendedElasticPoolListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            RecommendedElasticPool recommendedElasticPoolInstance = new RecommendedElasticPool();
                            result.getRecommendedElasticPools().add(recommendedElasticPoolInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                RecommendedElasticPoolProperties propertiesInstance = new RecommendedElasticPoolProperties();
                                recommendedElasticPoolInstance.setProperties(propertiesInstance);
                                
                                JsonNode databaseEditionValue = propertiesValue.get("databaseEdition");
                                if (databaseEditionValue != null && databaseEditionValue instanceof NullNode == false) {
                                    String databaseEditionInstance;
                                    databaseEditionInstance = databaseEditionValue.getTextValue();
                                    propertiesInstance.setDatabaseEdition(databaseEditionInstance);
                                }
                                
                                JsonNode dtuValue = propertiesValue.get("dtu");
                                if (dtuValue != null && dtuValue instanceof NullNode == false) {
                                    double dtuInstance;
                                    dtuInstance = dtuValue.getDoubleValue();
                                    propertiesInstance.setDtu(dtuInstance);
                                }
                                
                                JsonNode databaseDtuMinValue = propertiesValue.get("databaseDtuMin");
                                if (databaseDtuMinValue != null && databaseDtuMinValue instanceof NullNode == false) {
                                    double databaseDtuMinInstance;
                                    databaseDtuMinInstance = databaseDtuMinValue.getDoubleValue();
                                    propertiesInstance.setDatabaseDtuMin(databaseDtuMinInstance);
                                }
                                
                                JsonNode databaseDtuMaxValue = propertiesValue.get("databaseDtuMax");
                                if (databaseDtuMaxValue != null && databaseDtuMaxValue instanceof NullNode == false) {
                                    double databaseDtuMaxInstance;
                                    databaseDtuMaxInstance = databaseDtuMaxValue.getDoubleValue();
                                    propertiesInstance.setDatabaseDtuMax(databaseDtuMaxInstance);
                                }
                                
                                JsonNode storageMBValue = propertiesValue.get("storageMB");
                                if (storageMBValue != null && storageMBValue instanceof NullNode == false) {
                                    double storageMBInstance;
                                    storageMBInstance = storageMBValue.getDoubleValue();
                                    propertiesInstance.setStorageMB(storageMBInstance);
                                }
                                
                                JsonNode observationPeriodStartValue = propertiesValue.get("observationPeriodStart");
                                if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                                    Calendar observationPeriodStartInstance;
                                    observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                                    propertiesInstance.setObservationPeriodStart(observationPeriodStartInstance);
                                }
                                
                                JsonNode observationPeriodEndValue = propertiesValue.get("observationPeriodEnd");
                                if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                                    Calendar observationPeriodEndInstance;
                                    observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                                    propertiesInstance.setObservationPeriodEnd(observationPeriodEndInstance);
                                }
                                
                                JsonNode maxObservedDtuValue = propertiesValue.get("maxObservedDtu");
                                if (maxObservedDtuValue != null && maxObservedDtuValue instanceof NullNode == false) {
                                    double maxObservedDtuInstance;
                                    maxObservedDtuInstance = maxObservedDtuValue.getDoubleValue();
                                    propertiesInstance.setMaxObservedDtu(maxObservedDtuInstance);
                                }
                                
                                JsonNode maxObservedStorageMBValue = propertiesValue.get("maxObservedStorageMB");
                                if (maxObservedStorageMBValue != null && maxObservedStorageMBValue instanceof NullNode == false) {
                                    double maxObservedStorageMBInstance;
                                    maxObservedStorageMBInstance = maxObservedStorageMBValue.getDoubleValue();
                                    propertiesInstance.setMaxObservedStorageMB(maxObservedStorageMBInstance);
                                }
                                
                                JsonNode databasesArray = propertiesValue.get("databases");
                                if (databasesArray != null && databasesArray instanceof NullNode == false) {
                                    for (JsonNode databasesValue : ((ArrayNode) databasesArray)) {
                                        Database databaseInstance = new Database();
                                        propertiesInstance.getDatabases().add(databaseInstance);
                                        
                                        JsonNode propertiesValue2 = databasesValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            DatabaseProperties propertiesInstance2 = new DatabaseProperties();
                                            databaseInstance.setProperties(propertiesInstance2);
                                            
                                            JsonNode collationValue = propertiesValue2.get("collation");
                                            if (collationValue != null && collationValue instanceof NullNode == false) {
                                                String collationInstance;
                                                collationInstance = collationValue.getTextValue();
                                                propertiesInstance2.setCollation(collationInstance);
                                            }
                                            
                                            JsonNode creationDateValue = propertiesValue2.get("creationDate");
                                            if (creationDateValue != null && creationDateValue instanceof NullNode == false) {
                                                Calendar creationDateInstance;
                                                creationDateInstance = DatatypeConverter.parseDateTime(creationDateValue.getTextValue());
                                                propertiesInstance2.setCreationDate(creationDateInstance);
                                            }
                                            
                                            JsonNode currentServiceObjectiveIdValue = propertiesValue2.get("currentServiceObjectiveId");
                                            if (currentServiceObjectiveIdValue != null && currentServiceObjectiveIdValue instanceof NullNode == false) {
                                                String currentServiceObjectiveIdInstance;
                                                currentServiceObjectiveIdInstance = currentServiceObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setCurrentServiceObjectiveId(currentServiceObjectiveIdInstance);
                                            }
                                            
                                            JsonNode databaseIdValue = propertiesValue2.get("databaseId");
                                            if (databaseIdValue != null && databaseIdValue instanceof NullNode == false) {
                                                String databaseIdInstance;
                                                databaseIdInstance = databaseIdValue.getTextValue();
                                                propertiesInstance2.setDatabaseId(databaseIdInstance);
                                            }
                                            
                                            JsonNode earliestRestoreDateValue = propertiesValue2.get("earliestRestoreDate");
                                            if (earliestRestoreDateValue != null && earliestRestoreDateValue instanceof NullNode == false) {
                                                Calendar earliestRestoreDateInstance;
                                                earliestRestoreDateInstance = DatatypeConverter.parseDateTime(earliestRestoreDateValue.getTextValue());
                                                propertiesInstance2.setEarliestRestoreDate(earliestRestoreDateInstance);
                                            }
                                            
                                            JsonNode editionValue = propertiesValue2.get("edition");
                                            if (editionValue != null && editionValue instanceof NullNode == false) {
                                                String editionInstance;
                                                editionInstance = editionValue.getTextValue();
                                                propertiesInstance2.setEdition(editionInstance);
                                            }
                                            
                                            JsonNode maxSizeBytesValue = propertiesValue2.get("maxSizeBytes");
                                            if (maxSizeBytesValue != null && maxSizeBytesValue instanceof NullNode == false) {
                                                long maxSizeBytesInstance;
                                                maxSizeBytesInstance = maxSizeBytesValue.getLongValue();
                                                propertiesInstance2.setMaxSizeBytes(maxSizeBytesInstance);
                                            }
                                            
                                            JsonNode requestedServiceObjectiveIdValue = propertiesValue2.get("requestedServiceObjectiveId");
                                            if (requestedServiceObjectiveIdValue != null && requestedServiceObjectiveIdValue instanceof NullNode == false) {
                                                String requestedServiceObjectiveIdInstance;
                                                requestedServiceObjectiveIdInstance = requestedServiceObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setRequestedServiceObjectiveId(requestedServiceObjectiveIdInstance);
                                            }
                                            
                                            JsonNode requestedServiceObjectiveNameValue = propertiesValue2.get("requestedServiceObjectiveName");
                                            if (requestedServiceObjectiveNameValue != null && requestedServiceObjectiveNameValue instanceof NullNode == false) {
                                                String requestedServiceObjectiveNameInstance;
                                                requestedServiceObjectiveNameInstance = requestedServiceObjectiveNameValue.getTextValue();
                                                propertiesInstance2.setRequestedServiceObjectiveName(requestedServiceObjectiveNameInstance);
                                            }
                                            
                                            JsonNode serviceLevelObjectiveValue = propertiesValue2.get("serviceLevelObjective");
                                            if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                                String serviceLevelObjectiveInstance;
                                                serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setServiceObjective(serviceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode statusValue = propertiesValue2.get("status");
                                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                                String statusInstance;
                                                statusInstance = statusValue.getTextValue();
                                                propertiesInstance2.setStatus(statusInstance);
                                            }
                                            
                                            JsonNode elasticPoolNameValue = propertiesValue2.get("elasticPoolName");
                                            if (elasticPoolNameValue != null && elasticPoolNameValue instanceof NullNode == false) {
                                                String elasticPoolNameInstance;
                                                elasticPoolNameInstance = elasticPoolNameValue.getTextValue();
                                                propertiesInstance2.setElasticPoolName(elasticPoolNameInstance);
                                            }
                                            
                                            JsonNode serviceTierAdvisorsArray = propertiesValue2.get("serviceTierAdvisors");
                                            if (serviceTierAdvisorsArray != null && serviceTierAdvisorsArray instanceof NullNode == false) {
                                                for (JsonNode serviceTierAdvisorsValue : ((ArrayNode) serviceTierAdvisorsArray)) {
                                                    ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                                                    propertiesInstance2.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                                                    
                                                    JsonNode propertiesValue3 = serviceTierAdvisorsValue.get("properties");
                                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                                        ServiceTierAdvisorProperties propertiesInstance3 = new ServiceTierAdvisorProperties();
                                                        serviceTierAdvisorInstance.setProperties(propertiesInstance3);
                                                        
                                                        JsonNode observationPeriodStartValue2 = propertiesValue3.get("observationPeriodStart");
                                                        if (observationPeriodStartValue2 != null && observationPeriodStartValue2 instanceof NullNode == false) {
                                                            Calendar observationPeriodStartInstance2;
                                                            observationPeriodStartInstance2 = DatatypeConverter.parseDateTime(observationPeriodStartValue2.getTextValue());
                                                            propertiesInstance3.setObservationPeriodStart(observationPeriodStartInstance2);
                                                        }
                                                        
                                                        JsonNode observationPeriodEndValue2 = propertiesValue3.get("observationPeriodEnd");
                                                        if (observationPeriodEndValue2 != null && observationPeriodEndValue2 instanceof NullNode == false) {
                                                            Calendar observationPeriodEndInstance2;
                                                            observationPeriodEndInstance2 = DatatypeConverter.parseDateTime(observationPeriodEndValue2.getTextValue());
                                                            propertiesInstance3.setObservationPeriodEnd(observationPeriodEndInstance2);
                                                        }
                                                        
                                                        JsonNode activeTimeRatioValue = propertiesValue3.get("activeTimeRatio");
                                                        if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                                            double activeTimeRatioInstance;
                                                            activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                                            propertiesInstance3.setActiveTimeRatio(activeTimeRatioInstance);
                                                        }
                                                        
                                                        JsonNode minDtuValue = propertiesValue3.get("minDtu");
                                                        if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                                            double minDtuInstance;
                                                            minDtuInstance = minDtuValue.getDoubleValue();
                                                            propertiesInstance3.setMinDtu(minDtuInstance);
                                                        }
                                                        
                                                        JsonNode avgDtuValue = propertiesValue3.get("avgDtu");
                                                        if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                                            double avgDtuInstance;
                                                            avgDtuInstance = avgDtuValue.getDoubleValue();
                                                            propertiesInstance3.setAvgDtu(avgDtuInstance);
                                                        }
                                                        
                                                        JsonNode maxDtuValue = propertiesValue3.get("maxDtu");
                                                        if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                                            double maxDtuInstance;
                                                            maxDtuInstance = maxDtuValue.getDoubleValue();
                                                            propertiesInstance3.setMaxDtu(maxDtuInstance);
                                                        }
                                                        
                                                        JsonNode maxSizeInGBValue = propertiesValue3.get("maxSizeInGB");
                                                        if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                                            double maxSizeInGBInstance;
                                                            maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                                            propertiesInstance3.setMaxSizeInGB(maxSizeInGBInstance);
                                                        }
                                                        
                                                        JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue3.get("serviceLevelObjectiveUsageMetrics");
                                                        if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                                            for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                                                SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                                                propertiesInstance3.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                                                
                                                                JsonNode serviceLevelObjectiveValue2 = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                                                if (serviceLevelObjectiveValue2 != null && serviceLevelObjectiveValue2 instanceof NullNode == false) {
                                                                    String serviceLevelObjectiveInstance2;
                                                                    serviceLevelObjectiveInstance2 = serviceLevelObjectiveValue2.getTextValue();
                                                                    sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance2);
                                                                }
                                                                
                                                                JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                                                if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                                                    String serviceLevelObjectiveIdInstance;
                                                                    serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                                                    sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                                                }
                                                                
                                                                JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                                                if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                                                    double inRangeTimeRatioInstance;
                                                                    inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                                                    sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                                                }
                                                                
                                                                JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                                    String idInstance;
                                                                    idInstance = idValue.getTextValue();
                                                                    sloUsageMetricInstance.setId(idInstance);
                                                                }
                                                                
                                                                JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                                                    String nameInstance;
                                                                    nameInstance = nameValue.getTextValue();
                                                                    sloUsageMetricInstance.setName(nameInstance);
                                                                }
                                                                
                                                                JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                                                    String typeInstance;
                                                                    typeInstance = typeValue.getTextValue();
                                                                    sloUsageMetricInstance.setType(typeInstance);
                                                                }
                                                                
                                                                JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                                                if (locationValue != null && locationValue instanceof NullNode == false) {
                                                                    String locationInstance;
                                                                    locationInstance = locationValue.getTextValue();
                                                                    sloUsageMetricInstance.setLocation(locationInstance);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                                                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                                                    while (itr.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property = itr.next();
                                                                        String tagsKey = property.getKey();
                                                                        String tagsValue = property.getValue().getTextValue();
                                                                        sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        JsonNode currentServiceLevelObjectiveValue = propertiesValue3.get("currentServiceLevelObjective");
                                                        if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String currentServiceLevelObjectiveInstance;
                                                            currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode currentServiceLevelObjectiveIdValue = propertiesValue3.get("currentServiceLevelObjectiveId");
                                                        if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String currentServiceLevelObjectiveIdInstance;
                                                            currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjective");
                                                        if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String usageBasedRecommendationServiceLevelObjectiveInstance;
                                                            usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjectiveId");
                                                        if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                                        if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                                            databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                                        if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                                        if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                                            disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                                        if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue3.get("overallRecommendationServiceLevelObjective");
                                                        if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String overallRecommendationServiceLevelObjectiveInstance;
                                                            overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("overallRecommendationServiceLevelObjectiveId");
                                                        if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String overallRecommendationServiceLevelObjectiveIdInstance;
                                                            overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode confidenceValue = propertiesValue3.get("confidence");
                                                        if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                                            double confidenceInstance;
                                                            confidenceInstance = confidenceValue.getDoubleValue();
                                                            propertiesInstance3.setConfidence(confidenceInstance);
                                                        }
                                                    }
                                                    
                                                    JsonNode idValue2 = serviceTierAdvisorsValue.get("id");
                                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                        String idInstance2;
                                                        idInstance2 = idValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setId(idInstance2);
                                                    }
                                                    
                                                    JsonNode nameValue2 = serviceTierAdvisorsValue.get("name");
                                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                                        String nameInstance2;
                                                        nameInstance2 = nameValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setName(nameInstance2);
                                                    }
                                                    
                                                    JsonNode typeValue2 = serviceTierAdvisorsValue.get("type");
                                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                        String typeInstance2;
                                                        typeInstance2 = typeValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setType(typeInstance2);
                                                    }
                                                    
                                                    JsonNode locationValue2 = serviceTierAdvisorsValue.get("location");
                                                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                                        String locationInstance2;
                                                        locationInstance2 = locationValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setLocation(locationInstance2);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement2 = ((JsonNode) serviceTierAdvisorsValue.get("tags"));
                                                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                                        while (itr2.hasNext()) {
                                                            Map.Entry<String, JsonNode> property2 = itr2.next();
                                                            String tagsKey2 = property2.getKey();
                                                            String tagsValue2 = property2.getValue().getTextValue();
                                                            serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode upgradeHintValue = propertiesValue2.get("upgradeHint");
                                            if (upgradeHintValue != null && upgradeHintValue instanceof NullNode == false) {
                                                UpgradeHint upgradeHintInstance = new UpgradeHint();
                                                propertiesInstance2.setUpgradeHint(upgradeHintInstance);
                                                
                                                JsonNode targetServiceLevelObjectiveValue = upgradeHintValue.get("targetServiceLevelObjective");
                                                if (targetServiceLevelObjectiveValue != null && targetServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String targetServiceLevelObjectiveInstance;
                                                    targetServiceLevelObjectiveInstance = targetServiceLevelObjectiveValue.getTextValue();
                                                    upgradeHintInstance.setTargetServiceLevelObjective(targetServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode targetServiceLevelObjectiveIdValue = upgradeHintValue.get("targetServiceLevelObjectiveId");
                                                if (targetServiceLevelObjectiveIdValue != null && targetServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String targetServiceLevelObjectiveIdInstance;
                                                    targetServiceLevelObjectiveIdInstance = targetServiceLevelObjectiveIdValue.getTextValue();
                                                    upgradeHintInstance.setTargetServiceLevelObjectiveId(targetServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode idValue3 = upgradeHintValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    upgradeHintInstance.setId(idInstance3);
                                                }
                                                
                                                JsonNode nameValue3 = upgradeHintValue.get("name");
                                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                    String nameInstance3;
                                                    nameInstance3 = nameValue3.getTextValue();
                                                    upgradeHintInstance.setName(nameInstance3);
                                                }
                                                
                                                JsonNode typeValue3 = upgradeHintValue.get("type");
                                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                                    String typeInstance3;
                                                    typeInstance3 = typeValue3.getTextValue();
                                                    upgradeHintInstance.setType(typeInstance3);
                                                }
                                                
                                                JsonNode locationValue3 = upgradeHintValue.get("location");
                                                if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                                    String locationInstance3;
                                                    locationInstance3 = locationValue3.getTextValue();
                                                    upgradeHintInstance.setLocation(locationInstance3);
                                                }
                                                
                                                JsonNode tagsSequenceElement3 = ((JsonNode) upgradeHintValue.get("tags"));
                                                if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                                    Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                                    while (itr3.hasNext()) {
                                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                                        String tagsKey3 = property3.getKey();
                                                        String tagsValue3 = property3.getValue().getTextValue();
                                                        upgradeHintInstance.getTags().put(tagsKey3, tagsValue3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode schemasArray = propertiesValue2.get("schemas");
                                            if (schemasArray != null && schemasArray instanceof NullNode == false) {
                                                for (JsonNode schemasValue : ((ArrayNode) schemasArray)) {
                                                    Schema schemaInstance = new Schema();
                                                    propertiesInstance2.getSchemas().add(schemaInstance);
                                                    
                                                    JsonNode propertiesValue4 = schemasValue.get("properties");
                                                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                                        SchemaProperties propertiesInstance4 = new SchemaProperties();
                                                        schemaInstance.setProperties(propertiesInstance4);
                                                        
                                                        JsonNode tablesArray = propertiesValue4.get("tables");
                                                        if (tablesArray != null && tablesArray instanceof NullNode == false) {
                                                            for (JsonNode tablesValue : ((ArrayNode) tablesArray)) {
                                                                Table tableInstance = new Table();
                                                                propertiesInstance4.getTables().add(tableInstance);
                                                                
                                                                JsonNode propertiesValue5 = tablesValue.get("properties");
                                                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                                                    TableProperties propertiesInstance5 = new TableProperties();
                                                                    tableInstance.setProperties(propertiesInstance5);
                                                                    
                                                                    JsonNode tableTypeValue = propertiesValue5.get("tableType");
                                                                    if (tableTypeValue != null && tableTypeValue instanceof NullNode == false) {
                                                                        String tableTypeInstance;
                                                                        tableTypeInstance = tableTypeValue.getTextValue();
                                                                        propertiesInstance5.setTableType(tableTypeInstance);
                                                                    }
                                                                    
                                                                    JsonNode columnsArray = propertiesValue5.get("columns");
                                                                    if (columnsArray != null && columnsArray instanceof NullNode == false) {
                                                                        for (JsonNode columnsValue : ((ArrayNode) columnsArray)) {
                                                                            Column columnInstance = new Column();
                                                                            propertiesInstance5.getColumns().add(columnInstance);
                                                                            
                                                                            JsonNode propertiesValue6 = columnsValue.get("properties");
                                                                            if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                                                                ColumnProperties propertiesInstance6 = new ColumnProperties();
                                                                                columnInstance.setProperties(propertiesInstance6);
                                                                                
                                                                                JsonNode columnTypeValue = propertiesValue6.get("columnType");
                                                                                if (columnTypeValue != null && columnTypeValue instanceof NullNode == false) {
                                                                                    String columnTypeInstance;
                                                                                    columnTypeInstance = columnTypeValue.getTextValue();
                                                                                    propertiesInstance6.setColumnType(columnTypeInstance);
                                                                                }
                                                                            }
                                                                            
                                                                            JsonNode idValue4 = columnsValue.get("id");
                                                                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                                                String idInstance4;
                                                                                idInstance4 = idValue4.getTextValue();
                                                                                columnInstance.setId(idInstance4);
                                                                            }
                                                                            
                                                                            JsonNode nameValue4 = columnsValue.get("name");
                                                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                                                String nameInstance4;
                                                                                nameInstance4 = nameValue4.getTextValue();
                                                                                columnInstance.setName(nameInstance4);
                                                                            }
                                                                            
                                                                            JsonNode typeValue4 = columnsValue.get("type");
                                                                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                                                String typeInstance4;
                                                                                typeInstance4 = typeValue4.getTextValue();
                                                                                columnInstance.setType(typeInstance4);
                                                                            }
                                                                            
                                                                            JsonNode locationValue4 = columnsValue.get("location");
                                                                            if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                                                                String locationInstance4;
                                                                                locationInstance4 = locationValue4.getTextValue();
                                                                                columnInstance.setLocation(locationInstance4);
                                                                            }
                                                                            
                                                                            JsonNode tagsSequenceElement4 = ((JsonNode) columnsValue.get("tags"));
                                                                            if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                                                                Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                                                                while (itr4.hasNext()) {
                                                                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                                                                    String tagsKey4 = property4.getKey();
                                                                                    String tagsValue4 = property4.getValue().getTextValue();
                                                                                    columnInstance.getTags().put(tagsKey4, tagsValue4);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode recommendedIndexesArray = propertiesValue5.get("recommendedIndexes");
                                                                    if (recommendedIndexesArray != null && recommendedIndexesArray instanceof NullNode == false) {
                                                                        for (JsonNode recommendedIndexesValue : ((ArrayNode) recommendedIndexesArray)) {
                                                                            RecommendedIndex recommendedIndexInstance = new RecommendedIndex();
                                                                            propertiesInstance5.getRecommendedIndexes().add(recommendedIndexInstance);
                                                                            
                                                                            JsonNode propertiesValue7 = recommendedIndexesValue.get("properties");
                                                                            if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                                                                RecommendedIndexProperties propertiesInstance7 = new RecommendedIndexProperties();
                                                                                recommendedIndexInstance.setProperties(propertiesInstance7);
                                                                                
                                                                                JsonNode actionValue = propertiesValue7.get("action");
                                                                                if (actionValue != null && actionValue instanceof NullNode == false) {
                                                                                    String actionInstance;
                                                                                    actionInstance = actionValue.getTextValue();
                                                                                    propertiesInstance7.setAction(actionInstance);
                                                                                }
                                                                                
                                                                                JsonNode stateValue = propertiesValue7.get("state");
                                                                                if (stateValue != null && stateValue instanceof NullNode == false) {
                                                                                    String stateInstance;
                                                                                    stateInstance = stateValue.getTextValue();
                                                                                    propertiesInstance7.setState(stateInstance);
                                                                                }
                                                                                
                                                                                JsonNode createdValue = propertiesValue7.get("created");
                                                                                if (createdValue != null && createdValue instanceof NullNode == false) {
                                                                                    Calendar createdInstance;
                                                                                    createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                                                                    propertiesInstance7.setCreated(createdInstance);
                                                                                }
                                                                                
                                                                                JsonNode lastModifiedValue = propertiesValue7.get("lastModified");
                                                                                if (lastModifiedValue != null && lastModifiedValue instanceof NullNode == false) {
                                                                                    Calendar lastModifiedInstance;
                                                                                    lastModifiedInstance = DatatypeConverter.parseDateTime(lastModifiedValue.getTextValue());
                                                                                    propertiesInstance7.setLastModified(lastModifiedInstance);
                                                                                }
                                                                                
                                                                                JsonNode indexTypeValue = propertiesValue7.get("indexType");
                                                                                if (indexTypeValue != null && indexTypeValue instanceof NullNode == false) {
                                                                                    String indexTypeInstance;
                                                                                    indexTypeInstance = indexTypeValue.getTextValue();
                                                                                    propertiesInstance7.setIndexType(indexTypeInstance);
                                                                                }
                                                                                
                                                                                JsonNode schemaValue = propertiesValue7.get("schema");
                                                                                if (schemaValue != null && schemaValue instanceof NullNode == false) {
                                                                                    String schemaInstance2;
                                                                                    schemaInstance2 = schemaValue.getTextValue();
                                                                                    propertiesInstance7.setSchema(schemaInstance2);
                                                                                }
                                                                                
                                                                                JsonNode tableValue = propertiesValue7.get("table");
                                                                                if (tableValue != null && tableValue instanceof NullNode == false) {
                                                                                    String tableInstance2;
                                                                                    tableInstance2 = tableValue.getTextValue();
                                                                                    propertiesInstance7.setTable(tableInstance2);
                                                                                }
                                                                                
                                                                                JsonNode columnsArray2 = propertiesValue7.get("columns");
                                                                                if (columnsArray2 != null && columnsArray2 instanceof NullNode == false) {
                                                                                    for (JsonNode columnsValue2 : ((ArrayNode) columnsArray2)) {
                                                                                        propertiesInstance7.getColumns().add(columnsValue2.getTextValue());
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode includedColumnsArray = propertiesValue7.get("includedColumns");
                                                                                if (includedColumnsArray != null && includedColumnsArray instanceof NullNode == false) {
                                                                                    for (JsonNode includedColumnsValue : ((ArrayNode) includedColumnsArray)) {
                                                                                        propertiesInstance7.getIncludedColumns().add(includedColumnsValue.getTextValue());
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode indexScriptValue = propertiesValue7.get("indexScript");
                                                                                if (indexScriptValue != null && indexScriptValue instanceof NullNode == false) {
                                                                                    String indexScriptInstance;
                                                                                    indexScriptInstance = indexScriptValue.getTextValue();
                                                                                    propertiesInstance7.setIndexScript(indexScriptInstance);
                                                                                }
                                                                                
                                                                                JsonNode estimatedImpactArray = propertiesValue7.get("estimatedImpact");
                                                                                if (estimatedImpactArray != null && estimatedImpactArray instanceof NullNode == false) {
                                                                                    for (JsonNode estimatedImpactValue : ((ArrayNode) estimatedImpactArray)) {
                                                                                        OperationImpact operationImpactInstance = new OperationImpact();
                                                                                        propertiesInstance7.getEstimatedImpact().add(operationImpactInstance);
                                                                                        
                                                                                        JsonNode nameValue5 = estimatedImpactValue.get("name");
                                                                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                                                            String nameInstance5;
                                                                                            nameInstance5 = nameValue5.getTextValue();
                                                                                            operationImpactInstance.setName(nameInstance5);
                                                                                        }
                                                                                        
                                                                                        JsonNode unitValue = estimatedImpactValue.get("unit");
                                                                                        if (unitValue != null && unitValue instanceof NullNode == false) {
                                                                                            String unitInstance;
                                                                                            unitInstance = unitValue.getTextValue();
                                                                                            operationImpactInstance.setUnit(unitInstance);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueAbsoluteValue = estimatedImpactValue.get("changeValueAbsolute");
                                                                                        if (changeValueAbsoluteValue != null && changeValueAbsoluteValue instanceof NullNode == false) {
                                                                                            double changeValueAbsoluteInstance;
                                                                                            changeValueAbsoluteInstance = changeValueAbsoluteValue.getDoubleValue();
                                                                                            operationImpactInstance.setChangeValueAbsolute(changeValueAbsoluteInstance);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueRelativeValue = estimatedImpactValue.get("changeValueRelative");
                                                                                        if (changeValueRelativeValue != null && changeValueRelativeValue instanceof NullNode == false) {
                                                                                            double changeValueRelativeInstance;
                                                                                            changeValueRelativeInstance = changeValueRelativeValue.getDoubleValue();
                                                                                            operationImpactInstance.setChangeValueRelative(changeValueRelativeInstance);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode reportedImpactArray = propertiesValue7.get("reportedImpact");
                                                                                if (reportedImpactArray != null && reportedImpactArray instanceof NullNode == false) {
                                                                                    for (JsonNode reportedImpactValue : ((ArrayNode) reportedImpactArray)) {
                                                                                        OperationImpact operationImpactInstance2 = new OperationImpact();
                                                                                        propertiesInstance7.getReportedImpact().add(operationImpactInstance2);
                                                                                        
                                                                                        JsonNode nameValue6 = reportedImpactValue.get("name");
                                                                                        if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                                                            String nameInstance6;
                                                                                            nameInstance6 = nameValue6.getTextValue();
                                                                                            operationImpactInstance2.setName(nameInstance6);
                                                                                        }
                                                                                        
                                                                                        JsonNode unitValue2 = reportedImpactValue.get("unit");
                                                                                        if (unitValue2 != null && unitValue2 instanceof NullNode == false) {
                                                                                            String unitInstance2;
                                                                                            unitInstance2 = unitValue2.getTextValue();
                                                                                            operationImpactInstance2.setUnit(unitInstance2);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueAbsoluteValue2 = reportedImpactValue.get("changeValueAbsolute");
                                                                                        if (changeValueAbsoluteValue2 != null && changeValueAbsoluteValue2 instanceof NullNode == false) {
                                                                                            double changeValueAbsoluteInstance2;
                                                                                            changeValueAbsoluteInstance2 = changeValueAbsoluteValue2.getDoubleValue();
                                                                                            operationImpactInstance2.setChangeValueAbsolute(changeValueAbsoluteInstance2);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueRelativeValue2 = reportedImpactValue.get("changeValueRelative");
                                                                                        if (changeValueRelativeValue2 != null && changeValueRelativeValue2 instanceof NullNode == false) {
                                                                                            double changeValueRelativeInstance2;
                                                                                            changeValueRelativeInstance2 = changeValueRelativeValue2.getDoubleValue();
                                                                                            operationImpactInstance2.setChangeValueRelative(changeValueRelativeInstance2);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            
                                                                            JsonNode idValue5 = recommendedIndexesValue.get("id");
                                                                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                                                String idInstance5;
                                                                                idInstance5 = idValue5.getTextValue();
                                                                                recommendedIndexInstance.setId(idInstance5);
                                                                            }
                                                                            
                                                                            JsonNode nameValue7 = recommendedIndexesValue.get("name");
                                                                            if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                                                                String nameInstance7;
                                                                                nameInstance7 = nameValue7.getTextValue();
                                                                                recommendedIndexInstance.setName(nameInstance7);
                                                                            }
                                                                            
                                                                            JsonNode typeValue5 = recommendedIndexesValue.get("type");
                                                                            if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                                                String typeInstance5;
                                                                                typeInstance5 = typeValue5.getTextValue();
                                                                                recommendedIndexInstance.setType(typeInstance5);
                                                                            }
                                                                            
                                                                            JsonNode locationValue5 = recommendedIndexesValue.get("location");
                                                                            if (locationValue5 != null && locationValue5 instanceof NullNode == false) {
                                                                                String locationInstance5;
                                                                                locationInstance5 = locationValue5.getTextValue();
                                                                                recommendedIndexInstance.setLocation(locationInstance5);
                                                                            }
                                                                            
                                                                            JsonNode tagsSequenceElement5 = ((JsonNode) recommendedIndexesValue.get("tags"));
                                                                            if (tagsSequenceElement5 != null && tagsSequenceElement5 instanceof NullNode == false) {
                                                                                Iterator<Map.Entry<String, JsonNode>> itr5 = tagsSequenceElement5.getFields();
                                                                                while (itr5.hasNext()) {
                                                                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                                                                    String tagsKey5 = property5.getKey();
                                                                                    String tagsValue5 = property5.getValue().getTextValue();
                                                                                    recommendedIndexInstance.getTags().put(tagsKey5, tagsValue5);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                
                                                                JsonNode idValue6 = tablesValue.get("id");
                                                                if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                                    String idInstance6;
                                                                    idInstance6 = idValue6.getTextValue();
                                                                    tableInstance.setId(idInstance6);
                                                                }
                                                                
                                                                JsonNode nameValue8 = tablesValue.get("name");
                                                                if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                                                    String nameInstance8;
                                                                    nameInstance8 = nameValue8.getTextValue();
                                                                    tableInstance.setName(nameInstance8);
                                                                }
                                                                
                                                                JsonNode typeValue6 = tablesValue.get("type");
                                                                if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                                    String typeInstance6;
                                                                    typeInstance6 = typeValue6.getTextValue();
                                                                    tableInstance.setType(typeInstance6);
                                                                }
                                                                
                                                                JsonNode locationValue6 = tablesValue.get("location");
                                                                if (locationValue6 != null && locationValue6 instanceof NullNode == false) {
                                                                    String locationInstance6;
                                                                    locationInstance6 = locationValue6.getTextValue();
                                                                    tableInstance.setLocation(locationInstance6);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement6 = ((JsonNode) tablesValue.get("tags"));
                                                                if (tagsSequenceElement6 != null && tagsSequenceElement6 instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement6.getFields();
                                                                    while (itr6.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property6 = itr6.next();
                                                                        String tagsKey6 = property6.getKey();
                                                                        String tagsValue6 = property6.getValue().getTextValue();
                                                                        tableInstance.getTags().put(tagsKey6, tagsValue6);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    
                                                    JsonNode idValue7 = schemasValue.get("id");
                                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                        String idInstance7;
                                                        idInstance7 = idValue7.getTextValue();
                                                        schemaInstance.setId(idInstance7);
                                                    }
                                                    
                                                    JsonNode nameValue9 = schemasValue.get("name");
                                                    if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                                        String nameInstance9;
                                                        nameInstance9 = nameValue9.getTextValue();
                                                        schemaInstance.setName(nameInstance9);
                                                    }
                                                    
                                                    JsonNode typeValue7 = schemasValue.get("type");
                                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                        String typeInstance7;
                                                        typeInstance7 = typeValue7.getTextValue();
                                                        schemaInstance.setType(typeInstance7);
                                                    }
                                                    
                                                    JsonNode locationValue7 = schemasValue.get("location");
                                                    if (locationValue7 != null && locationValue7 instanceof NullNode == false) {
                                                        String locationInstance7;
                                                        locationInstance7 = locationValue7.getTextValue();
                                                        schemaInstance.setLocation(locationInstance7);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement7 = ((JsonNode) schemasValue.get("tags"));
                                                    if (tagsSequenceElement7 != null && tagsSequenceElement7 instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr7 = tagsSequenceElement7.getFields();
                                                        while (itr7.hasNext()) {
                                                            Map.Entry<String, JsonNode> property7 = itr7.next();
                                                            String tagsKey7 = property7.getKey();
                                                            String tagsValue7 = property7.getValue().getTextValue();
                                                            schemaInstance.getTags().put(tagsKey7, tagsValue7);
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode defaultSecondaryLocationValue = propertiesValue2.get("defaultSecondaryLocation");
                                            if (defaultSecondaryLocationValue != null && defaultSecondaryLocationValue instanceof NullNode == false) {
                                                String defaultSecondaryLocationInstance;
                                                defaultSecondaryLocationInstance = defaultSecondaryLocationValue.getTextValue();
                                                propertiesInstance2.setDefaultSecondaryLocation(defaultSecondaryLocationInstance);
                                            }
                                        }
                                        
                                        JsonNode idValue8 = databasesValue.get("id");
                                        if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                            String idInstance8;
                                            idInstance8 = idValue8.getTextValue();
                                            databaseInstance.setId(idInstance8);
                                        }
                                        
                                        JsonNode nameValue10 = databasesValue.get("name");
                                        if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                            String nameInstance10;
                                            nameInstance10 = nameValue10.getTextValue();
                                            databaseInstance.setName(nameInstance10);
                                        }
                                        
                                        JsonNode typeValue8 = databasesValue.get("type");
                                        if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                            String typeInstance8;
                                            typeInstance8 = typeValue8.getTextValue();
                                            databaseInstance.setType(typeInstance8);
                                        }
                                        
                                        JsonNode locationValue8 = databasesValue.get("location");
                                        if (locationValue8 != null && locationValue8 instanceof NullNode == false) {
                                            String locationInstance8;
                                            locationInstance8 = locationValue8.getTextValue();
                                            databaseInstance.setLocation(locationInstance8);
                                        }
                                        
                                        JsonNode tagsSequenceElement8 = ((JsonNode) databasesValue.get("tags"));
                                        if (tagsSequenceElement8 != null && tagsSequenceElement8 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr8 = tagsSequenceElement8.getFields();
                                            while (itr8.hasNext()) {
                                                Map.Entry<String, JsonNode> property8 = itr8.next();
                                                String tagsKey8 = property8.getKey();
                                                String tagsValue8 = property8.getValue().getTextValue();
                                                databaseInstance.getTags().put(tagsKey8, tagsValue8);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode metricsArray = propertiesValue.get("metrics");
                                if (metricsArray != null && metricsArray instanceof NullNode == false) {
                                    for (JsonNode metricsValue : ((ArrayNode) metricsArray)) {
                                        RecommendedElasticPoolMetric recommendedElasticPoolMetricInstance = new RecommendedElasticPoolMetric();
                                        propertiesInstance.getMetrics().add(recommendedElasticPoolMetricInstance);
                                        
                                        JsonNode dateTimeValue = metricsValue.get("dateTime");
                                        if (dateTimeValue != null && dateTimeValue instanceof NullNode == false) {
                                            Calendar dateTimeInstance;
                                            dateTimeInstance = DatatypeConverter.parseDateTime(dateTimeValue.getTextValue());
                                            recommendedElasticPoolMetricInstance.setDateTime(dateTimeInstance);
                                        }
                                        
                                        JsonNode dtuValue2 = metricsValue.get("dtu");
                                        if (dtuValue2 != null && dtuValue2 instanceof NullNode == false) {
                                            double dtuInstance2;
                                            dtuInstance2 = dtuValue2.getDoubleValue();
                                            recommendedElasticPoolMetricInstance.setDtu(dtuInstance2);
                                        }
                                        
                                        JsonNode sizeGBValue = metricsValue.get("sizeGB");
                                        if (sizeGBValue != null && sizeGBValue instanceof NullNode == false) {
                                            double sizeGBInstance;
                                            sizeGBInstance = sizeGBValue.getDoubleValue();
                                            recommendedElasticPoolMetricInstance.setSizeGB(sizeGBInstance);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue9 = valueValue.get("id");
                            if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                String idInstance9;
                                idInstance9 = idValue9.getTextValue();
                                recommendedElasticPoolInstance.setId(idInstance9);
                            }
                            
                            JsonNode nameValue11 = valueValue.get("name");
                            if (nameValue11 != null && nameValue11 instanceof NullNode == false) {
                                String nameInstance11;
                                nameInstance11 = nameValue11.getTextValue();
                                recommendedElasticPoolInstance.setName(nameInstance11);
                            }
                            
                            JsonNode typeValue9 = valueValue.get("type");
                            if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                String typeInstance9;
                                typeInstance9 = typeValue9.getTextValue();
                                recommendedElasticPoolInstance.setType(typeInstance9);
                            }
                            
                            JsonNode locationValue9 = valueValue.get("location");
                            if (locationValue9 != null && locationValue9 instanceof NullNode == false) {
                                String locationInstance9;
                                locationInstance9 = locationValue9.getTextValue();
                                recommendedElasticPoolInstance.setLocation(locationInstance9);
                            }
                            
                            JsonNode tagsSequenceElement9 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement9 != null && tagsSequenceElement9 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr9 = tagsSequenceElement9.getFields();
                                while (itr9.hasNext()) {
                                    Map.Entry<String, JsonNode> property9 = itr9.next();
                                    String tagsKey9 = property9.getKey();
                                    String tagsValue9 = property9.getValue().getTextValue();
                                    recommendedElasticPoolInstance.getTags().put(tagsKey9, tagsValue9);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a List Azure Sql Database request.
    */
    @Override
    public Future<DatabaseListResponse> listDatabasesAsync(final String resourceGroupName, final String serverName, final String recommendedElasticPoolName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseListResponse>() { 
            @Override
            public DatabaseListResponse call() throws Exception {
                return listDatabases(resourceGroupName, serverName, recommendedElasticPoolName);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Database inside of an Azure Sql
    * Recommended Elastic Pool.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database request.
    */
    @Override
    public DatabaseListResponse listDatabases(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (recommendedElasticPoolName == null) {
            throw new NullPointerException("recommendedElasticPoolName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("recommendedElasticPoolName", recommendedElasticPoolName);
            CloudTracing.enter(invocationId, this, "listDatabasesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools/";
        url = url + URLEncoder.encode(recommendedElasticPoolName, "UTF-8");
        url = url + "/databases";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            Database databaseInstance = new Database();
                            result.getDatabases().add(databaseInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DatabaseProperties propertiesInstance = new DatabaseProperties();
                                databaseInstance.setProperties(propertiesInstance);
                                
                                JsonNode collationValue = propertiesValue.get("collation");
                                if (collationValue != null && collationValue instanceof NullNode == false) {
                                    String collationInstance;
                                    collationInstance = collationValue.getTextValue();
                                    propertiesInstance.setCollation(collationInstance);
                                }
                                
                                JsonNode creationDateValue = propertiesValue.get("creationDate");
                                if (creationDateValue != null && creationDateValue instanceof NullNode == false) {
                                    Calendar creationDateInstance;
                                    creationDateInstance = DatatypeConverter.parseDateTime(creationDateValue.getTextValue());
                                    propertiesInstance.setCreationDate(creationDateInstance);
                                }
                                
                                JsonNode currentServiceObjectiveIdValue = propertiesValue.get("currentServiceObjectiveId");
                                if (currentServiceObjectiveIdValue != null && currentServiceObjectiveIdValue instanceof NullNode == false) {
                                    String currentServiceObjectiveIdInstance;
                                    currentServiceObjectiveIdInstance = currentServiceObjectiveIdValue.getTextValue();
                                    propertiesInstance.setCurrentServiceObjectiveId(currentServiceObjectiveIdInstance);
                                }
                                
                                JsonNode databaseIdValue = propertiesValue.get("databaseId");
                                if (databaseIdValue != null && databaseIdValue instanceof NullNode == false) {
                                    String databaseIdInstance;
                                    databaseIdInstance = databaseIdValue.getTextValue();
                                    propertiesInstance.setDatabaseId(databaseIdInstance);
                                }
                                
                                JsonNode earliestRestoreDateValue = propertiesValue.get("earliestRestoreDate");
                                if (earliestRestoreDateValue != null && earliestRestoreDateValue instanceof NullNode == false) {
                                    Calendar earliestRestoreDateInstance;
                                    earliestRestoreDateInstance = DatatypeConverter.parseDateTime(earliestRestoreDateValue.getTextValue());
                                    propertiesInstance.setEarliestRestoreDate(earliestRestoreDateInstance);
                                }
                                
                                JsonNode editionValue = propertiesValue.get("edition");
                                if (editionValue != null && editionValue instanceof NullNode == false) {
                                    String editionInstance;
                                    editionInstance = editionValue.getTextValue();
                                    propertiesInstance.setEdition(editionInstance);
                                }
                                
                                JsonNode maxSizeBytesValue = propertiesValue.get("maxSizeBytes");
                                if (maxSizeBytesValue != null && maxSizeBytesValue instanceof NullNode == false) {
                                    long maxSizeBytesInstance;
                                    maxSizeBytesInstance = maxSizeBytesValue.getLongValue();
                                    propertiesInstance.setMaxSizeBytes(maxSizeBytesInstance);
                                }
                                
                                JsonNode requestedServiceObjectiveIdValue = propertiesValue.get("requestedServiceObjectiveId");
                                if (requestedServiceObjectiveIdValue != null && requestedServiceObjectiveIdValue instanceof NullNode == false) {
                                    String requestedServiceObjectiveIdInstance;
                                    requestedServiceObjectiveIdInstance = requestedServiceObjectiveIdValue.getTextValue();
                                    propertiesInstance.setRequestedServiceObjectiveId(requestedServiceObjectiveIdInstance);
                                }
                                
                                JsonNode requestedServiceObjectiveNameValue = propertiesValue.get("requestedServiceObjectiveName");
                                if (requestedServiceObjectiveNameValue != null && requestedServiceObjectiveNameValue instanceof NullNode == false) {
                                    String requestedServiceObjectiveNameInstance;
                                    requestedServiceObjectiveNameInstance = requestedServiceObjectiveNameValue.getTextValue();
                                    propertiesInstance.setRequestedServiceObjectiveName(requestedServiceObjectiveNameInstance);
                                }
                                
                                JsonNode serviceLevelObjectiveValue = propertiesValue.get("serviceLevelObjective");
                                if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                    String serviceLevelObjectiveInstance;
                                    serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setServiceObjective(serviceLevelObjectiveInstance);
                                }
                                
                                JsonNode statusValue = propertiesValue.get("status");
                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                    String statusInstance;
                                    statusInstance = statusValue.getTextValue();
                                    propertiesInstance.setStatus(statusInstance);
                                }
                                
                                JsonNode elasticPoolNameValue = propertiesValue.get("elasticPoolName");
                                if (elasticPoolNameValue != null && elasticPoolNameValue instanceof NullNode == false) {
                                    String elasticPoolNameInstance;
                                    elasticPoolNameInstance = elasticPoolNameValue.getTextValue();
                                    propertiesInstance.setElasticPoolName(elasticPoolNameInstance);
                                }
                                
                                JsonNode serviceTierAdvisorsArray = propertiesValue.get("serviceTierAdvisors");
                                if (serviceTierAdvisorsArray != null && serviceTierAdvisorsArray instanceof NullNode == false) {
                                    for (JsonNode serviceTierAdvisorsValue : ((ArrayNode) serviceTierAdvisorsArray)) {
                                        ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                                        propertiesInstance.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                                        
                                        JsonNode propertiesValue2 = serviceTierAdvisorsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            ServiceTierAdvisorProperties propertiesInstance2 = new ServiceTierAdvisorProperties();
                                            serviceTierAdvisorInstance.setProperties(propertiesInstance2);
                                            
                                            JsonNode observationPeriodStartValue = propertiesValue2.get("observationPeriodStart");
                                            if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                                                Calendar observationPeriodStartInstance;
                                                observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                                                propertiesInstance2.setObservationPeriodStart(observationPeriodStartInstance);
                                            }
                                            
                                            JsonNode observationPeriodEndValue = propertiesValue2.get("observationPeriodEnd");
                                            if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                                                Calendar observationPeriodEndInstance;
                                                observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                                                propertiesInstance2.setObservationPeriodEnd(observationPeriodEndInstance);
                                            }
                                            
                                            JsonNode activeTimeRatioValue = propertiesValue2.get("activeTimeRatio");
                                            if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                                double activeTimeRatioInstance;
                                                activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                                propertiesInstance2.setActiveTimeRatio(activeTimeRatioInstance);
                                            }
                                            
                                            JsonNode minDtuValue = propertiesValue2.get("minDtu");
                                            if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                                double minDtuInstance;
                                                minDtuInstance = minDtuValue.getDoubleValue();
                                                propertiesInstance2.setMinDtu(minDtuInstance);
                                            }
                                            
                                            JsonNode avgDtuValue = propertiesValue2.get("avgDtu");
                                            if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                                double avgDtuInstance;
                                                avgDtuInstance = avgDtuValue.getDoubleValue();
                                                propertiesInstance2.setAvgDtu(avgDtuInstance);
                                            }
                                            
                                            JsonNode maxDtuValue = propertiesValue2.get("maxDtu");
                                            if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                                double maxDtuInstance;
                                                maxDtuInstance = maxDtuValue.getDoubleValue();
                                                propertiesInstance2.setMaxDtu(maxDtuInstance);
                                            }
                                            
                                            JsonNode maxSizeInGBValue = propertiesValue2.get("maxSizeInGB");
                                            if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                                double maxSizeInGBInstance;
                                                maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                                propertiesInstance2.setMaxSizeInGB(maxSizeInGBInstance);
                                            }
                                            
                                            JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue2.get("serviceLevelObjectiveUsageMetrics");
                                            if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                                for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                                    SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                                    propertiesInstance2.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                                    
                                                    JsonNode serviceLevelObjectiveValue2 = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                                    if (serviceLevelObjectiveValue2 != null && serviceLevelObjectiveValue2 instanceof NullNode == false) {
                                                        String serviceLevelObjectiveInstance2;
                                                        serviceLevelObjectiveInstance2 = serviceLevelObjectiveValue2.getTextValue();
                                                        sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance2);
                                                    }
                                                    
                                                    JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                                    if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                                        String serviceLevelObjectiveIdInstance;
                                                        serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                                        sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                                    }
                                                    
                                                    JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                                    if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                                        double inRangeTimeRatioInstance;
                                                        inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                                        sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                                    }
                                                    
                                                    JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                                    if (idValue != null && idValue instanceof NullNode == false) {
                                                        String idInstance;
                                                        idInstance = idValue.getTextValue();
                                                        sloUsageMetricInstance.setId(idInstance);
                                                    }
                                                    
                                                    JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                                        String nameInstance;
                                                        nameInstance = nameValue.getTextValue();
                                                        sloUsageMetricInstance.setName(nameInstance);
                                                    }
                                                    
                                                    JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                                        String typeInstance;
                                                        typeInstance = typeValue.getTextValue();
                                                        sloUsageMetricInstance.setType(typeInstance);
                                                    }
                                                    
                                                    JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                                    if (locationValue != null && locationValue instanceof NullNode == false) {
                                                        String locationInstance;
                                                        locationInstance = locationValue.getTextValue();
                                                        sloUsageMetricInstance.setLocation(locationInstance);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                                        while (itr.hasNext()) {
                                                            Map.Entry<String, JsonNode> property = itr.next();
                                                            String tagsKey = property.getKey();
                                                            String tagsValue = property.getValue().getTextValue();
                                                            sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode currentServiceLevelObjectiveValue = propertiesValue2.get("currentServiceLevelObjective");
                                            if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                                String currentServiceLevelObjectiveInstance;
                                                currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode currentServiceLevelObjectiveIdValue = propertiesValue2.get("currentServiceLevelObjectiveId");
                                            if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String currentServiceLevelObjectiveIdInstance;
                                                currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("usageBasedRecommendationServiceLevelObjective");
                                            if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                String usageBasedRecommendationServiceLevelObjectiveInstance;
                                                usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("usageBasedRecommendationServiceLevelObjectiveId");
                                            if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                                usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                            if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                                databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                            if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                                databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue2.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                            if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                                disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                            if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                                disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue2.get("overallRecommendationServiceLevelObjective");
                                            if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                String overallRecommendationServiceLevelObjectiveInstance;
                                                overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue2.get("overallRecommendationServiceLevelObjectiveId");
                                            if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                String overallRecommendationServiceLevelObjectiveIdInstance;
                                                overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                            }
                                            
                                            JsonNode confidenceValue = propertiesValue2.get("confidence");
                                            if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                                double confidenceInstance;
                                                confidenceInstance = confidenceValue.getDoubleValue();
                                                propertiesInstance2.setConfidence(confidenceInstance);
                                            }
                                        }
                                        
                                        JsonNode idValue2 = serviceTierAdvisorsValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            serviceTierAdvisorInstance.setId(idInstance2);
                                        }
                                        
                                        JsonNode nameValue2 = serviceTierAdvisorsValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            serviceTierAdvisorInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode typeValue2 = serviceTierAdvisorsValue.get("type");
                                        if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                            String typeInstance2;
                                            typeInstance2 = typeValue2.getTextValue();
                                            serviceTierAdvisorInstance.setType(typeInstance2);
                                        }
                                        
                                        JsonNode locationValue2 = serviceTierAdvisorsValue.get("location");
                                        if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                            String locationInstance2;
                                            locationInstance2 = locationValue2.getTextValue();
                                            serviceTierAdvisorInstance.setLocation(locationInstance2);
                                        }
                                        
                                        JsonNode tagsSequenceElement2 = ((JsonNode) serviceTierAdvisorsValue.get("tags"));
                                        if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                            while (itr2.hasNext()) {
                                                Map.Entry<String, JsonNode> property2 = itr2.next();
                                                String tagsKey2 = property2.getKey();
                                                String tagsValue2 = property2.getValue().getTextValue();
                                                serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode upgradeHintValue = propertiesValue.get("upgradeHint");
                                if (upgradeHintValue != null && upgradeHintValue instanceof NullNode == false) {
                                    UpgradeHint upgradeHintInstance = new UpgradeHint();
                                    propertiesInstance.setUpgradeHint(upgradeHintInstance);
                                    
                                    JsonNode targetServiceLevelObjectiveValue = upgradeHintValue.get("targetServiceLevelObjective");
                                    if (targetServiceLevelObjectiveValue != null && targetServiceLevelObjectiveValue instanceof NullNode == false) {
                                        String targetServiceLevelObjectiveInstance;
                                        targetServiceLevelObjectiveInstance = targetServiceLevelObjectiveValue.getTextValue();
                                        upgradeHintInstance.setTargetServiceLevelObjective(targetServiceLevelObjectiveInstance);
                                    }
                                    
                                    JsonNode targetServiceLevelObjectiveIdValue = upgradeHintValue.get("targetServiceLevelObjectiveId");
                                    if (targetServiceLevelObjectiveIdValue != null && targetServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                        String targetServiceLevelObjectiveIdInstance;
                                        targetServiceLevelObjectiveIdInstance = targetServiceLevelObjectiveIdValue.getTextValue();
                                        upgradeHintInstance.setTargetServiceLevelObjectiveId(targetServiceLevelObjectiveIdInstance);
                                    }
                                    
                                    JsonNode idValue3 = upgradeHintValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        upgradeHintInstance.setId(idInstance3);
                                    }
                                    
                                    JsonNode nameValue3 = upgradeHintValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        upgradeHintInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode typeValue3 = upgradeHintValue.get("type");
                                    if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                        String typeInstance3;
                                        typeInstance3 = typeValue3.getTextValue();
                                        upgradeHintInstance.setType(typeInstance3);
                                    }
                                    
                                    JsonNode locationValue3 = upgradeHintValue.get("location");
                                    if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                        String locationInstance3;
                                        locationInstance3 = locationValue3.getTextValue();
                                        upgradeHintInstance.setLocation(locationInstance3);
                                    }
                                    
                                    JsonNode tagsSequenceElement3 = ((JsonNode) upgradeHintValue.get("tags"));
                                    if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                        while (itr3.hasNext()) {
                                            Map.Entry<String, JsonNode> property3 = itr3.next();
                                            String tagsKey3 = property3.getKey();
                                            String tagsValue3 = property3.getValue().getTextValue();
                                            upgradeHintInstance.getTags().put(tagsKey3, tagsValue3);
                                        }
                                    }
                                }
                                
                                JsonNode schemasArray = propertiesValue.get("schemas");
                                if (schemasArray != null && schemasArray instanceof NullNode == false) {
                                    for (JsonNode schemasValue : ((ArrayNode) schemasArray)) {
                                        Schema schemaInstance = new Schema();
                                        propertiesInstance.getSchemas().add(schemaInstance);
                                        
                                        JsonNode propertiesValue3 = schemasValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            SchemaProperties propertiesInstance3 = new SchemaProperties();
                                            schemaInstance.setProperties(propertiesInstance3);
                                            
                                            JsonNode tablesArray = propertiesValue3.get("tables");
                                            if (tablesArray != null && tablesArray instanceof NullNode == false) {
                                                for (JsonNode tablesValue : ((ArrayNode) tablesArray)) {
                                                    Table tableInstance = new Table();
                                                    propertiesInstance3.getTables().add(tableInstance);
                                                    
                                                    JsonNode propertiesValue4 = tablesValue.get("properties");
                                                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                                        TableProperties propertiesInstance4 = new TableProperties();
                                                        tableInstance.setProperties(propertiesInstance4);
                                                        
                                                        JsonNode tableTypeValue = propertiesValue4.get("tableType");
                                                        if (tableTypeValue != null && tableTypeValue instanceof NullNode == false) {
                                                            String tableTypeInstance;
                                                            tableTypeInstance = tableTypeValue.getTextValue();
                                                            propertiesInstance4.setTableType(tableTypeInstance);
                                                        }
                                                        
                                                        JsonNode columnsArray = propertiesValue4.get("columns");
                                                        if (columnsArray != null && columnsArray instanceof NullNode == false) {
                                                            for (JsonNode columnsValue : ((ArrayNode) columnsArray)) {
                                                                Column columnInstance = new Column();
                                                                propertiesInstance4.getColumns().add(columnInstance);
                                                                
                                                                JsonNode propertiesValue5 = columnsValue.get("properties");
                                                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                                                    ColumnProperties propertiesInstance5 = new ColumnProperties();
                                                                    columnInstance.setProperties(propertiesInstance5);
                                                                    
                                                                    JsonNode columnTypeValue = propertiesValue5.get("columnType");
                                                                    if (columnTypeValue != null && columnTypeValue instanceof NullNode == false) {
                                                                        String columnTypeInstance;
                                                                        columnTypeInstance = columnTypeValue.getTextValue();
                                                                        propertiesInstance5.setColumnType(columnTypeInstance);
                                                                    }
                                                                }
                                                                
                                                                JsonNode idValue4 = columnsValue.get("id");
                                                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                                    String idInstance4;
                                                                    idInstance4 = idValue4.getTextValue();
                                                                    columnInstance.setId(idInstance4);
                                                                }
                                                                
                                                                JsonNode nameValue4 = columnsValue.get("name");
                                                                if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                                    String nameInstance4;
                                                                    nameInstance4 = nameValue4.getTextValue();
                                                                    columnInstance.setName(nameInstance4);
                                                                }
                                                                
                                                                JsonNode typeValue4 = columnsValue.get("type");
                                                                if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                                    String typeInstance4;
                                                                    typeInstance4 = typeValue4.getTextValue();
                                                                    columnInstance.setType(typeInstance4);
                                                                }
                                                                
                                                                JsonNode locationValue4 = columnsValue.get("location");
                                                                if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                                                    String locationInstance4;
                                                                    locationInstance4 = locationValue4.getTextValue();
                                                                    columnInstance.setLocation(locationInstance4);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement4 = ((JsonNode) columnsValue.get("tags"));
                                                                if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                                                    while (itr4.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property4 = itr4.next();
                                                                        String tagsKey4 = property4.getKey();
                                                                        String tagsValue4 = property4.getValue().getTextValue();
                                                                        columnInstance.getTags().put(tagsKey4, tagsValue4);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        JsonNode recommendedIndexesArray = propertiesValue4.get("recommendedIndexes");
                                                        if (recommendedIndexesArray != null && recommendedIndexesArray instanceof NullNode == false) {
                                                            for (JsonNode recommendedIndexesValue : ((ArrayNode) recommendedIndexesArray)) {
                                                                RecommendedIndex recommendedIndexInstance = new RecommendedIndex();
                                                                propertiesInstance4.getRecommendedIndexes().add(recommendedIndexInstance);
                                                                
                                                                JsonNode propertiesValue6 = recommendedIndexesValue.get("properties");
                                                                if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                                                    RecommendedIndexProperties propertiesInstance6 = new RecommendedIndexProperties();
                                                                    recommendedIndexInstance.setProperties(propertiesInstance6);
                                                                    
                                                                    JsonNode actionValue = propertiesValue6.get("action");
                                                                    if (actionValue != null && actionValue instanceof NullNode == false) {
                                                                        String actionInstance;
                                                                        actionInstance = actionValue.getTextValue();
                                                                        propertiesInstance6.setAction(actionInstance);
                                                                    }
                                                                    
                                                                    JsonNode stateValue = propertiesValue6.get("state");
                                                                    if (stateValue != null && stateValue instanceof NullNode == false) {
                                                                        String stateInstance;
                                                                        stateInstance = stateValue.getTextValue();
                                                                        propertiesInstance6.setState(stateInstance);
                                                                    }
                                                                    
                                                                    JsonNode createdValue = propertiesValue6.get("created");
                                                                    if (createdValue != null && createdValue instanceof NullNode == false) {
                                                                        Calendar createdInstance;
                                                                        createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                                                        propertiesInstance6.setCreated(createdInstance);
                                                                    }
                                                                    
                                                                    JsonNode lastModifiedValue = propertiesValue6.get("lastModified");
                                                                    if (lastModifiedValue != null && lastModifiedValue instanceof NullNode == false) {
                                                                        Calendar lastModifiedInstance;
                                                                        lastModifiedInstance = DatatypeConverter.parseDateTime(lastModifiedValue.getTextValue());
                                                                        propertiesInstance6.setLastModified(lastModifiedInstance);
                                                                    }
                                                                    
                                                                    JsonNode indexTypeValue = propertiesValue6.get("indexType");
                                                                    if (indexTypeValue != null && indexTypeValue instanceof NullNode == false) {
                                                                        String indexTypeInstance;
                                                                        indexTypeInstance = indexTypeValue.getTextValue();
                                                                        propertiesInstance6.setIndexType(indexTypeInstance);
                                                                    }
                                                                    
                                                                    JsonNode schemaValue = propertiesValue6.get("schema");
                                                                    if (schemaValue != null && schemaValue instanceof NullNode == false) {
                                                                        String schemaInstance2;
                                                                        schemaInstance2 = schemaValue.getTextValue();
                                                                        propertiesInstance6.setSchema(schemaInstance2);
                                                                    }
                                                                    
                                                                    JsonNode tableValue = propertiesValue6.get("table");
                                                                    if (tableValue != null && tableValue instanceof NullNode == false) {
                                                                        String tableInstance2;
                                                                        tableInstance2 = tableValue.getTextValue();
                                                                        propertiesInstance6.setTable(tableInstance2);
                                                                    }
                                                                    
                                                                    JsonNode columnsArray2 = propertiesValue6.get("columns");
                                                                    if (columnsArray2 != null && columnsArray2 instanceof NullNode == false) {
                                                                        for (JsonNode columnsValue2 : ((ArrayNode) columnsArray2)) {
                                                                            propertiesInstance6.getColumns().add(columnsValue2.getTextValue());
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode includedColumnsArray = propertiesValue6.get("includedColumns");
                                                                    if (includedColumnsArray != null && includedColumnsArray instanceof NullNode == false) {
                                                                        for (JsonNode includedColumnsValue : ((ArrayNode) includedColumnsArray)) {
                                                                            propertiesInstance6.getIncludedColumns().add(includedColumnsValue.getTextValue());
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode indexScriptValue = propertiesValue6.get("indexScript");
                                                                    if (indexScriptValue != null && indexScriptValue instanceof NullNode == false) {
                                                                        String indexScriptInstance;
                                                                        indexScriptInstance = indexScriptValue.getTextValue();
                                                                        propertiesInstance6.setIndexScript(indexScriptInstance);
                                                                    }
                                                                    
                                                                    JsonNode estimatedImpactArray = propertiesValue6.get("estimatedImpact");
                                                                    if (estimatedImpactArray != null && estimatedImpactArray instanceof NullNode == false) {
                                                                        for (JsonNode estimatedImpactValue : ((ArrayNode) estimatedImpactArray)) {
                                                                            OperationImpact operationImpactInstance = new OperationImpact();
                                                                            propertiesInstance6.getEstimatedImpact().add(operationImpactInstance);
                                                                            
                                                                            JsonNode nameValue5 = estimatedImpactValue.get("name");
                                                                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                                                String nameInstance5;
                                                                                nameInstance5 = nameValue5.getTextValue();
                                                                                operationImpactInstance.setName(nameInstance5);
                                                                            }
                                                                            
                                                                            JsonNode unitValue = estimatedImpactValue.get("unit");
                                                                            if (unitValue != null && unitValue instanceof NullNode == false) {
                                                                                String unitInstance;
                                                                                unitInstance = unitValue.getTextValue();
                                                                                operationImpactInstance.setUnit(unitInstance);
                                                                            }
                                                                            
                                                                            JsonNode changeValueAbsoluteValue = estimatedImpactValue.get("changeValueAbsolute");
                                                                            if (changeValueAbsoluteValue != null && changeValueAbsoluteValue instanceof NullNode == false) {
                                                                                double changeValueAbsoluteInstance;
                                                                                changeValueAbsoluteInstance = changeValueAbsoluteValue.getDoubleValue();
                                                                                operationImpactInstance.setChangeValueAbsolute(changeValueAbsoluteInstance);
                                                                            }
                                                                            
                                                                            JsonNode changeValueRelativeValue = estimatedImpactValue.get("changeValueRelative");
                                                                            if (changeValueRelativeValue != null && changeValueRelativeValue instanceof NullNode == false) {
                                                                                double changeValueRelativeInstance;
                                                                                changeValueRelativeInstance = changeValueRelativeValue.getDoubleValue();
                                                                                operationImpactInstance.setChangeValueRelative(changeValueRelativeInstance);
                                                                            }
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode reportedImpactArray = propertiesValue6.get("reportedImpact");
                                                                    if (reportedImpactArray != null && reportedImpactArray instanceof NullNode == false) {
                                                                        for (JsonNode reportedImpactValue : ((ArrayNode) reportedImpactArray)) {
                                                                            OperationImpact operationImpactInstance2 = new OperationImpact();
                                                                            propertiesInstance6.getReportedImpact().add(operationImpactInstance2);
                                                                            
                                                                            JsonNode nameValue6 = reportedImpactValue.get("name");
                                                                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                                                String nameInstance6;
                                                                                nameInstance6 = nameValue6.getTextValue();
                                                                                operationImpactInstance2.setName(nameInstance6);
                                                                            }
                                                                            
                                                                            JsonNode unitValue2 = reportedImpactValue.get("unit");
                                                                            if (unitValue2 != null && unitValue2 instanceof NullNode == false) {
                                                                                String unitInstance2;
                                                                                unitInstance2 = unitValue2.getTextValue();
                                                                                operationImpactInstance2.setUnit(unitInstance2);
                                                                            }
                                                                            
                                                                            JsonNode changeValueAbsoluteValue2 = reportedImpactValue.get("changeValueAbsolute");
                                                                            if (changeValueAbsoluteValue2 != null && changeValueAbsoluteValue2 instanceof NullNode == false) {
                                                                                double changeValueAbsoluteInstance2;
                                                                                changeValueAbsoluteInstance2 = changeValueAbsoluteValue2.getDoubleValue();
                                                                                operationImpactInstance2.setChangeValueAbsolute(changeValueAbsoluteInstance2);
                                                                            }
                                                                            
                                                                            JsonNode changeValueRelativeValue2 = reportedImpactValue.get("changeValueRelative");
                                                                            if (changeValueRelativeValue2 != null && changeValueRelativeValue2 instanceof NullNode == false) {
                                                                                double changeValueRelativeInstance2;
                                                                                changeValueRelativeInstance2 = changeValueRelativeValue2.getDoubleValue();
                                                                                operationImpactInstance2.setChangeValueRelative(changeValueRelativeInstance2);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                
                                                                JsonNode idValue5 = recommendedIndexesValue.get("id");
                                                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                                    String idInstance5;
                                                                    idInstance5 = idValue5.getTextValue();
                                                                    recommendedIndexInstance.setId(idInstance5);
                                                                }
                                                                
                                                                JsonNode nameValue7 = recommendedIndexesValue.get("name");
                                                                if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                                                    String nameInstance7;
                                                                    nameInstance7 = nameValue7.getTextValue();
                                                                    recommendedIndexInstance.setName(nameInstance7);
                                                                }
                                                                
                                                                JsonNode typeValue5 = recommendedIndexesValue.get("type");
                                                                if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                                    String typeInstance5;
                                                                    typeInstance5 = typeValue5.getTextValue();
                                                                    recommendedIndexInstance.setType(typeInstance5);
                                                                }
                                                                
                                                                JsonNode locationValue5 = recommendedIndexesValue.get("location");
                                                                if (locationValue5 != null && locationValue5 instanceof NullNode == false) {
                                                                    String locationInstance5;
                                                                    locationInstance5 = locationValue5.getTextValue();
                                                                    recommendedIndexInstance.setLocation(locationInstance5);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement5 = ((JsonNode) recommendedIndexesValue.get("tags"));
                                                                if (tagsSequenceElement5 != null && tagsSequenceElement5 instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr5 = tagsSequenceElement5.getFields();
                                                                    while (itr5.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property5 = itr5.next();
                                                                        String tagsKey5 = property5.getKey();
                                                                        String tagsValue5 = property5.getValue().getTextValue();
                                                                        recommendedIndexInstance.getTags().put(tagsKey5, tagsValue5);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    
                                                    JsonNode idValue6 = tablesValue.get("id");
                                                    if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                        String idInstance6;
                                                        idInstance6 = idValue6.getTextValue();
                                                        tableInstance.setId(idInstance6);
                                                    }
                                                    
                                                    JsonNode nameValue8 = tablesValue.get("name");
                                                    if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                                        String nameInstance8;
                                                        nameInstance8 = nameValue8.getTextValue();
                                                        tableInstance.setName(nameInstance8);
                                                    }
                                                    
                                                    JsonNode typeValue6 = tablesValue.get("type");
                                                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                        String typeInstance6;
                                                        typeInstance6 = typeValue6.getTextValue();
                                                        tableInstance.setType(typeInstance6);
                                                    }
                                                    
                                                    JsonNode locationValue6 = tablesValue.get("location");
                                                    if (locationValue6 != null && locationValue6 instanceof NullNode == false) {
                                                        String locationInstance6;
                                                        locationInstance6 = locationValue6.getTextValue();
                                                        tableInstance.setLocation(locationInstance6);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement6 = ((JsonNode) tablesValue.get("tags"));
                                                    if (tagsSequenceElement6 != null && tagsSequenceElement6 instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement6.getFields();
                                                        while (itr6.hasNext()) {
                                                            Map.Entry<String, JsonNode> property6 = itr6.next();
                                                            String tagsKey6 = property6.getKey();
                                                            String tagsValue6 = property6.getValue().getTextValue();
                                                            tableInstance.getTags().put(tagsKey6, tagsValue6);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        
                                        JsonNode idValue7 = schemasValue.get("id");
                                        if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                            String idInstance7;
                                            idInstance7 = idValue7.getTextValue();
                                            schemaInstance.setId(idInstance7);
                                        }
                                        
                                        JsonNode nameValue9 = schemasValue.get("name");
                                        if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                            String nameInstance9;
                                            nameInstance9 = nameValue9.getTextValue();
                                            schemaInstance.setName(nameInstance9);
                                        }
                                        
                                        JsonNode typeValue7 = schemasValue.get("type");
                                        if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                            String typeInstance7;
                                            typeInstance7 = typeValue7.getTextValue();
                                            schemaInstance.setType(typeInstance7);
                                        }
                                        
                                        JsonNode locationValue7 = schemasValue.get("location");
                                        if (locationValue7 != null && locationValue7 instanceof NullNode == false) {
                                            String locationInstance7;
                                            locationInstance7 = locationValue7.getTextValue();
                                            schemaInstance.setLocation(locationInstance7);
                                        }
                                        
                                        JsonNode tagsSequenceElement7 = ((JsonNode) schemasValue.get("tags"));
                                        if (tagsSequenceElement7 != null && tagsSequenceElement7 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr7 = tagsSequenceElement7.getFields();
                                            while (itr7.hasNext()) {
                                                Map.Entry<String, JsonNode> property7 = itr7.next();
                                                String tagsKey7 = property7.getKey();
                                                String tagsValue7 = property7.getValue().getTextValue();
                                                schemaInstance.getTags().put(tagsKey7, tagsValue7);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode defaultSecondaryLocationValue = propertiesValue.get("defaultSecondaryLocation");
                                if (defaultSecondaryLocationValue != null && defaultSecondaryLocationValue instanceof NullNode == false) {
                                    String defaultSecondaryLocationInstance;
                                    defaultSecondaryLocationInstance = defaultSecondaryLocationValue.getTextValue();
                                    propertiesInstance.setDefaultSecondaryLocation(defaultSecondaryLocationInstance);
                                }
                            }
                            
                            JsonNode idValue8 = valueValue.get("id");
                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                String idInstance8;
                                idInstance8 = idValue8.getTextValue();
                                databaseInstance.setId(idInstance8);
                            }
                            
                            JsonNode nameValue10 = valueValue.get("name");
                            if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                String nameInstance10;
                                nameInstance10 = nameValue10.getTextValue();
                                databaseInstance.setName(nameInstance10);
                            }
                            
                            JsonNode typeValue8 = valueValue.get("type");
                            if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                String typeInstance8;
                                typeInstance8 = typeValue8.getTextValue();
                                databaseInstance.setType(typeInstance8);
                            }
                            
                            JsonNode locationValue8 = valueValue.get("location");
                            if (locationValue8 != null && locationValue8 instanceof NullNode == false) {
                                String locationInstance8;
                                locationInstance8 = locationValue8.getTextValue();
                                databaseInstance.setLocation(locationInstance8);
                            }
                            
                            JsonNode tagsSequenceElement8 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement8 != null && tagsSequenceElement8 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr8 = tagsSequenceElement8.getFields();
                                while (itr8.hasNext()) {
                                    Map.Entry<String, JsonNode> property8 = itr8.next();
                                    String tagsKey8 = property8.getKey();
                                    String tagsValue8 = property8.getValue().getTextValue();
                                    databaseInstance.getTags().put(tagsKey8, tagsValue8);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @param expand Required. The comma separated list of child objects that we
    * want to expand on in response.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    @Override
    public Future<RecommendedElasticPoolListResponse> listExpandedAsync(final String resourceGroupName, final String serverName, final String expand) {
        return this.getClient().getExecutorService().submit(new Callable<RecommendedElasticPoolListResponse>() { 
            @Override
            public RecommendedElasticPoolListResponse call() throws Exception {
                return listExpanded(resourceGroupName, serverName, expand);
            }
         });
    }
    
    /**
    * Returns information about Azure SQL Recommended Elastic Pools.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Recommended Serve belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which Azure SQL Recommended Elastic Pools are hosted.
    * @param expand Required. The comma separated list of child objects that we
    * want to expand on in response.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool request.
    */
    @Override
    public RecommendedElasticPoolListResponse listExpanded(String resourceGroupName, String serverName, String expand) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (expand == null) {
            throw new NullPointerException("expand");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("expand", expand);
            CloudTracing.enter(invocationId, this, "listExpandedAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        queryParameters.add("$expand=" + URLEncoder.encode(expand, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            RecommendedElasticPoolListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecommendedElasticPoolListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            RecommendedElasticPool recommendedElasticPoolInstance = new RecommendedElasticPool();
                            result.getRecommendedElasticPools().add(recommendedElasticPoolInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                RecommendedElasticPoolProperties propertiesInstance = new RecommendedElasticPoolProperties();
                                recommendedElasticPoolInstance.setProperties(propertiesInstance);
                                
                                JsonNode databaseEditionValue = propertiesValue.get("databaseEdition");
                                if (databaseEditionValue != null && databaseEditionValue instanceof NullNode == false) {
                                    String databaseEditionInstance;
                                    databaseEditionInstance = databaseEditionValue.getTextValue();
                                    propertiesInstance.setDatabaseEdition(databaseEditionInstance);
                                }
                                
                                JsonNode dtuValue = propertiesValue.get("dtu");
                                if (dtuValue != null && dtuValue instanceof NullNode == false) {
                                    double dtuInstance;
                                    dtuInstance = dtuValue.getDoubleValue();
                                    propertiesInstance.setDtu(dtuInstance);
                                }
                                
                                JsonNode databaseDtuMinValue = propertiesValue.get("databaseDtuMin");
                                if (databaseDtuMinValue != null && databaseDtuMinValue instanceof NullNode == false) {
                                    double databaseDtuMinInstance;
                                    databaseDtuMinInstance = databaseDtuMinValue.getDoubleValue();
                                    propertiesInstance.setDatabaseDtuMin(databaseDtuMinInstance);
                                }
                                
                                JsonNode databaseDtuMaxValue = propertiesValue.get("databaseDtuMax");
                                if (databaseDtuMaxValue != null && databaseDtuMaxValue instanceof NullNode == false) {
                                    double databaseDtuMaxInstance;
                                    databaseDtuMaxInstance = databaseDtuMaxValue.getDoubleValue();
                                    propertiesInstance.setDatabaseDtuMax(databaseDtuMaxInstance);
                                }
                                
                                JsonNode storageMBValue = propertiesValue.get("storageMB");
                                if (storageMBValue != null && storageMBValue instanceof NullNode == false) {
                                    double storageMBInstance;
                                    storageMBInstance = storageMBValue.getDoubleValue();
                                    propertiesInstance.setStorageMB(storageMBInstance);
                                }
                                
                                JsonNode observationPeriodStartValue = propertiesValue.get("observationPeriodStart");
                                if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                                    Calendar observationPeriodStartInstance;
                                    observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                                    propertiesInstance.setObservationPeriodStart(observationPeriodStartInstance);
                                }
                                
                                JsonNode observationPeriodEndValue = propertiesValue.get("observationPeriodEnd");
                                if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                                    Calendar observationPeriodEndInstance;
                                    observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                                    propertiesInstance.setObservationPeriodEnd(observationPeriodEndInstance);
                                }
                                
                                JsonNode maxObservedDtuValue = propertiesValue.get("maxObservedDtu");
                                if (maxObservedDtuValue != null && maxObservedDtuValue instanceof NullNode == false) {
                                    double maxObservedDtuInstance;
                                    maxObservedDtuInstance = maxObservedDtuValue.getDoubleValue();
                                    propertiesInstance.setMaxObservedDtu(maxObservedDtuInstance);
                                }
                                
                                JsonNode maxObservedStorageMBValue = propertiesValue.get("maxObservedStorageMB");
                                if (maxObservedStorageMBValue != null && maxObservedStorageMBValue instanceof NullNode == false) {
                                    double maxObservedStorageMBInstance;
                                    maxObservedStorageMBInstance = maxObservedStorageMBValue.getDoubleValue();
                                    propertiesInstance.setMaxObservedStorageMB(maxObservedStorageMBInstance);
                                }
                                
                                JsonNode databasesArray = propertiesValue.get("databases");
                                if (databasesArray != null && databasesArray instanceof NullNode == false) {
                                    for (JsonNode databasesValue : ((ArrayNode) databasesArray)) {
                                        Database databaseInstance = new Database();
                                        propertiesInstance.getDatabases().add(databaseInstance);
                                        
                                        JsonNode propertiesValue2 = databasesValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            DatabaseProperties propertiesInstance2 = new DatabaseProperties();
                                            databaseInstance.setProperties(propertiesInstance2);
                                            
                                            JsonNode collationValue = propertiesValue2.get("collation");
                                            if (collationValue != null && collationValue instanceof NullNode == false) {
                                                String collationInstance;
                                                collationInstance = collationValue.getTextValue();
                                                propertiesInstance2.setCollation(collationInstance);
                                            }
                                            
                                            JsonNode creationDateValue = propertiesValue2.get("creationDate");
                                            if (creationDateValue != null && creationDateValue instanceof NullNode == false) {
                                                Calendar creationDateInstance;
                                                creationDateInstance = DatatypeConverter.parseDateTime(creationDateValue.getTextValue());
                                                propertiesInstance2.setCreationDate(creationDateInstance);
                                            }
                                            
                                            JsonNode currentServiceObjectiveIdValue = propertiesValue2.get("currentServiceObjectiveId");
                                            if (currentServiceObjectiveIdValue != null && currentServiceObjectiveIdValue instanceof NullNode == false) {
                                                String currentServiceObjectiveIdInstance;
                                                currentServiceObjectiveIdInstance = currentServiceObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setCurrentServiceObjectiveId(currentServiceObjectiveIdInstance);
                                            }
                                            
                                            JsonNode databaseIdValue = propertiesValue2.get("databaseId");
                                            if (databaseIdValue != null && databaseIdValue instanceof NullNode == false) {
                                                String databaseIdInstance;
                                                databaseIdInstance = databaseIdValue.getTextValue();
                                                propertiesInstance2.setDatabaseId(databaseIdInstance);
                                            }
                                            
                                            JsonNode earliestRestoreDateValue = propertiesValue2.get("earliestRestoreDate");
                                            if (earliestRestoreDateValue != null && earliestRestoreDateValue instanceof NullNode == false) {
                                                Calendar earliestRestoreDateInstance;
                                                earliestRestoreDateInstance = DatatypeConverter.parseDateTime(earliestRestoreDateValue.getTextValue());
                                                propertiesInstance2.setEarliestRestoreDate(earliestRestoreDateInstance);
                                            }
                                            
                                            JsonNode editionValue = propertiesValue2.get("edition");
                                            if (editionValue != null && editionValue instanceof NullNode == false) {
                                                String editionInstance;
                                                editionInstance = editionValue.getTextValue();
                                                propertiesInstance2.setEdition(editionInstance);
                                            }
                                            
                                            JsonNode maxSizeBytesValue = propertiesValue2.get("maxSizeBytes");
                                            if (maxSizeBytesValue != null && maxSizeBytesValue instanceof NullNode == false) {
                                                long maxSizeBytesInstance;
                                                maxSizeBytesInstance = maxSizeBytesValue.getLongValue();
                                                propertiesInstance2.setMaxSizeBytes(maxSizeBytesInstance);
                                            }
                                            
                                            JsonNode requestedServiceObjectiveIdValue = propertiesValue2.get("requestedServiceObjectiveId");
                                            if (requestedServiceObjectiveIdValue != null && requestedServiceObjectiveIdValue instanceof NullNode == false) {
                                                String requestedServiceObjectiveIdInstance;
                                                requestedServiceObjectiveIdInstance = requestedServiceObjectiveIdValue.getTextValue();
                                                propertiesInstance2.setRequestedServiceObjectiveId(requestedServiceObjectiveIdInstance);
                                            }
                                            
                                            JsonNode requestedServiceObjectiveNameValue = propertiesValue2.get("requestedServiceObjectiveName");
                                            if (requestedServiceObjectiveNameValue != null && requestedServiceObjectiveNameValue instanceof NullNode == false) {
                                                String requestedServiceObjectiveNameInstance;
                                                requestedServiceObjectiveNameInstance = requestedServiceObjectiveNameValue.getTextValue();
                                                propertiesInstance2.setRequestedServiceObjectiveName(requestedServiceObjectiveNameInstance);
                                            }
                                            
                                            JsonNode serviceLevelObjectiveValue = propertiesValue2.get("serviceLevelObjective");
                                            if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                                String serviceLevelObjectiveInstance;
                                                serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                                propertiesInstance2.setServiceObjective(serviceLevelObjectiveInstance);
                                            }
                                            
                                            JsonNode statusValue = propertiesValue2.get("status");
                                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                                String statusInstance;
                                                statusInstance = statusValue.getTextValue();
                                                propertiesInstance2.setStatus(statusInstance);
                                            }
                                            
                                            JsonNode elasticPoolNameValue = propertiesValue2.get("elasticPoolName");
                                            if (elasticPoolNameValue != null && elasticPoolNameValue instanceof NullNode == false) {
                                                String elasticPoolNameInstance;
                                                elasticPoolNameInstance = elasticPoolNameValue.getTextValue();
                                                propertiesInstance2.setElasticPoolName(elasticPoolNameInstance);
                                            }
                                            
                                            JsonNode serviceTierAdvisorsArray = propertiesValue2.get("serviceTierAdvisors");
                                            if (serviceTierAdvisorsArray != null && serviceTierAdvisorsArray instanceof NullNode == false) {
                                                for (JsonNode serviceTierAdvisorsValue : ((ArrayNode) serviceTierAdvisorsArray)) {
                                                    ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                                                    propertiesInstance2.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                                                    
                                                    JsonNode propertiesValue3 = serviceTierAdvisorsValue.get("properties");
                                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                                        ServiceTierAdvisorProperties propertiesInstance3 = new ServiceTierAdvisorProperties();
                                                        serviceTierAdvisorInstance.setProperties(propertiesInstance3);
                                                        
                                                        JsonNode observationPeriodStartValue2 = propertiesValue3.get("observationPeriodStart");
                                                        if (observationPeriodStartValue2 != null && observationPeriodStartValue2 instanceof NullNode == false) {
                                                            Calendar observationPeriodStartInstance2;
                                                            observationPeriodStartInstance2 = DatatypeConverter.parseDateTime(observationPeriodStartValue2.getTextValue());
                                                            propertiesInstance3.setObservationPeriodStart(observationPeriodStartInstance2);
                                                        }
                                                        
                                                        JsonNode observationPeriodEndValue2 = propertiesValue3.get("observationPeriodEnd");
                                                        if (observationPeriodEndValue2 != null && observationPeriodEndValue2 instanceof NullNode == false) {
                                                            Calendar observationPeriodEndInstance2;
                                                            observationPeriodEndInstance2 = DatatypeConverter.parseDateTime(observationPeriodEndValue2.getTextValue());
                                                            propertiesInstance3.setObservationPeriodEnd(observationPeriodEndInstance2);
                                                        }
                                                        
                                                        JsonNode activeTimeRatioValue = propertiesValue3.get("activeTimeRatio");
                                                        if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                                            double activeTimeRatioInstance;
                                                            activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                                            propertiesInstance3.setActiveTimeRatio(activeTimeRatioInstance);
                                                        }
                                                        
                                                        JsonNode minDtuValue = propertiesValue3.get("minDtu");
                                                        if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                                            double minDtuInstance;
                                                            minDtuInstance = minDtuValue.getDoubleValue();
                                                            propertiesInstance3.setMinDtu(minDtuInstance);
                                                        }
                                                        
                                                        JsonNode avgDtuValue = propertiesValue3.get("avgDtu");
                                                        if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                                            double avgDtuInstance;
                                                            avgDtuInstance = avgDtuValue.getDoubleValue();
                                                            propertiesInstance3.setAvgDtu(avgDtuInstance);
                                                        }
                                                        
                                                        JsonNode maxDtuValue = propertiesValue3.get("maxDtu");
                                                        if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                                            double maxDtuInstance;
                                                            maxDtuInstance = maxDtuValue.getDoubleValue();
                                                            propertiesInstance3.setMaxDtu(maxDtuInstance);
                                                        }
                                                        
                                                        JsonNode maxSizeInGBValue = propertiesValue3.get("maxSizeInGB");
                                                        if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                                            double maxSizeInGBInstance;
                                                            maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                                            propertiesInstance3.setMaxSizeInGB(maxSizeInGBInstance);
                                                        }
                                                        
                                                        JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue3.get("serviceLevelObjectiveUsageMetrics");
                                                        if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                                            for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                                                SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                                                propertiesInstance3.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                                                
                                                                JsonNode serviceLevelObjectiveValue2 = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                                                if (serviceLevelObjectiveValue2 != null && serviceLevelObjectiveValue2 instanceof NullNode == false) {
                                                                    String serviceLevelObjectiveInstance2;
                                                                    serviceLevelObjectiveInstance2 = serviceLevelObjectiveValue2.getTextValue();
                                                                    sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance2);
                                                                }
                                                                
                                                                JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                                                if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                                                    String serviceLevelObjectiveIdInstance;
                                                                    serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                                                    sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                                                }
                                                                
                                                                JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                                                if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                                                    double inRangeTimeRatioInstance;
                                                                    inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                                                    sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                                                }
                                                                
                                                                JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                                    String idInstance;
                                                                    idInstance = idValue.getTextValue();
                                                                    sloUsageMetricInstance.setId(idInstance);
                                                                }
                                                                
                                                                JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                                                    String nameInstance;
                                                                    nameInstance = nameValue.getTextValue();
                                                                    sloUsageMetricInstance.setName(nameInstance);
                                                                }
                                                                
                                                                JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                                                    String typeInstance;
                                                                    typeInstance = typeValue.getTextValue();
                                                                    sloUsageMetricInstance.setType(typeInstance);
                                                                }
                                                                
                                                                JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                                                if (locationValue != null && locationValue instanceof NullNode == false) {
                                                                    String locationInstance;
                                                                    locationInstance = locationValue.getTextValue();
                                                                    sloUsageMetricInstance.setLocation(locationInstance);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                                                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                                                    while (itr.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property = itr.next();
                                                                        String tagsKey = property.getKey();
                                                                        String tagsValue = property.getValue().getTextValue();
                                                                        sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        
                                                        JsonNode currentServiceLevelObjectiveValue = propertiesValue3.get("currentServiceLevelObjective");
                                                        if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String currentServiceLevelObjectiveInstance;
                                                            currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode currentServiceLevelObjectiveIdValue = propertiesValue3.get("currentServiceLevelObjectiveId");
                                                        if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String currentServiceLevelObjectiveIdInstance;
                                                            currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjective");
                                                        if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String usageBasedRecommendationServiceLevelObjectiveInstance;
                                                            usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("usageBasedRecommendationServiceLevelObjectiveId");
                                                        if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                                        if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                                            databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                                        if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                                        if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                                            disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                                        if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                                            disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue3.get("overallRecommendationServiceLevelObjective");
                                                        if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                                            String overallRecommendationServiceLevelObjectiveInstance;
                                                            overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                                            propertiesInstance3.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                                        }
                                                        
                                                        JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue3.get("overallRecommendationServiceLevelObjectiveId");
                                                        if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                            String overallRecommendationServiceLevelObjectiveIdInstance;
                                                            overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                                            propertiesInstance3.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                                        }
                                                        
                                                        JsonNode confidenceValue = propertiesValue3.get("confidence");
                                                        if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                                            double confidenceInstance;
                                                            confidenceInstance = confidenceValue.getDoubleValue();
                                                            propertiesInstance3.setConfidence(confidenceInstance);
                                                        }
                                                    }
                                                    
                                                    JsonNode idValue2 = serviceTierAdvisorsValue.get("id");
                                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                        String idInstance2;
                                                        idInstance2 = idValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setId(idInstance2);
                                                    }
                                                    
                                                    JsonNode nameValue2 = serviceTierAdvisorsValue.get("name");
                                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                                        String nameInstance2;
                                                        nameInstance2 = nameValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setName(nameInstance2);
                                                    }
                                                    
                                                    JsonNode typeValue2 = serviceTierAdvisorsValue.get("type");
                                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                        String typeInstance2;
                                                        typeInstance2 = typeValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setType(typeInstance2);
                                                    }
                                                    
                                                    JsonNode locationValue2 = serviceTierAdvisorsValue.get("location");
                                                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                                        String locationInstance2;
                                                        locationInstance2 = locationValue2.getTextValue();
                                                        serviceTierAdvisorInstance.setLocation(locationInstance2);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement2 = ((JsonNode) serviceTierAdvisorsValue.get("tags"));
                                                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                                        while (itr2.hasNext()) {
                                                            Map.Entry<String, JsonNode> property2 = itr2.next();
                                                            String tagsKey2 = property2.getKey();
                                                            String tagsValue2 = property2.getValue().getTextValue();
                                                            serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode upgradeHintValue = propertiesValue2.get("upgradeHint");
                                            if (upgradeHintValue != null && upgradeHintValue instanceof NullNode == false) {
                                                UpgradeHint upgradeHintInstance = new UpgradeHint();
                                                propertiesInstance2.setUpgradeHint(upgradeHintInstance);
                                                
                                                JsonNode targetServiceLevelObjectiveValue = upgradeHintValue.get("targetServiceLevelObjective");
                                                if (targetServiceLevelObjectiveValue != null && targetServiceLevelObjectiveValue instanceof NullNode == false) {
                                                    String targetServiceLevelObjectiveInstance;
                                                    targetServiceLevelObjectiveInstance = targetServiceLevelObjectiveValue.getTextValue();
                                                    upgradeHintInstance.setTargetServiceLevelObjective(targetServiceLevelObjectiveInstance);
                                                }
                                                
                                                JsonNode targetServiceLevelObjectiveIdValue = upgradeHintValue.get("targetServiceLevelObjectiveId");
                                                if (targetServiceLevelObjectiveIdValue != null && targetServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                                    String targetServiceLevelObjectiveIdInstance;
                                                    targetServiceLevelObjectiveIdInstance = targetServiceLevelObjectiveIdValue.getTextValue();
                                                    upgradeHintInstance.setTargetServiceLevelObjectiveId(targetServiceLevelObjectiveIdInstance);
                                                }
                                                
                                                JsonNode idValue3 = upgradeHintValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    upgradeHintInstance.setId(idInstance3);
                                                }
                                                
                                                JsonNode nameValue3 = upgradeHintValue.get("name");
                                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                    String nameInstance3;
                                                    nameInstance3 = nameValue3.getTextValue();
                                                    upgradeHintInstance.setName(nameInstance3);
                                                }
                                                
                                                JsonNode typeValue3 = upgradeHintValue.get("type");
                                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                                    String typeInstance3;
                                                    typeInstance3 = typeValue3.getTextValue();
                                                    upgradeHintInstance.setType(typeInstance3);
                                                }
                                                
                                                JsonNode locationValue3 = upgradeHintValue.get("location");
                                                if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                                    String locationInstance3;
                                                    locationInstance3 = locationValue3.getTextValue();
                                                    upgradeHintInstance.setLocation(locationInstance3);
                                                }
                                                
                                                JsonNode tagsSequenceElement3 = ((JsonNode) upgradeHintValue.get("tags"));
                                                if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                                    Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                                    while (itr3.hasNext()) {
                                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                                        String tagsKey3 = property3.getKey();
                                                        String tagsValue3 = property3.getValue().getTextValue();
                                                        upgradeHintInstance.getTags().put(tagsKey3, tagsValue3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode schemasArray = propertiesValue2.get("schemas");
                                            if (schemasArray != null && schemasArray instanceof NullNode == false) {
                                                for (JsonNode schemasValue : ((ArrayNode) schemasArray)) {
                                                    Schema schemaInstance = new Schema();
                                                    propertiesInstance2.getSchemas().add(schemaInstance);
                                                    
                                                    JsonNode propertiesValue4 = schemasValue.get("properties");
                                                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                                        SchemaProperties propertiesInstance4 = new SchemaProperties();
                                                        schemaInstance.setProperties(propertiesInstance4);
                                                        
                                                        JsonNode tablesArray = propertiesValue4.get("tables");
                                                        if (tablesArray != null && tablesArray instanceof NullNode == false) {
                                                            for (JsonNode tablesValue : ((ArrayNode) tablesArray)) {
                                                                Table tableInstance = new Table();
                                                                propertiesInstance4.getTables().add(tableInstance);
                                                                
                                                                JsonNode propertiesValue5 = tablesValue.get("properties");
                                                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                                                    TableProperties propertiesInstance5 = new TableProperties();
                                                                    tableInstance.setProperties(propertiesInstance5);
                                                                    
                                                                    JsonNode tableTypeValue = propertiesValue5.get("tableType");
                                                                    if (tableTypeValue != null && tableTypeValue instanceof NullNode == false) {
                                                                        String tableTypeInstance;
                                                                        tableTypeInstance = tableTypeValue.getTextValue();
                                                                        propertiesInstance5.setTableType(tableTypeInstance);
                                                                    }
                                                                    
                                                                    JsonNode columnsArray = propertiesValue5.get("columns");
                                                                    if (columnsArray != null && columnsArray instanceof NullNode == false) {
                                                                        for (JsonNode columnsValue : ((ArrayNode) columnsArray)) {
                                                                            Column columnInstance = new Column();
                                                                            propertiesInstance5.getColumns().add(columnInstance);
                                                                            
                                                                            JsonNode propertiesValue6 = columnsValue.get("properties");
                                                                            if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                                                                ColumnProperties propertiesInstance6 = new ColumnProperties();
                                                                                columnInstance.setProperties(propertiesInstance6);
                                                                                
                                                                                JsonNode columnTypeValue = propertiesValue6.get("columnType");
                                                                                if (columnTypeValue != null && columnTypeValue instanceof NullNode == false) {
                                                                                    String columnTypeInstance;
                                                                                    columnTypeInstance = columnTypeValue.getTextValue();
                                                                                    propertiesInstance6.setColumnType(columnTypeInstance);
                                                                                }
                                                                            }
                                                                            
                                                                            JsonNode idValue4 = columnsValue.get("id");
                                                                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                                                String idInstance4;
                                                                                idInstance4 = idValue4.getTextValue();
                                                                                columnInstance.setId(idInstance4);
                                                                            }
                                                                            
                                                                            JsonNode nameValue4 = columnsValue.get("name");
                                                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                                                String nameInstance4;
                                                                                nameInstance4 = nameValue4.getTextValue();
                                                                                columnInstance.setName(nameInstance4);
                                                                            }
                                                                            
                                                                            JsonNode typeValue4 = columnsValue.get("type");
                                                                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                                                String typeInstance4;
                                                                                typeInstance4 = typeValue4.getTextValue();
                                                                                columnInstance.setType(typeInstance4);
                                                                            }
                                                                            
                                                                            JsonNode locationValue4 = columnsValue.get("location");
                                                                            if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                                                                String locationInstance4;
                                                                                locationInstance4 = locationValue4.getTextValue();
                                                                                columnInstance.setLocation(locationInstance4);
                                                                            }
                                                                            
                                                                            JsonNode tagsSequenceElement4 = ((JsonNode) columnsValue.get("tags"));
                                                                            if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                                                                Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                                                                while (itr4.hasNext()) {
                                                                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                                                                    String tagsKey4 = property4.getKey();
                                                                                    String tagsValue4 = property4.getValue().getTextValue();
                                                                                    columnInstance.getTags().put(tagsKey4, tagsValue4);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    
                                                                    JsonNode recommendedIndexesArray = propertiesValue5.get("recommendedIndexes");
                                                                    if (recommendedIndexesArray != null && recommendedIndexesArray instanceof NullNode == false) {
                                                                        for (JsonNode recommendedIndexesValue : ((ArrayNode) recommendedIndexesArray)) {
                                                                            RecommendedIndex recommendedIndexInstance = new RecommendedIndex();
                                                                            propertiesInstance5.getRecommendedIndexes().add(recommendedIndexInstance);
                                                                            
                                                                            JsonNode propertiesValue7 = recommendedIndexesValue.get("properties");
                                                                            if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                                                                RecommendedIndexProperties propertiesInstance7 = new RecommendedIndexProperties();
                                                                                recommendedIndexInstance.setProperties(propertiesInstance7);
                                                                                
                                                                                JsonNode actionValue = propertiesValue7.get("action");
                                                                                if (actionValue != null && actionValue instanceof NullNode == false) {
                                                                                    String actionInstance;
                                                                                    actionInstance = actionValue.getTextValue();
                                                                                    propertiesInstance7.setAction(actionInstance);
                                                                                }
                                                                                
                                                                                JsonNode stateValue = propertiesValue7.get("state");
                                                                                if (stateValue != null && stateValue instanceof NullNode == false) {
                                                                                    String stateInstance;
                                                                                    stateInstance = stateValue.getTextValue();
                                                                                    propertiesInstance7.setState(stateInstance);
                                                                                }
                                                                                
                                                                                JsonNode createdValue = propertiesValue7.get("created");
                                                                                if (createdValue != null && createdValue instanceof NullNode == false) {
                                                                                    Calendar createdInstance;
                                                                                    createdInstance = DatatypeConverter.parseDateTime(createdValue.getTextValue());
                                                                                    propertiesInstance7.setCreated(createdInstance);
                                                                                }
                                                                                
                                                                                JsonNode lastModifiedValue = propertiesValue7.get("lastModified");
                                                                                if (lastModifiedValue != null && lastModifiedValue instanceof NullNode == false) {
                                                                                    Calendar lastModifiedInstance;
                                                                                    lastModifiedInstance = DatatypeConverter.parseDateTime(lastModifiedValue.getTextValue());
                                                                                    propertiesInstance7.setLastModified(lastModifiedInstance);
                                                                                }
                                                                                
                                                                                JsonNode indexTypeValue = propertiesValue7.get("indexType");
                                                                                if (indexTypeValue != null && indexTypeValue instanceof NullNode == false) {
                                                                                    String indexTypeInstance;
                                                                                    indexTypeInstance = indexTypeValue.getTextValue();
                                                                                    propertiesInstance7.setIndexType(indexTypeInstance);
                                                                                }
                                                                                
                                                                                JsonNode schemaValue = propertiesValue7.get("schema");
                                                                                if (schemaValue != null && schemaValue instanceof NullNode == false) {
                                                                                    String schemaInstance2;
                                                                                    schemaInstance2 = schemaValue.getTextValue();
                                                                                    propertiesInstance7.setSchema(schemaInstance2);
                                                                                }
                                                                                
                                                                                JsonNode tableValue = propertiesValue7.get("table");
                                                                                if (tableValue != null && tableValue instanceof NullNode == false) {
                                                                                    String tableInstance2;
                                                                                    tableInstance2 = tableValue.getTextValue();
                                                                                    propertiesInstance7.setTable(tableInstance2);
                                                                                }
                                                                                
                                                                                JsonNode columnsArray2 = propertiesValue7.get("columns");
                                                                                if (columnsArray2 != null && columnsArray2 instanceof NullNode == false) {
                                                                                    for (JsonNode columnsValue2 : ((ArrayNode) columnsArray2)) {
                                                                                        propertiesInstance7.getColumns().add(columnsValue2.getTextValue());
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode includedColumnsArray = propertiesValue7.get("includedColumns");
                                                                                if (includedColumnsArray != null && includedColumnsArray instanceof NullNode == false) {
                                                                                    for (JsonNode includedColumnsValue : ((ArrayNode) includedColumnsArray)) {
                                                                                        propertiesInstance7.getIncludedColumns().add(includedColumnsValue.getTextValue());
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode indexScriptValue = propertiesValue7.get("indexScript");
                                                                                if (indexScriptValue != null && indexScriptValue instanceof NullNode == false) {
                                                                                    String indexScriptInstance;
                                                                                    indexScriptInstance = indexScriptValue.getTextValue();
                                                                                    propertiesInstance7.setIndexScript(indexScriptInstance);
                                                                                }
                                                                                
                                                                                JsonNode estimatedImpactArray = propertiesValue7.get("estimatedImpact");
                                                                                if (estimatedImpactArray != null && estimatedImpactArray instanceof NullNode == false) {
                                                                                    for (JsonNode estimatedImpactValue : ((ArrayNode) estimatedImpactArray)) {
                                                                                        OperationImpact operationImpactInstance = new OperationImpact();
                                                                                        propertiesInstance7.getEstimatedImpact().add(operationImpactInstance);
                                                                                        
                                                                                        JsonNode nameValue5 = estimatedImpactValue.get("name");
                                                                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                                                            String nameInstance5;
                                                                                            nameInstance5 = nameValue5.getTextValue();
                                                                                            operationImpactInstance.setName(nameInstance5);
                                                                                        }
                                                                                        
                                                                                        JsonNode unitValue = estimatedImpactValue.get("unit");
                                                                                        if (unitValue != null && unitValue instanceof NullNode == false) {
                                                                                            String unitInstance;
                                                                                            unitInstance = unitValue.getTextValue();
                                                                                            operationImpactInstance.setUnit(unitInstance);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueAbsoluteValue = estimatedImpactValue.get("changeValueAbsolute");
                                                                                        if (changeValueAbsoluteValue != null && changeValueAbsoluteValue instanceof NullNode == false) {
                                                                                            double changeValueAbsoluteInstance;
                                                                                            changeValueAbsoluteInstance = changeValueAbsoluteValue.getDoubleValue();
                                                                                            operationImpactInstance.setChangeValueAbsolute(changeValueAbsoluteInstance);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueRelativeValue = estimatedImpactValue.get("changeValueRelative");
                                                                                        if (changeValueRelativeValue != null && changeValueRelativeValue instanceof NullNode == false) {
                                                                                            double changeValueRelativeInstance;
                                                                                            changeValueRelativeInstance = changeValueRelativeValue.getDoubleValue();
                                                                                            operationImpactInstance.setChangeValueRelative(changeValueRelativeInstance);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                
                                                                                JsonNode reportedImpactArray = propertiesValue7.get("reportedImpact");
                                                                                if (reportedImpactArray != null && reportedImpactArray instanceof NullNode == false) {
                                                                                    for (JsonNode reportedImpactValue : ((ArrayNode) reportedImpactArray)) {
                                                                                        OperationImpact operationImpactInstance2 = new OperationImpact();
                                                                                        propertiesInstance7.getReportedImpact().add(operationImpactInstance2);
                                                                                        
                                                                                        JsonNode nameValue6 = reportedImpactValue.get("name");
                                                                                        if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                                                            String nameInstance6;
                                                                                            nameInstance6 = nameValue6.getTextValue();
                                                                                            operationImpactInstance2.setName(nameInstance6);
                                                                                        }
                                                                                        
                                                                                        JsonNode unitValue2 = reportedImpactValue.get("unit");
                                                                                        if (unitValue2 != null && unitValue2 instanceof NullNode == false) {
                                                                                            String unitInstance2;
                                                                                            unitInstance2 = unitValue2.getTextValue();
                                                                                            operationImpactInstance2.setUnit(unitInstance2);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueAbsoluteValue2 = reportedImpactValue.get("changeValueAbsolute");
                                                                                        if (changeValueAbsoluteValue2 != null && changeValueAbsoluteValue2 instanceof NullNode == false) {
                                                                                            double changeValueAbsoluteInstance2;
                                                                                            changeValueAbsoluteInstance2 = changeValueAbsoluteValue2.getDoubleValue();
                                                                                            operationImpactInstance2.setChangeValueAbsolute(changeValueAbsoluteInstance2);
                                                                                        }
                                                                                        
                                                                                        JsonNode changeValueRelativeValue2 = reportedImpactValue.get("changeValueRelative");
                                                                                        if (changeValueRelativeValue2 != null && changeValueRelativeValue2 instanceof NullNode == false) {
                                                                                            double changeValueRelativeInstance2;
                                                                                            changeValueRelativeInstance2 = changeValueRelativeValue2.getDoubleValue();
                                                                                            operationImpactInstance2.setChangeValueRelative(changeValueRelativeInstance2);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            
                                                                            JsonNode idValue5 = recommendedIndexesValue.get("id");
                                                                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                                                String idInstance5;
                                                                                idInstance5 = idValue5.getTextValue();
                                                                                recommendedIndexInstance.setId(idInstance5);
                                                                            }
                                                                            
                                                                            JsonNode nameValue7 = recommendedIndexesValue.get("name");
                                                                            if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                                                                String nameInstance7;
                                                                                nameInstance7 = nameValue7.getTextValue();
                                                                                recommendedIndexInstance.setName(nameInstance7);
                                                                            }
                                                                            
                                                                            JsonNode typeValue5 = recommendedIndexesValue.get("type");
                                                                            if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                                                String typeInstance5;
                                                                                typeInstance5 = typeValue5.getTextValue();
                                                                                recommendedIndexInstance.setType(typeInstance5);
                                                                            }
                                                                            
                                                                            JsonNode locationValue5 = recommendedIndexesValue.get("location");
                                                                            if (locationValue5 != null && locationValue5 instanceof NullNode == false) {
                                                                                String locationInstance5;
                                                                                locationInstance5 = locationValue5.getTextValue();
                                                                                recommendedIndexInstance.setLocation(locationInstance5);
                                                                            }
                                                                            
                                                                            JsonNode tagsSequenceElement5 = ((JsonNode) recommendedIndexesValue.get("tags"));
                                                                            if (tagsSequenceElement5 != null && tagsSequenceElement5 instanceof NullNode == false) {
                                                                                Iterator<Map.Entry<String, JsonNode>> itr5 = tagsSequenceElement5.getFields();
                                                                                while (itr5.hasNext()) {
                                                                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                                                                    String tagsKey5 = property5.getKey();
                                                                                    String tagsValue5 = property5.getValue().getTextValue();
                                                                                    recommendedIndexInstance.getTags().put(tagsKey5, tagsValue5);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                
                                                                JsonNode idValue6 = tablesValue.get("id");
                                                                if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                                    String idInstance6;
                                                                    idInstance6 = idValue6.getTextValue();
                                                                    tableInstance.setId(idInstance6);
                                                                }
                                                                
                                                                JsonNode nameValue8 = tablesValue.get("name");
                                                                if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                                                    String nameInstance8;
                                                                    nameInstance8 = nameValue8.getTextValue();
                                                                    tableInstance.setName(nameInstance8);
                                                                }
                                                                
                                                                JsonNode typeValue6 = tablesValue.get("type");
                                                                if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                                    String typeInstance6;
                                                                    typeInstance6 = typeValue6.getTextValue();
                                                                    tableInstance.setType(typeInstance6);
                                                                }
                                                                
                                                                JsonNode locationValue6 = tablesValue.get("location");
                                                                if (locationValue6 != null && locationValue6 instanceof NullNode == false) {
                                                                    String locationInstance6;
                                                                    locationInstance6 = locationValue6.getTextValue();
                                                                    tableInstance.setLocation(locationInstance6);
                                                                }
                                                                
                                                                JsonNode tagsSequenceElement6 = ((JsonNode) tablesValue.get("tags"));
                                                                if (tagsSequenceElement6 != null && tagsSequenceElement6 instanceof NullNode == false) {
                                                                    Iterator<Map.Entry<String, JsonNode>> itr6 = tagsSequenceElement6.getFields();
                                                                    while (itr6.hasNext()) {
                                                                        Map.Entry<String, JsonNode> property6 = itr6.next();
                                                                        String tagsKey6 = property6.getKey();
                                                                        String tagsValue6 = property6.getValue().getTextValue();
                                                                        tableInstance.getTags().put(tagsKey6, tagsValue6);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    
                                                    JsonNode idValue7 = schemasValue.get("id");
                                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                        String idInstance7;
                                                        idInstance7 = idValue7.getTextValue();
                                                        schemaInstance.setId(idInstance7);
                                                    }
                                                    
                                                    JsonNode nameValue9 = schemasValue.get("name");
                                                    if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                                        String nameInstance9;
                                                        nameInstance9 = nameValue9.getTextValue();
                                                        schemaInstance.setName(nameInstance9);
                                                    }
                                                    
                                                    JsonNode typeValue7 = schemasValue.get("type");
                                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                        String typeInstance7;
                                                        typeInstance7 = typeValue7.getTextValue();
                                                        schemaInstance.setType(typeInstance7);
                                                    }
                                                    
                                                    JsonNode locationValue7 = schemasValue.get("location");
                                                    if (locationValue7 != null && locationValue7 instanceof NullNode == false) {
                                                        String locationInstance7;
                                                        locationInstance7 = locationValue7.getTextValue();
                                                        schemaInstance.setLocation(locationInstance7);
                                                    }
                                                    
                                                    JsonNode tagsSequenceElement7 = ((JsonNode) schemasValue.get("tags"));
                                                    if (tagsSequenceElement7 != null && tagsSequenceElement7 instanceof NullNode == false) {
                                                        Iterator<Map.Entry<String, JsonNode>> itr7 = tagsSequenceElement7.getFields();
                                                        while (itr7.hasNext()) {
                                                            Map.Entry<String, JsonNode> property7 = itr7.next();
                                                            String tagsKey7 = property7.getKey();
                                                            String tagsValue7 = property7.getValue().getTextValue();
                                                            schemaInstance.getTags().put(tagsKey7, tagsValue7);
                                                        }
                                                    }
                                                }
                                            }
                                            
                                            JsonNode defaultSecondaryLocationValue = propertiesValue2.get("defaultSecondaryLocation");
                                            if (defaultSecondaryLocationValue != null && defaultSecondaryLocationValue instanceof NullNode == false) {
                                                String defaultSecondaryLocationInstance;
                                                defaultSecondaryLocationInstance = defaultSecondaryLocationValue.getTextValue();
                                                propertiesInstance2.setDefaultSecondaryLocation(defaultSecondaryLocationInstance);
                                            }
                                        }
                                        
                                        JsonNode idValue8 = databasesValue.get("id");
                                        if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                            String idInstance8;
                                            idInstance8 = idValue8.getTextValue();
                                            databaseInstance.setId(idInstance8);
                                        }
                                        
                                        JsonNode nameValue10 = databasesValue.get("name");
                                        if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                            String nameInstance10;
                                            nameInstance10 = nameValue10.getTextValue();
                                            databaseInstance.setName(nameInstance10);
                                        }
                                        
                                        JsonNode typeValue8 = databasesValue.get("type");
                                        if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                            String typeInstance8;
                                            typeInstance8 = typeValue8.getTextValue();
                                            databaseInstance.setType(typeInstance8);
                                        }
                                        
                                        JsonNode locationValue8 = databasesValue.get("location");
                                        if (locationValue8 != null && locationValue8 instanceof NullNode == false) {
                                            String locationInstance8;
                                            locationInstance8 = locationValue8.getTextValue();
                                            databaseInstance.setLocation(locationInstance8);
                                        }
                                        
                                        JsonNode tagsSequenceElement8 = ((JsonNode) databasesValue.get("tags"));
                                        if (tagsSequenceElement8 != null && tagsSequenceElement8 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr8 = tagsSequenceElement8.getFields();
                                            while (itr8.hasNext()) {
                                                Map.Entry<String, JsonNode> property8 = itr8.next();
                                                String tagsKey8 = property8.getKey();
                                                String tagsValue8 = property8.getValue().getTextValue();
                                                databaseInstance.getTags().put(tagsKey8, tagsValue8);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode metricsArray = propertiesValue.get("metrics");
                                if (metricsArray != null && metricsArray instanceof NullNode == false) {
                                    for (JsonNode metricsValue : ((ArrayNode) metricsArray)) {
                                        RecommendedElasticPoolMetric recommendedElasticPoolMetricInstance = new RecommendedElasticPoolMetric();
                                        propertiesInstance.getMetrics().add(recommendedElasticPoolMetricInstance);
                                        
                                        JsonNode dateTimeValue = metricsValue.get("dateTime");
                                        if (dateTimeValue != null && dateTimeValue instanceof NullNode == false) {
                                            Calendar dateTimeInstance;
                                            dateTimeInstance = DatatypeConverter.parseDateTime(dateTimeValue.getTextValue());
                                            recommendedElasticPoolMetricInstance.setDateTime(dateTimeInstance);
                                        }
                                        
                                        JsonNode dtuValue2 = metricsValue.get("dtu");
                                        if (dtuValue2 != null && dtuValue2 instanceof NullNode == false) {
                                            double dtuInstance2;
                                            dtuInstance2 = dtuValue2.getDoubleValue();
                                            recommendedElasticPoolMetricInstance.setDtu(dtuInstance2);
                                        }
                                        
                                        JsonNode sizeGBValue = metricsValue.get("sizeGB");
                                        if (sizeGBValue != null && sizeGBValue instanceof NullNode == false) {
                                            double sizeGBInstance;
                                            sizeGBInstance = sizeGBValue.getDoubleValue();
                                            recommendedElasticPoolMetricInstance.setSizeGB(sizeGBInstance);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue9 = valueValue.get("id");
                            if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                String idInstance9;
                                idInstance9 = idValue9.getTextValue();
                                recommendedElasticPoolInstance.setId(idInstance9);
                            }
                            
                            JsonNode nameValue11 = valueValue.get("name");
                            if (nameValue11 != null && nameValue11 instanceof NullNode == false) {
                                String nameInstance11;
                                nameInstance11 = nameValue11.getTextValue();
                                recommendedElasticPoolInstance.setName(nameInstance11);
                            }
                            
                            JsonNode typeValue9 = valueValue.get("type");
                            if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                String typeInstance9;
                                typeInstance9 = typeValue9.getTextValue();
                                recommendedElasticPoolInstance.setType(typeInstance9);
                            }
                            
                            JsonNode locationValue9 = valueValue.get("location");
                            if (locationValue9 != null && locationValue9 instanceof NullNode == false) {
                                String locationInstance9;
                                locationInstance9 = locationValue9.getTextValue();
                                recommendedElasticPoolInstance.setLocation(locationInstance9);
                            }
                            
                            JsonNode tagsSequenceElement9 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement9 != null && tagsSequenceElement9 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr9 = tagsSequenceElement9.getFields();
                                while (itr9.hasNext()) {
                                    Map.Entry<String, JsonNode> property9 = itr9.next();
                                    String tagsKey9 = property9.getKey();
                                    String tagsValue9 = property9.getValue().getTextValue();
                                    recommendedElasticPoolInstance.getTags().put(tagsKey9, tagsValue9);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about an recommended elastic pool metrics.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool metrics request.
    */
    @Override
    public Future<RecommendedElasticPoolListMetricsResponse> listMetricsAsync(final String resourceGroupName, final String serverName, final String recommendedElasticPoolName) {
        return this.getClient().getExecutorService().submit(new Callable<RecommendedElasticPoolListMetricsResponse>() { 
            @Override
            public RecommendedElasticPoolListMetricsResponse call() throws Exception {
                return listMetrics(resourceGroupName, serverName, recommendedElasticPoolName);
            }
         });
    }
    
    /**
    * Returns information about an recommended elastic pool metrics.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server.
    * @param recommendedElasticPoolName Required. The name of the Azure SQL
    * Recommended Elastic Pool to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Recommended Elastic
    * Pool metrics request.
    */
    @Override
    public RecommendedElasticPoolListMetricsResponse listMetrics(String resourceGroupName, String serverName, String recommendedElasticPoolName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (recommendedElasticPoolName == null) {
            throw new NullPointerException("recommendedElasticPoolName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("recommendedElasticPoolName", recommendedElasticPoolName);
            CloudTracing.enter(invocationId, this, "listMetricsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recommendedElasticPools/";
        url = url + URLEncoder.encode(recommendedElasticPoolName, "UTF-8");
        url = url + "/metrics";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            RecommendedElasticPoolListMetricsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecommendedElasticPoolListMetricsResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            RecommendedElasticPoolMetric recommendedElasticPoolMetricInstance = new RecommendedElasticPoolMetric();
                            result.getRecommendedElasticPoolsMetrics().add(recommendedElasticPoolMetricInstance);
                            
                            JsonNode dateTimeValue = valueValue.get("dateTime");
                            if (dateTimeValue != null && dateTimeValue instanceof NullNode == false) {
                                Calendar dateTimeInstance;
                                dateTimeInstance = DatatypeConverter.parseDateTime(dateTimeValue.getTextValue());
                                recommendedElasticPoolMetricInstance.setDateTime(dateTimeInstance);
                            }
                            
                            JsonNode dtuValue = valueValue.get("dtu");
                            if (dtuValue != null && dtuValue instanceof NullNode == false) {
                                double dtuInstance;
                                dtuInstance = dtuValue.getDoubleValue();
                                recommendedElasticPoolMetricInstance.setDtu(dtuInstance);
                            }
                            
                            JsonNode sizeGBValue = valueValue.get("sizeGB");
                            if (sizeGBValue != null && sizeGBValue instanceof NullNode == false) {
                                double sizeGBInstance;
                                sizeGBInstance = sizeGBValue.getDoubleValue();
                                recommendedElasticPoolMetricInstance.setSizeGB(sizeGBInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
