/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ReplicationLinkFailoverResponse;
import com.microsoft.azure.management.sql.models.ReplicationLinkGetResponse;
import com.microsoft.azure.management.sql.models.ReplicationLinkListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database Replication
* Links.  Contains operations to: Delete and Retrieve replication links.
*/
public interface ReplicationLinkOperations {
    /**
    * Begins failover of the Azure SQL Database Replication Link with the given
    * id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    ReplicationLinkFailoverResponse beginFailover(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException;
    
    /**
    * Begins failover of the Azure SQL Database Replication Link with the given
    * id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    Future<ReplicationLinkFailoverResponse> beginFailoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Begins a forced failover of the Azure SQL Database Replication Link with
    * the given id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    ReplicationLinkFailoverResponse beginFailoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException;
    
    /**
    * Begins a forced failover of the Azure SQL Database Replication Link with
    * the given id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    Future<ReplicationLinkFailoverResponse> beginFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Deletes the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be dropped.
    * @param linkId Required. The id of the replication link to be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Deletes the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be dropped.
    * @param linkId Required. The id of the replication link to be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Fails over the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    ReplicationLinkFailoverResponse failover(String resourceGroupName, String serverName, String databaseName, String linkId) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * Fails over the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    Future<ReplicationLinkFailoverResponse> failoverAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Forces failover of the Azure SQL Database Replication Link with the given
    * id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    ReplicationLinkFailoverResponse failoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * Forces failover of the Azure SQL Database Replication Link with the given
    * id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    Future<ReplicationLinkFailoverResponse> failoverAllowDataLossAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Returns information about an Azure SQL Database Replication Link.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to get
    * the link for.
    * @param linkId Required. The replication link id to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database Replication
    * Link request.
    */
    ReplicationLinkGetResponse get(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database Replication Link.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to get
    * the link for.
    * @param linkId Required. The replication link id to be retrieved.
    * @return Represents the response to a Get Azure Sql Database Replication
    * Link request.
    */
    Future<ReplicationLinkGetResponse> getAsync(String resourceGroupName, String serverName, String databaseName, String linkId);
    
    /**
    * Gets the status of an Azure SQL Database replication link failover
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    ReplicationLinkFailoverResponse getReplicationLinkOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * Gets the status of an Azure SQL Database replication link failover
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    Future<ReplicationLinkFailoverResponse> getReplicationLinkOperationStatusAsync(String operationStatusLink);
    
    /**
    * Returns information about Azure SQL Database Replication Links.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server in which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to
    * retrieve links for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database Replication
    * Link request.
    */
    ReplicationLinkListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Database Replication Links.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server in which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to
    * retrieve links for.
    * @return Represents the response to a List Azure Sql Database Replication
    * Link request.
    */
    Future<ReplicationLinkListResponse> listAsync(String resourceGroupName, String serverName, String databaseName);
}
