/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ReplicationLink;
import com.microsoft.azure.management.sql.models.ReplicationLinkFailoverResponse;
import com.microsoft.azure.management.sql.models.ReplicationLinkGetResponse;
import com.microsoft.azure.management.sql.models.ReplicationLinkListResponse;
import com.microsoft.azure.management.sql.models.ReplicationLinkProperties;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database Replication
* Links.  Contains operations to: Delete and Retrieve replication links.
*/
public class ReplicationLinkOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, ReplicationLinkOperations {
    /**
    * Initializes a new instance of the ReplicationLinkOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ReplicationLinkOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Begins failover of the Azure SQL Database Replication Link with the given
    * id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public Future<ReplicationLinkFailoverResponse> beginFailoverAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkFailoverResponse>() { 
            @Override
            public ReplicationLinkFailoverResponse call() throws Exception {
                return beginFailover(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Begins failover of the Azure SQL Database Replication Link with the given
    * id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public ReplicationLinkFailoverResponse beginFailover(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "beginFailoverAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/replicationLinks/";
        url = url + URLEncoder.encode(linkId, "UTF-8");
        url = url + "/failover";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ReplicationLinkFailoverResponse result = null;
            // Deserialize Response
            result = new ReplicationLinkFailoverResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Begins a forced failover of the Azure SQL Database Replication Link with
    * the given id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public Future<ReplicationLinkFailoverResponse> beginFailoverAllowDataLossAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkFailoverResponse>() { 
            @Override
            public ReplicationLinkFailoverResponse call() throws Exception {
                return beginFailoverAllowDataLoss(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Begins a forced failover of the Azure SQL Database Replication Link with
    * the given id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public ReplicationLinkFailoverResponse beginFailoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "beginFailoverAllowDataLossAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/replicationLinks/";
        url = url + URLEncoder.encode(linkId, "UTF-8");
        url = url + "/forceFailoverAllowDataLoss";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ReplicationLinkFailoverResponse result = null;
            // Deserialize Response
            result = new ReplicationLinkFailoverResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be dropped.
    * @param linkId Required. The id of the replication link to be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Deletes the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be dropped.
    * @param linkId Required. The id of the replication link to be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException, InterruptedException, ExecutionException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/replicationLinks/";
        url = url + URLEncoder.encode(linkId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Fails over the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public Future<ReplicationLinkFailoverResponse> failoverAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkFailoverResponse>() { 
            @Override
            public ReplicationLinkFailoverResponse call() throws Exception {
                return failover(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Fails over the Azure SQL Database Replication Link with the given id.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public ReplicationLinkFailoverResponse failover(String resourceGroupName, String serverName, String databaseName, String linkId) throws InterruptedException, ExecutionException, IOException {
        SqlManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "failoverAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ReplicationLinkFailoverResponse response = client2.getDatabaseReplicationLinksOperations().beginFailoverAsync(resourceGroupName, serverName, databaseName, linkId).get();
            if (response.getStatus() == OperationStatus.Succeeded) {
                return response;
            }
            ReplicationLinkFailoverResponse result = client2.getDatabaseReplicationLinksOperations().getReplicationLinkOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDatabaseReplicationLinksOperations().getReplicationLinkOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Forces failover of the Azure SQL Database Replication Link with the given
    * id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public Future<ReplicationLinkFailoverResponse> failoverAllowDataLossAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkFailoverResponse>() { 
            @Override
            public ReplicationLinkFailoverResponse call() throws Exception {
                return failoverAllowDataLoss(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Forces failover of the Azure SQL Database Replication Link with the given
    * id which may result in data loss.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database that has
    * the replication link to be failed over.
    * @param linkId Required. The id of the replication link to be failed over.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public ReplicationLinkFailoverResponse failoverAllowDataLoss(String resourceGroupName, String serverName, String databaseName, String linkId) throws InterruptedException, ExecutionException, IOException {
        SqlManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "failoverAllowDataLossAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ReplicationLinkFailoverResponse response = client2.getDatabaseReplicationLinksOperations().beginFailoverAllowDataLossAsync(resourceGroupName, serverName, databaseName, linkId).get();
            if (response.getStatus() == OperationStatus.Succeeded) {
                return response;
            }
            ReplicationLinkFailoverResponse result = client2.getDatabaseReplicationLinksOperations().getReplicationLinkOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDatabaseReplicationLinksOperations().getReplicationLinkOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Returns information about an Azure SQL Database Replication Link.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to get
    * the link for.
    * @param linkId Required. The replication link id to be retrieved.
    * @return Represents the response to a Get Azure Sql Database Replication
    * Link request.
    */
    @Override
    public Future<ReplicationLinkGetResponse> getAsync(final String resourceGroupName, final String serverName, final String databaseName, final String linkId) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkGetResponse>() { 
            @Override
            public ReplicationLinkGetResponse call() throws Exception {
                return get(resourceGroupName, serverName, databaseName, linkId);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Database Replication Link.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to get
    * the link for.
    * @param linkId Required. The replication link id to be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database Replication
    * Link request.
    */
    @Override
    public ReplicationLinkGetResponse get(String resourceGroupName, String serverName, String databaseName, String linkId) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (linkId == null) {
            throw new NullPointerException("linkId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("linkId", linkId);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/replicationLinks/";
        url = url + URLEncoder.encode(linkId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ReplicationLinkGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ReplicationLinkGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ReplicationLink replicationLinkInstance = new ReplicationLink();
                    result.setReplicationLink(replicationLinkInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        ReplicationLinkProperties propertiesInstance = new ReplicationLinkProperties();
                        replicationLinkInstance.setProperties(propertiesInstance);
                        
                        JsonNode partnerServerValue = propertiesValue.get("partnerServer");
                        if (partnerServerValue != null && partnerServerValue instanceof NullNode == false) {
                            String partnerServerInstance;
                            partnerServerInstance = partnerServerValue.getTextValue();
                            propertiesInstance.setPartnerServer(partnerServerInstance);
                        }
                        
                        JsonNode partnerDatabaseValue = propertiesValue.get("partnerDatabase");
                        if (partnerDatabaseValue != null && partnerDatabaseValue instanceof NullNode == false) {
                            String partnerDatabaseInstance;
                            partnerDatabaseInstance = partnerDatabaseValue.getTextValue();
                            propertiesInstance.setPartnerDatabase(partnerDatabaseInstance);
                        }
                        
                        JsonNode partnerLocationValue = propertiesValue.get("partnerLocation");
                        if (partnerLocationValue != null && partnerLocationValue instanceof NullNode == false) {
                            String partnerLocationInstance;
                            partnerLocationInstance = partnerLocationValue.getTextValue();
                            propertiesInstance.setPartnerLocation(partnerLocationInstance);
                        }
                        
                        JsonNode roleValue = propertiesValue.get("role");
                        if (roleValue != null && roleValue instanceof NullNode == false) {
                            String roleInstance;
                            roleInstance = roleValue.getTextValue();
                            propertiesInstance.setRole(roleInstance);
                        }
                        
                        JsonNode partnerRoleValue = propertiesValue.get("partnerRole");
                        if (partnerRoleValue != null && partnerRoleValue instanceof NullNode == false) {
                            String partnerRoleInstance;
                            partnerRoleInstance = partnerRoleValue.getTextValue();
                            propertiesInstance.setPartnerRole(partnerRoleInstance);
                        }
                        
                        JsonNode startTimeValue = propertiesValue.get("startTime");
                        if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                            Calendar startTimeInstance;
                            startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                            propertiesInstance.setStartTime(startTimeInstance);
                        }
                        
                        JsonNode percentCompleteValue = propertiesValue.get("percentComplete");
                        if (percentCompleteValue != null && percentCompleteValue instanceof NullNode == false) {
                            String percentCompleteInstance;
                            percentCompleteInstance = percentCompleteValue.getTextValue();
                            propertiesInstance.setPercentComplete(percentCompleteInstance);
                        }
                        
                        JsonNode replicationStateValue = propertiesValue.get("replicationState");
                        if (replicationStateValue != null && replicationStateValue instanceof NullNode == false) {
                            String replicationStateInstance;
                            replicationStateInstance = replicationStateValue.getTextValue();
                            propertiesInstance.setReplicationState(replicationStateInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        replicationLinkInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        replicationLinkInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        replicationLinkInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        replicationLinkInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            replicationLinkInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the status of an Azure SQL Database replication link failover
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public Future<ReplicationLinkFailoverResponse> getReplicationLinkOperationStatusAsync(final String operationStatusLink) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkFailoverResponse>() { 
            @Override
            public ReplicationLinkFailoverResponse call() throws Exception {
                return getReplicationLinkOperationStatus(operationStatusLink);
            }
         });
    }
    
    /**
    * Gets the status of an Azure SQL Database replication link failover
    * operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure Sql Database replication failover
    * operations.
    */
    @Override
    public ReplicationLinkFailoverResponse getReplicationLinkOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        // Validate
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter(invocationId, this, "getReplicationLinkOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ReplicationLinkFailoverResponse result = null;
            // Deserialize Response
            result = new ReplicationLinkFailoverResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about Azure SQL Database Replication Links.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server in which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to
    * retrieve links for.
    * @return Represents the response to a List Azure Sql Database Replication
    * Link request.
    */
    @Override
    public Future<ReplicationLinkListResponse> listAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<ReplicationLinkListResponse>() { 
            @Override
            public ReplicationLinkListResponse call() throws Exception {
                return list(resourceGroupName, serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns information about Azure SQL Database Replication Links.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server in which the
    * Azure SQL Database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to
    * retrieve links for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database Replication
    * Link request.
    */
    @Override
    public ReplicationLinkListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/replicationLinks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ReplicationLinkListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ReplicationLinkListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ReplicationLink replicationLinkInstance = new ReplicationLink();
                            result.getReplicationLinks().add(replicationLinkInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ReplicationLinkProperties propertiesInstance = new ReplicationLinkProperties();
                                replicationLinkInstance.setProperties(propertiesInstance);
                                
                                JsonNode partnerServerValue = propertiesValue.get("partnerServer");
                                if (partnerServerValue != null && partnerServerValue instanceof NullNode == false) {
                                    String partnerServerInstance;
                                    partnerServerInstance = partnerServerValue.getTextValue();
                                    propertiesInstance.setPartnerServer(partnerServerInstance);
                                }
                                
                                JsonNode partnerDatabaseValue = propertiesValue.get("partnerDatabase");
                                if (partnerDatabaseValue != null && partnerDatabaseValue instanceof NullNode == false) {
                                    String partnerDatabaseInstance;
                                    partnerDatabaseInstance = partnerDatabaseValue.getTextValue();
                                    propertiesInstance.setPartnerDatabase(partnerDatabaseInstance);
                                }
                                
                                JsonNode partnerLocationValue = propertiesValue.get("partnerLocation");
                                if (partnerLocationValue != null && partnerLocationValue instanceof NullNode == false) {
                                    String partnerLocationInstance;
                                    partnerLocationInstance = partnerLocationValue.getTextValue();
                                    propertiesInstance.setPartnerLocation(partnerLocationInstance);
                                }
                                
                                JsonNode roleValue = propertiesValue.get("role");
                                if (roleValue != null && roleValue instanceof NullNode == false) {
                                    String roleInstance;
                                    roleInstance = roleValue.getTextValue();
                                    propertiesInstance.setRole(roleInstance);
                                }
                                
                                JsonNode partnerRoleValue = propertiesValue.get("partnerRole");
                                if (partnerRoleValue != null && partnerRoleValue instanceof NullNode == false) {
                                    String partnerRoleInstance;
                                    partnerRoleInstance = partnerRoleValue.getTextValue();
                                    propertiesInstance.setPartnerRole(partnerRoleInstance);
                                }
                                
                                JsonNode startTimeValue = propertiesValue.get("startTime");
                                if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                    Calendar startTimeInstance;
                                    startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                    propertiesInstance.setStartTime(startTimeInstance);
                                }
                                
                                JsonNode percentCompleteValue = propertiesValue.get("percentComplete");
                                if (percentCompleteValue != null && percentCompleteValue instanceof NullNode == false) {
                                    String percentCompleteInstance;
                                    percentCompleteInstance = percentCompleteValue.getTextValue();
                                    propertiesInstance.setPercentComplete(percentCompleteInstance);
                                }
                                
                                JsonNode replicationStateValue = propertiesValue.get("replicationState");
                                if (replicationStateValue != null && replicationStateValue instanceof NullNode == false) {
                                    String replicationStateInstance;
                                    replicationStateInstance = replicationStateValue.getTextValue();
                                    propertiesInstance.setReplicationState(replicationStateInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                replicationLinkInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                replicationLinkInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                replicationLinkInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                replicationLinkInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    replicationLinkInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
