/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.DatabaseSecurityPolicyGetResponse;
import com.microsoft.azure.management.sql.models.DatabaseSecurityPolicyUpdateParameters;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database security
* policy.  Contains operations to: Retrieve and Update security policy
*/
public interface SecurityOperations {
    /**
    * Gets Azure SQL Database security policy object according to a given Azure
    * SQL Database Server and Database.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the security policy is being retreived.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a get Azure SQL Database security
    * policy request
    */
    DatabaseSecurityPolicyGetResponse get(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Gets Azure SQL Database security policy object according to a given Azure
    * SQL Database Server and Database.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the Azure SQL Database hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the security policy is being retreived.
    * @return Represents the response to a get Azure SQL Database security
    * policy request
    */
    Future<DatabaseSecurityPolicyGetResponse> getAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Updates an Azure SQL Database security policy object.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * which the Azure SQL Database belongs.
    * @param databaseName Required. The name of the Azure SQL Database to which
    * the security policy is applied.
    * @param parameters Required. The required parameters for updating a
    * security policy.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse update(String resourceGroupName, String serverName, String databaseName, DatabaseSecurityPolicyUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Updates an Azure SQL Database security policy object.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the Azure SQL Database Server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * which the Azure SQL Database belongs.
    * @param databaseName Required. The name of the Azure SQL Database to which
    * the security policy is applied.
    * @param parameters Required. The required parameters for updating a
    * security policy.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseSecurityPolicyUpdateParameters parameters);
}
