/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ServerAdministratorCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.ServerAdministratorCreateOrUpdateResponse;
import com.microsoft.azure.management.sql.models.ServerAdministratorDeleteResponse;
import com.microsoft.azure.management.sql.models.ServerAdministratorGetResponse;
import com.microsoft.azure.management.sql.models.ServerAdministratorListResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Server Active
* Directory Administrators.  Contains operations to: Create, Retrieve, Update,
* and Delete Azure SQL Server Active Directory Administrators.
*/
public interface ServerAdministratorOperations {
    /**
    * Begins creating a new Azure SQL Server Active Directory Administrator or
    * updating an existing Azure SQL Server Active Directory Administrator. To
    * determine the status of the operation call
    * GetServerAdministratorOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @param parameters Required. The required parameters for createing or
    * updating an Active Directory Administrator.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    ServerAdministratorCreateOrUpdateResponse beginCreateOrUpdate(String resourceGroupName, String serverName, String administratorName, ServerAdministratorCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Begins creating a new Azure SQL Server Active Directory Administrator or
    * updating an existing Azure SQL Server Active Directory Administrator. To
    * determine the status of the operation call
    * GetServerAdministratorOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @param parameters Required. The required parameters for createing or
    * updating an Active Directory Administrator.
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    Future<ServerAdministratorCreateOrUpdateResponse> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String administratorName, ServerAdministratorCreateOrUpdateParameters parameters);
    
    /**
    * Begins deleting an existing Azure SQL Server Active Directory
    * Administrator.To determine the status of the operation call
    * GetServerAdministratorDeleteOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    ServerAdministratorDeleteResponse beginDelete(String resourceGroupName, String serverName, String administratorName) throws IOException, ServiceException;
    
    /**
    * Begins deleting an existing Azure SQL Server Active Directory
    * Administrator.To determine the status of the operation call
    * GetServerAdministratorDeleteOperationStatus.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    Future<ServerAdministratorDeleteResponse> beginDeleteAsync(String resourceGroupName, String serverName, String administratorName);
    
    /**
    * Creates a new Azure SQL Server Active Directory Administrator or updates
    * an existing Azure SQL Server Active Directory Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Server Active Directory Administrator is hosted.
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator to be operated on (Updated or created).
    * @param parameters Required. The required parameters for creating or
    * updating a Server Administrator.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    ServerAdministratorCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String serverName, String administratorName, ServerAdministratorCreateOrUpdateParameters parameters) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Creates a new Azure SQL Server Active Directory Administrator or updates
    * an existing Azure SQL Server Active Directory Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server on which the
    * Azure SQL Server Active Directory Administrator is hosted.
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator to be operated on (Updated or created).
    * @param parameters Required. The required parameters for creating or
    * updating a Server Administrator.
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    Future<ServerAdministratorCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String serverName, String administratorName, ServerAdministratorCreateOrUpdateParameters parameters);
    
    /**
    * Deletes an existing Azure SQL Server Active Directory Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator to be operated on (Updated or created).
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    ServerAdministratorDeleteResponse delete(String resourceGroupName, String serverName, String administratorName) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Deletes an existing Azure SQL Server Active Directory Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator to be operated on (Updated or created).
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    Future<ServerAdministratorDeleteResponse> deleteAsync(String resourceGroupName, String serverName, String administratorName);
    
    /**
    * Returns an Azure SQL Server Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs.
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure SQL Server Active
    * Directory Administrators request.
    */
    ServerAdministratorGetResponse get(String resourceGroupName, String serverName, String administratorName) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Server Administrator.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrator belongs.
    * @param administratorName Required. The name of the Azure SQL Server
    * Active Directory Administrator.
    * @return Represents the response to a Get Azure SQL Server Active
    * Directory Administrators request.
    */
    Future<ServerAdministratorGetResponse> getAsync(String resourceGroupName, String serverName, String administratorName);
    
    /**
    * Gets the status of an Azure SQL Server Active Directory Administrator
    * delete operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    ServerAdministratorDeleteResponse getServerAdministratorDeleteOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * Gets the status of an Azure SQL Server Active Directory Administrator
    * delete operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure SQL Server Active Directory
    * administrator delete operations.
    */
    Future<ServerAdministratorDeleteResponse> getServerAdministratorDeleteOperationStatusAsync(String operationStatusLink);
    
    /**
    * Gets the status of an Azure SQL Server Active Directory Administrator
    * create or update operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    ServerAdministratorCreateOrUpdateResponse getServerAdministratorOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * Gets the status of an Azure SQL Server Active Directory Administrator
    * create or update operation.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation
    * @return Response for long running Azure SQL Server Active Directory
    * Administrator operations.
    */
    Future<ServerAdministratorCreateOrUpdateResponse> getServerAdministratorOperationStatusAsync(String operationStatusLink);
    
    /**
    * Returns a list of Azure SQL Server Administrators.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrators belongs.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure SQL Active Directory
    * Administrators request.
    */
    ServerAdministratorListResponse list(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns a list of Azure SQL Server Administrators.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Server to which the
    * Azure SQL Server Active Directory administrators belongs.
    * @return Represents the response to a List Azure SQL Active Directory
    * Administrators request.
    */
    Future<ServerAdministratorListResponse> listAsync(String resourceGroupName, String serverName);
}
