/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ServerCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.ServerGetResponse;
import com.microsoft.azure.management.sql.models.ServerListResponse;
import com.microsoft.azure.management.sql.models.ServerMetricListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Database Servers.
* Contains operations to: Create, Retrieve, Update, and Delete servers.
*/
public interface ServerOperations {
    /**
    * Creates a new Azure SQL Database server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param parameters Required. The required parameters for createing or
    * updating a database.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    ServerGetResponse createOrUpdate(String resourceGroupName, String serverName, ServerCreateOrUpdateParameters parameters) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Creates a new Azure SQL Database server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param parameters Required. The required parameters for createing or
    * updating a database.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    Future<ServerGetResponse> createOrUpdateAsync(String resourceGroupName, String serverName, ServerCreateOrUpdateParameters parameters);
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the server to delete.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String serverName) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the server to delete.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String serverName);
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the server to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    ServerGetResponse get(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the server to retrieve.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    Future<ServerGetResponse> getAsync(String resourceGroupName, String serverName);
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    ServerListResponse list(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * Returns information about an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @return Represents the response to a Get Azure Sql Database Server
    * request.
    */
    Future<ServerListResponse> listAsync(String resourceGroupName);
    
    /**
    * Returns information about Azure SQL Database Server usage.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which the Azure SQL Databases are hosted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database Server
    * metrics request.
    */
    ServerMetricListResponse listUsages(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns information about Azure SQL Database Server usage.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server in
    * which the Azure SQL Databases are hosted.
    * @return Represents the response to a List Azure Sql Database Server
    * metrics request.
    */
    Future<ServerMetricListResponse> listUsagesAsync(String resourceGroupName, String serverName);
}
