/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ServerUpgradeGetResponse;
import com.microsoft.azure.management.sql.models.ServerUpgradeStartParameters;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents all the operations for Azure SQL Database Server Upgrade
*/
public interface ServerUpgradeOperations {
    /**
    * Cancel a pending upgrade for the Azure SQL Database server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * cancel upgrade.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse cancel(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Cancel a pending upgrade for the Azure SQL Database server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * cancel upgrade.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> cancelAsync(String resourceGroupName, String serverName);
    
    /**
    * Returns information about Upgrade status of an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * upgrade.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get request for Upgrade status of an
    * Azure SQL Database Server.
    */
    ServerUpgradeGetResponse get(String resourceGroupName, String serverName) throws IOException, ServiceException;
    
    /**
    * Returns information about Upgrade status of an Azure SQL Database Server.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * upgrade.
    * @return Represents the response to a Get request for Upgrade status of an
    * Azure SQL Database Server.
    */
    Future<ServerUpgradeGetResponse> getAsync(String resourceGroupName, String serverName);
    
    /**
    * Start an Azure SQL Database Server Upgrade.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * upgrade.
    * @param parameters Required. The required parameters for the Azure SQL
    * Database Server Upgrade.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse start(String resourceGroupName, String serverName, ServerUpgradeStartParameters parameters) throws IOException, ServiceException;
    
    /**
    * Start an Azure SQL Database Server Upgrade.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server to
    * upgrade.
    * @param parameters Required. The required parameters for the Azure SQL
    * Database Server Upgrade.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> startAsync(String resourceGroupName, String serverName, ServerUpgradeStartParameters parameters);
}
