/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ServiceTierAdvisorGetResponse;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisorListResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on service tier advisors.
* Contains operations to: Retrieve.
*/
public interface ServiceTierAdvisorOperations {
    /**
    * Returns information about a service tier advisor.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @param serviceTierAdvisorName Required. The name of service tier advisor.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a get service tier advisor request.
    */
    ServiceTierAdvisorGetResponse get(String resourceGroupName, String serverName, String databaseName, String serviceTierAdvisorName) throws IOException, ServiceException;
    
    /**
    * Returns information about a service tier advisor.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @param serviceTierAdvisorName Required. The name of service tier advisor.
    * @return Represents the response to a get service tier advisor request.
    */
    Future<ServiceTierAdvisorGetResponse> getAsync(String resourceGroupName, String serverName, String databaseName, String serviceTierAdvisorName);
    
    /**
    * Returns information about service tier advisors for specified database.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a list service tier advisor request.
    */
    ServiceTierAdvisorListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns information about service tier advisors for specified database.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @return Represents the response to a list service tier advisor request.
    */
    Future<ServiceTierAdvisorListResponse> listAsync(String resourceGroupName, String serverName, String databaseName);
}
