/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisorGetResponse;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisorListResponse;
import com.microsoft.azure.management.sql.models.ServiceTierAdvisorProperties;
import com.microsoft.azure.management.sql.models.SloUsageMetric;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on service tier advisors.
* Contains operations to: Retrieve.
*/
public class ServiceTierAdvisorOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, ServiceTierAdvisorOperations {
    /**
    * Initializes a new instance of the ServiceTierAdvisorOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ServiceTierAdvisorOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Returns information about a service tier advisor.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @param serviceTierAdvisorName Required. The name of service tier advisor.
    * @return Represents the response to a get service tier advisor request.
    */
    @Override
    public Future<ServiceTierAdvisorGetResponse> getAsync(final String resourceGroupName, final String serverName, final String databaseName, final String serviceTierAdvisorName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceTierAdvisorGetResponse>() { 
            @Override
            public ServiceTierAdvisorGetResponse call() throws Exception {
                return get(resourceGroupName, serverName, databaseName, serviceTierAdvisorName);
            }
         });
    }
    
    /**
    * Returns information about a service tier advisor.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @param serviceTierAdvisorName Required. The name of service tier advisor.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a get service tier advisor request.
    */
    @Override
    public ServiceTierAdvisorGetResponse get(String resourceGroupName, String serverName, String databaseName, String serviceTierAdvisorName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (serviceTierAdvisorName == null) {
            throw new NullPointerException("serviceTierAdvisorName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("serviceTierAdvisorName", serviceTierAdvisorName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/serviceTierAdvisors/";
        url = url + URLEncoder.encode(serviceTierAdvisorName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceTierAdvisorGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceTierAdvisorGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                    result.setServiceTierAdvisor(serviceTierAdvisorInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        ServiceTierAdvisorProperties propertiesInstance = new ServiceTierAdvisorProperties();
                        serviceTierAdvisorInstance.setProperties(propertiesInstance);
                        
                        JsonNode observationPeriodStartValue = propertiesValue.get("observationPeriodStart");
                        if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                            Calendar observationPeriodStartInstance;
                            observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                            propertiesInstance.setObservationPeriodStart(observationPeriodStartInstance);
                        }
                        
                        JsonNode observationPeriodEndValue = propertiesValue.get("observationPeriodEnd");
                        if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                            Calendar observationPeriodEndInstance;
                            observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                            propertiesInstance.setObservationPeriodEnd(observationPeriodEndInstance);
                        }
                        
                        JsonNode activeTimeRatioValue = propertiesValue.get("activeTimeRatio");
                        if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                            double activeTimeRatioInstance;
                            activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                            propertiesInstance.setActiveTimeRatio(activeTimeRatioInstance);
                        }
                        
                        JsonNode minDtuValue = propertiesValue.get("minDtu");
                        if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                            double minDtuInstance;
                            minDtuInstance = minDtuValue.getDoubleValue();
                            propertiesInstance.setMinDtu(minDtuInstance);
                        }
                        
                        JsonNode avgDtuValue = propertiesValue.get("avgDtu");
                        if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                            double avgDtuInstance;
                            avgDtuInstance = avgDtuValue.getDoubleValue();
                            propertiesInstance.setAvgDtu(avgDtuInstance);
                        }
                        
                        JsonNode maxDtuValue = propertiesValue.get("maxDtu");
                        if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                            double maxDtuInstance;
                            maxDtuInstance = maxDtuValue.getDoubleValue();
                            propertiesInstance.setMaxDtu(maxDtuInstance);
                        }
                        
                        JsonNode maxSizeInGBValue = propertiesValue.get("maxSizeInGB");
                        if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                            double maxSizeInGBInstance;
                            maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                            propertiesInstance.setMaxSizeInGB(maxSizeInGBInstance);
                        }
                        
                        JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue.get("serviceLevelObjectiveUsageMetrics");
                        if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                            for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                propertiesInstance.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                
                                JsonNode serviceLevelObjectiveValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                    String serviceLevelObjectiveInstance;
                                    serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                    sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance);
                                }
                                
                                JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String serviceLevelObjectiveIdInstance;
                                    serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                    sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                    double inRangeTimeRatioInstance;
                                    inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                    sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                }
                                
                                JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    sloUsageMetricInstance.setId(idInstance);
                                }
                                
                                JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    sloUsageMetricInstance.setName(nameInstance);
                                }
                                
                                JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    String typeInstance;
                                    typeInstance = typeValue.getTextValue();
                                    sloUsageMetricInstance.setType(typeInstance);
                                }
                                
                                JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                if (locationValue != null && locationValue instanceof NullNode == false) {
                                    String locationInstance;
                                    locationInstance = locationValue.getTextValue();
                                    sloUsageMetricInstance.setLocation(locationInstance);
                                }
                                
                                JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry<String, JsonNode> property = itr.next();
                                        String tagsKey = property.getKey();
                                        String tagsValue = property.getValue().getTextValue();
                                        sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                    }
                                }
                            }
                        }
                        
                        JsonNode currentServiceLevelObjectiveValue = propertiesValue.get("currentServiceLevelObjective");
                        if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                            String currentServiceLevelObjectiveInstance;
                            currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                        }
                        
                        JsonNode currentServiceLevelObjectiveIdValue = propertiesValue.get("currentServiceLevelObjectiveId");
                        if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                            String currentServiceLevelObjectiveIdInstance;
                            currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                            propertiesInstance.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                        }
                        
                        JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("usageBasedRecommendationServiceLevelObjective");
                        if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                            String usageBasedRecommendationServiceLevelObjectiveInstance;
                            usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                        }
                        
                        JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("usageBasedRecommendationServiceLevelObjectiveId");
                        if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                            String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                            usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                            propertiesInstance.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                        }
                        
                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("databaseSizeBasedRecommendationServiceLevelObjective");
                        if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                            String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                            databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                        }
                        
                        JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                        if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                            String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                            databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                            propertiesInstance.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                        }
                        
                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("disasterPlanBasedRecommendationServiceLevelObjective");
                        if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                            String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                            disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                        }
                        
                        JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                        if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                            String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                            disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                            propertiesInstance.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                        }
                        
                        JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue.get("overallRecommendationServiceLevelObjective");
                        if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                            String overallRecommendationServiceLevelObjectiveInstance;
                            overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                            propertiesInstance.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                        }
                        
                        JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("overallRecommendationServiceLevelObjectiveId");
                        if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                            String overallRecommendationServiceLevelObjectiveIdInstance;
                            overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                            propertiesInstance.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                        }
                        
                        JsonNode confidenceValue = propertiesValue.get("confidence");
                        if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                            double confidenceInstance;
                            confidenceInstance = confidenceValue.getDoubleValue();
                            propertiesInstance.setConfidence(confidenceInstance);
                        }
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        serviceTierAdvisorInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        serviceTierAdvisorInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue2 = responseDoc.get("type");
                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                        String typeInstance2;
                        typeInstance2 = typeValue2.getTextValue();
                        serviceTierAdvisorInstance.setType(typeInstance2);
                    }
                    
                    JsonNode locationValue2 = responseDoc.get("location");
                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                        String locationInstance2;
                        locationInstance2 = locationValue2.getTextValue();
                        serviceTierAdvisorInstance.setLocation(locationInstance2);
                    }
                    
                    JsonNode tagsSequenceElement2 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry<String, JsonNode> property2 = itr2.next();
                            String tagsKey2 = property2.getKey();
                            String tagsValue2 = property2.getValue().getTextValue();
                            serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about service tier advisors for specified database.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @return Represents the response to a list service tier advisor request.
    */
    @Override
    public Future<ServiceTierAdvisorListResponse> listAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceTierAdvisorListResponse>() { 
            @Override
            public ServiceTierAdvisorListResponse call() throws Exception {
                return list(resourceGroupName, serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns information about service tier advisors for specified database.
    *
    * @param resourceGroupName Required. The name of the Resource Group.
    * @param serverName Required. The name of server.
    * @param databaseName Required. The name of database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a list service tier advisor request.
    */
    @Override
    public ServiceTierAdvisorListResponse list(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Sql";
        url = url + "/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/serviceTierAdvisors";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceTierAdvisorListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceTierAdvisorListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ServiceTierAdvisor serviceTierAdvisorInstance = new ServiceTierAdvisor();
                            result.getServiceTierAdvisors().add(serviceTierAdvisorInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ServiceTierAdvisorProperties propertiesInstance = new ServiceTierAdvisorProperties();
                                serviceTierAdvisorInstance.setProperties(propertiesInstance);
                                
                                JsonNode observationPeriodStartValue = propertiesValue.get("observationPeriodStart");
                                if (observationPeriodStartValue != null && observationPeriodStartValue instanceof NullNode == false) {
                                    Calendar observationPeriodStartInstance;
                                    observationPeriodStartInstance = DatatypeConverter.parseDateTime(observationPeriodStartValue.getTextValue());
                                    propertiesInstance.setObservationPeriodStart(observationPeriodStartInstance);
                                }
                                
                                JsonNode observationPeriodEndValue = propertiesValue.get("observationPeriodEnd");
                                if (observationPeriodEndValue != null && observationPeriodEndValue instanceof NullNode == false) {
                                    Calendar observationPeriodEndInstance;
                                    observationPeriodEndInstance = DatatypeConverter.parseDateTime(observationPeriodEndValue.getTextValue());
                                    propertiesInstance.setObservationPeriodEnd(observationPeriodEndInstance);
                                }
                                
                                JsonNode activeTimeRatioValue = propertiesValue.get("activeTimeRatio");
                                if (activeTimeRatioValue != null && activeTimeRatioValue instanceof NullNode == false) {
                                    double activeTimeRatioInstance;
                                    activeTimeRatioInstance = activeTimeRatioValue.getDoubleValue();
                                    propertiesInstance.setActiveTimeRatio(activeTimeRatioInstance);
                                }
                                
                                JsonNode minDtuValue = propertiesValue.get("minDtu");
                                if (minDtuValue != null && minDtuValue instanceof NullNode == false) {
                                    double minDtuInstance;
                                    minDtuInstance = minDtuValue.getDoubleValue();
                                    propertiesInstance.setMinDtu(minDtuInstance);
                                }
                                
                                JsonNode avgDtuValue = propertiesValue.get("avgDtu");
                                if (avgDtuValue != null && avgDtuValue instanceof NullNode == false) {
                                    double avgDtuInstance;
                                    avgDtuInstance = avgDtuValue.getDoubleValue();
                                    propertiesInstance.setAvgDtu(avgDtuInstance);
                                }
                                
                                JsonNode maxDtuValue = propertiesValue.get("maxDtu");
                                if (maxDtuValue != null && maxDtuValue instanceof NullNode == false) {
                                    double maxDtuInstance;
                                    maxDtuInstance = maxDtuValue.getDoubleValue();
                                    propertiesInstance.setMaxDtu(maxDtuInstance);
                                }
                                
                                JsonNode maxSizeInGBValue = propertiesValue.get("maxSizeInGB");
                                if (maxSizeInGBValue != null && maxSizeInGBValue instanceof NullNode == false) {
                                    double maxSizeInGBInstance;
                                    maxSizeInGBInstance = maxSizeInGBValue.getDoubleValue();
                                    propertiesInstance.setMaxSizeInGB(maxSizeInGBInstance);
                                }
                                
                                JsonNode serviceLevelObjectiveUsageMetricsArray = propertiesValue.get("serviceLevelObjectiveUsageMetrics");
                                if (serviceLevelObjectiveUsageMetricsArray != null && serviceLevelObjectiveUsageMetricsArray instanceof NullNode == false) {
                                    for (JsonNode serviceLevelObjectiveUsageMetricsValue : ((ArrayNode) serviceLevelObjectiveUsageMetricsArray)) {
                                        SloUsageMetric sloUsageMetricInstance = new SloUsageMetric();
                                        propertiesInstance.getServiceLevelObjectiveUsageMetrics().add(sloUsageMetricInstance);
                                        
                                        JsonNode serviceLevelObjectiveValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjective");
                                        if (serviceLevelObjectiveValue != null && serviceLevelObjectiveValue instanceof NullNode == false) {
                                            String serviceLevelObjectiveInstance;
                                            serviceLevelObjectiveInstance = serviceLevelObjectiveValue.getTextValue();
                                            sloUsageMetricInstance.setServiceLevelObjective(serviceLevelObjectiveInstance);
                                        }
                                        
                                        JsonNode serviceLevelObjectiveIdValue = serviceLevelObjectiveUsageMetricsValue.get("serviceLevelObjectiveId");
                                        if (serviceLevelObjectiveIdValue != null && serviceLevelObjectiveIdValue instanceof NullNode == false) {
                                            String serviceLevelObjectiveIdInstance;
                                            serviceLevelObjectiveIdInstance = serviceLevelObjectiveIdValue.getTextValue();
                                            sloUsageMetricInstance.setServiceLevelObjectiveId(serviceLevelObjectiveIdInstance);
                                        }
                                        
                                        JsonNode inRangeTimeRatioValue = serviceLevelObjectiveUsageMetricsValue.get("inRangeTimeRatio");
                                        if (inRangeTimeRatioValue != null && inRangeTimeRatioValue instanceof NullNode == false) {
                                            double inRangeTimeRatioInstance;
                                            inRangeTimeRatioInstance = inRangeTimeRatioValue.getDoubleValue();
                                            sloUsageMetricInstance.setInRangeTimeRatio(inRangeTimeRatioInstance);
                                        }
                                        
                                        JsonNode idValue = serviceLevelObjectiveUsageMetricsValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            sloUsageMetricInstance.setId(idInstance);
                                        }
                                        
                                        JsonNode nameValue = serviceLevelObjectiveUsageMetricsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            sloUsageMetricInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode typeValue = serviceLevelObjectiveUsageMetricsValue.get("type");
                                        if (typeValue != null && typeValue instanceof NullNode == false) {
                                            String typeInstance;
                                            typeInstance = typeValue.getTextValue();
                                            sloUsageMetricInstance.setType(typeInstance);
                                        }
                                        
                                        JsonNode locationValue = serviceLevelObjectiveUsageMetricsValue.get("location");
                                        if (locationValue != null && locationValue instanceof NullNode == false) {
                                            String locationInstance;
                                            locationInstance = locationValue.getTextValue();
                                            sloUsageMetricInstance.setLocation(locationInstance);
                                        }
                                        
                                        JsonNode tagsSequenceElement = ((JsonNode) serviceLevelObjectiveUsageMetricsValue.get("tags"));
                                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String tagsKey = property.getKey();
                                                String tagsValue = property.getValue().getTextValue();
                                                sloUsageMetricInstance.getTags().put(tagsKey, tagsValue);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode currentServiceLevelObjectiveValue = propertiesValue.get("currentServiceLevelObjective");
                                if (currentServiceLevelObjectiveValue != null && currentServiceLevelObjectiveValue instanceof NullNode == false) {
                                    String currentServiceLevelObjectiveInstance;
                                    currentServiceLevelObjectiveInstance = currentServiceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setCurrentServiceLevelObjective(currentServiceLevelObjectiveInstance);
                                }
                                
                                JsonNode currentServiceLevelObjectiveIdValue = propertiesValue.get("currentServiceLevelObjectiveId");
                                if (currentServiceLevelObjectiveIdValue != null && currentServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String currentServiceLevelObjectiveIdInstance;
                                    currentServiceLevelObjectiveIdInstance = currentServiceLevelObjectiveIdValue.getTextValue();
                                    propertiesInstance.setCurrentServiceLevelObjectiveId(currentServiceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode usageBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("usageBasedRecommendationServiceLevelObjective");
                                if (usageBasedRecommendationServiceLevelObjectiveValue != null && usageBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                    String usageBasedRecommendationServiceLevelObjectiveInstance;
                                    usageBasedRecommendationServiceLevelObjectiveInstance = usageBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setUsageBasedRecommendationServiceLevelObjective(usageBasedRecommendationServiceLevelObjectiveInstance);
                                }
                                
                                JsonNode usageBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("usageBasedRecommendationServiceLevelObjectiveId");
                                if (usageBasedRecommendationServiceLevelObjectiveIdValue != null && usageBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String usageBasedRecommendationServiceLevelObjectiveIdInstance;
                                    usageBasedRecommendationServiceLevelObjectiveIdInstance = usageBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                    propertiesInstance.setUsageBasedRecommendationServiceLevelObjectiveId(usageBasedRecommendationServiceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("databaseSizeBasedRecommendationServiceLevelObjective");
                                if (databaseSizeBasedRecommendationServiceLevelObjectiveValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                    String databaseSizeBasedRecommendationServiceLevelObjectiveInstance;
                                    databaseSizeBasedRecommendationServiceLevelObjectiveInstance = databaseSizeBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setDatabaseSizeBasedRecommendationServiceLevelObjective(databaseSizeBasedRecommendationServiceLevelObjectiveInstance);
                                }
                                
                                JsonNode databaseSizeBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("databaseSizeBasedRecommendationServiceLevelObjectiveId");
                                if (databaseSizeBasedRecommendationServiceLevelObjectiveIdValue != null && databaseSizeBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance;
                                    databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                    propertiesInstance.setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(databaseSizeBasedRecommendationServiceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveValue = propertiesValue.get("disasterPlanBasedRecommendationServiceLevelObjective");
                                if (disasterPlanBasedRecommendationServiceLevelObjectiveValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                    String disasterPlanBasedRecommendationServiceLevelObjectiveInstance;
                                    disasterPlanBasedRecommendationServiceLevelObjectiveInstance = disasterPlanBasedRecommendationServiceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setDisasterPlanBasedRecommendationServiceLevelObjective(disasterPlanBasedRecommendationServiceLevelObjectiveInstance);
                                }
                                
                                JsonNode disasterPlanBasedRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("disasterPlanBasedRecommendationServiceLevelObjectiveId");
                                if (disasterPlanBasedRecommendationServiceLevelObjectiveIdValue != null && disasterPlanBasedRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance;
                                    disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                    propertiesInstance.setDisasterPlanBasedRecommendationServiceLevelObjectiveId(disasterPlanBasedRecommendationServiceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode overallRecommendationServiceLevelObjectiveValue = propertiesValue.get("overallRecommendationServiceLevelObjective");
                                if (overallRecommendationServiceLevelObjectiveValue != null && overallRecommendationServiceLevelObjectiveValue instanceof NullNode == false) {
                                    String overallRecommendationServiceLevelObjectiveInstance;
                                    overallRecommendationServiceLevelObjectiveInstance = overallRecommendationServiceLevelObjectiveValue.getTextValue();
                                    propertiesInstance.setOverallRecommendationServiceLevelObjective(overallRecommendationServiceLevelObjectiveInstance);
                                }
                                
                                JsonNode overallRecommendationServiceLevelObjectiveIdValue = propertiesValue.get("overallRecommendationServiceLevelObjectiveId");
                                if (overallRecommendationServiceLevelObjectiveIdValue != null && overallRecommendationServiceLevelObjectiveIdValue instanceof NullNode == false) {
                                    String overallRecommendationServiceLevelObjectiveIdInstance;
                                    overallRecommendationServiceLevelObjectiveIdInstance = overallRecommendationServiceLevelObjectiveIdValue.getTextValue();
                                    propertiesInstance.setOverallRecommendationServiceLevelObjectiveId(overallRecommendationServiceLevelObjectiveIdInstance);
                                }
                                
                                JsonNode confidenceValue = propertiesValue.get("confidence");
                                if (confidenceValue != null && confidenceValue instanceof NullNode == false) {
                                    double confidenceInstance;
                                    confidenceInstance = confidenceValue.getDoubleValue();
                                    propertiesInstance.setConfidence(confidenceInstance);
                                }
                            }
                            
                            JsonNode idValue2 = valueValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                serviceTierAdvisorInstance.setId(idInstance2);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                serviceTierAdvisorInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue2 = valueValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                serviceTierAdvisorInstance.setType(typeInstance2);
                            }
                            
                            JsonNode locationValue2 = valueValue.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                serviceTierAdvisorInstance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey2 = property2.getKey();
                                    String tagsValue2 = property2.getValue().getTextValue();
                                    serviceTierAdvisorInstance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
