/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.sql.models.TransparentDataEncryptionActivityListResponse;
import com.microsoft.azure.management.sql.models.TransparentDataEncryptionCreateOrUpdateParameters;
import com.microsoft.azure.management.sql.models.TransparentDataEncryptionGetResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Represents all the operations of Azure SQL Database Transparent Data
* Encryption.  Contains operations to: Retrieve, and Update Transparent Data
* Encryption.
*/
public interface TransparentDataEncryptionOperations {
    /**
    * Creates or updates an Azure SQL Database Transparent Data Encryption
    * Operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which setting the Transparent Data Encryption applies.
    * @param parameters Required. The required parameters for creating or
    * updating transparent data encryption.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get for a Azure Sql Database
    * Transparent Data Encryption request.
    */
    TransparentDataEncryptionGetResponse createOrUpdate(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionCreateOrUpdateParameters parameters) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Creates or updates an Azure SQL Database Transparent Data Encryption
    * Operation.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which setting the Transparent Data Encryption applies.
    * @param parameters Required. The required parameters for creating or
    * updating transparent data encryption.
    * @return Represents the response to a Get for a Azure Sql Database
    * Transparent Data Encryption request.
    */
    Future<TransparentDataEncryptionGetResponse> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionCreateOrUpdateParameters parameters);
    
    /**
    * Returns an Azure SQL Database Transparent Data Encryption Response.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the Transparent Data Encryption applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a Get for a Azure Sql Database
    * Transparent Data Encryption request.
    */
    TransparentDataEncryptionGetResponse get(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Database Transparent Data Encryption Response.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the Transparent Data Encryption applies.
    * @return Represents the response to a Get for a Azure Sql Database
    * Transparent Data Encryption request.
    */
    Future<TransparentDataEncryptionGetResponse> getAsync(String resourceGroupName, String serverName, String databaseName);
    
    /**
    * Returns an Azure SQL Database Transparent Data Encryption Activity
    * Response.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the Transparent Data Encryption applies.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a List Azure Sql Database Transparent
    * Data Encryption Activity request.
    */
    TransparentDataEncryptionActivityListResponse listActivity(String resourceGroupName, String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Returns an Azure SQL Database Transparent Data Encryption Activity
    * Response.
    *
    * @param resourceGroupName Required. The name of the Resource Group to
    * which the server belongs.
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database for
    * which the Transparent Data Encryption applies.
    * @return Represents the response to a List Azure Sql Database Transparent
    * Data Encryption Activity request.
    */
    Future<TransparentDataEncryptionActivityListResponse> listActivityAsync(String resourceGroupName, String serverName, String databaseName);
}
