/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

/**
* Represents the properties of an Azure SQL Database data masking policy.
*/
public class DataMaskingPolicyProperties {
    private String dataMaskingState;
    
    /**
    * Required. Gets or sets the state of the data masking policy.
    * @return The DataMaskingState value.
    */
    public String getDataMaskingState() {
        return this.dataMaskingState;
    }
    
    /**
    * Required. Gets or sets the state of the data masking policy.
    * @param dataMaskingStateValue The DataMaskingState value.
    */
    public void setDataMaskingState(final String dataMaskingStateValue) {
        this.dataMaskingState = dataMaskingStateValue;
    }
    
    private String exemptPrincipals;
    
    /**
    * Required. Gets or sets the list of the exempt principals
    * @return The ExemptPrincipals value.
    */
    public String getExemptPrincipals() {
        return this.exemptPrincipals;
    }
    
    /**
    * Required. Gets or sets the list of the exempt principals
    * @param exemptPrincipalsValue The ExemptPrincipals value.
    */
    public void setExemptPrincipals(final String exemptPrincipalsValue) {
        this.exemptPrincipals = exemptPrincipalsValue;
    }
    
    /**
    * Initializes a new instance of the DataMaskingPolicyProperties class.
    *
    */
    public DataMaskingPolicyProperties() {
    }
    
    /**
    * Initializes a new instance of the DataMaskingPolicyProperties class with
    * required arguments.
    *
    * @param dataMaskingState Gets or sets the state of the data masking policy.
    * @param exemptPrincipals Gets or sets the list of the exempt principals
    */
    public DataMaskingPolicyProperties(String dataMaskingState, String exemptPrincipals) {
        if (dataMaskingState == null) {
            throw new NullPointerException("dataMaskingState");
        }
        if (exemptPrincipals == null) {
            throw new NullPointerException("exemptPrincipals");
        }
        this.setDataMaskingState(dataMaskingState);
        this.setExemptPrincipals(exemptPrincipals);
    }
}
