/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

/**
* Create or update Azure Sql Database parameters properties.
*/
public class DatabaseCreateOrUpdateProperties {
    private String collation;
    
    /**
    * Optional. Gets or sets the collation of the Azure Sql Database being
    * created.  You cannot change change the collation of an existing Azure
    * Sql Database.
    * @return The Collation value.
    */
    public String getCollation() {
        return this.collation;
    }
    
    /**
    * Optional. Gets or sets the collation of the Azure Sql Database being
    * created.  You cannot change change the collation of an existing Azure
    * Sql Database.
    * @param collationValue The Collation value.
    */
    public void setCollation(final String collationValue) {
        this.collation = collationValue;
    }
    
    private String createMode;
    
    /**
    * Optional. Gets or sets the create Mode for the Azure Sql Database
    * database being created.
    * @return The CreateMode value.
    */
    public String getCreateMode() {
        return this.createMode;
    }
    
    /**
    * Optional. Gets or sets the create Mode for the Azure Sql Database
    * database being created.
    * @param createModeValue The CreateMode value.
    */
    public void setCreateMode(final String createModeValue) {
        this.createMode = createModeValue;
    }
    
    private String edition;
    
    /**
    * Optional. Gets or sets the edition for the Azure Sql Database being
    * updated or created.
    * @return The Edition value.
    */
    public String getEdition() {
        return this.edition;
    }
    
    /**
    * Optional. Gets or sets the edition for the Azure Sql Database being
    * updated or created.
    * @param editionValue The Edition value.
    */
    public void setEdition(final String editionValue) {
        this.edition = editionValue;
    }
    
    private String elasticPoolName;
    
    /**
    * Optional. Gets or sets the name of the Elastic Pool to put the Azure Sql
    * Database in.
    * @return The ElasticPoolName value.
    */
    public String getElasticPoolName() {
        return this.elasticPoolName;
    }
    
    /**
    * Optional. Gets or sets the name of the Elastic Pool to put the Azure Sql
    * Database in.
    * @param elasticPoolNameValue The ElasticPoolName value.
    */
    public void setElasticPoolName(final String elasticPoolNameValue) {
        this.elasticPoolName = elasticPoolNameValue;
    }
    
    private Long maxSizeBytes;
    
    /**
    * Optional. Gets or sets the maximum size of the Azure Sql Database being
    * created or updated in bytes.
    * @return The MaxSizeBytes value.
    */
    public Long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }
    
    /**
    * Optional. Gets or sets the maximum size of the Azure Sql Database being
    * created or updated in bytes.
    * @param maxSizeBytesValue The MaxSizeBytes value.
    */
    public void setMaxSizeBytes(final Long maxSizeBytesValue) {
        this.maxSizeBytes = maxSizeBytesValue;
    }
    
    private String requestedServiceObjectiveId;
    
    /**
    * Optional. Gets or sets the service objective to be applied to the Azure
    * Sql Database being created or updated.
    * @return The RequestedServiceObjectiveId value.
    */
    public String getRequestedServiceObjectiveId() {
        return this.requestedServiceObjectiveId;
    }
    
    /**
    * Optional. Gets or sets the service objective to be applied to the Azure
    * Sql Database being created or updated.
    * @param requestedServiceObjectiveIdValue The RequestedServiceObjectiveId
    * value.
    */
    public void setRequestedServiceObjectiveId(final String requestedServiceObjectiveIdValue) {
        this.requestedServiceObjectiveId = requestedServiceObjectiveIdValue;
    }
    
    private String requestedServiceObjectiveName;
    
    /**
    * Optional. Gets or sets the service objective to be applied to the Azure
    * Sql Database being created or updated.
    * @return The RequestedServiceObjectiveName value.
    */
    public String getRequestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }
    
    /**
    * Optional. Gets or sets the service objective to be applied to the Azure
    * Sql Database being created or updated.
    * @param requestedServiceObjectiveNameValue The
    * RequestedServiceObjectiveName value.
    */
    public void setRequestedServiceObjectiveName(final String requestedServiceObjectiveNameValue) {
        this.requestedServiceObjectiveName = requestedServiceObjectiveNameValue;
    }
    
    private String sourceDatabaseId;
    
    /**
    * Optional. Gets or sets the resource id of the database to use as the
    * source for the copy being created.
    * @return The SourceDatabaseId value.
    */
    public String getSourceDatabaseId() {
        return this.sourceDatabaseId;
    }
    
    /**
    * Optional. Gets or sets the resource id of the database to use as the
    * source for the copy being created.
    * @param sourceDatabaseIdValue The SourceDatabaseId value.
    */
    public void setSourceDatabaseId(final String sourceDatabaseIdValue) {
        this.sourceDatabaseId = sourceDatabaseIdValue;
    }
}
