/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import java.util.Calendar;

/**
* Represents Azure SQL Database metrics.
*/
public class DatabaseMetric {
    private double currentValue;
    
    /**
    * Optional. Gets or sets the current value of the metric.
    * @return The CurrentValue value.
    */
    public double getCurrentValue() {
        return this.currentValue;
    }
    
    /**
    * Optional. Gets or sets the current value of the metric.
    * @param currentValueValue The CurrentValue value.
    */
    public void setCurrentValue(final double currentValueValue) {
        this.currentValue = currentValueValue;
    }
    
    private String displayName;
    
    /**
    * Optional. Gets or sets the metric display name.
    * @return The DisplayName value.
    */
    public String getDisplayName() {
        return this.displayName;
    }
    
    /**
    * Optional. Gets or sets the metric display name.
    * @param displayNameValue The DisplayName value.
    */
    public void setDisplayName(final String displayNameValue) {
        this.displayName = displayNameValue;
    }
    
    private double limit;
    
    /**
    * Optional. Gets or sets the current limit of the metric.
    * @return The Limit value.
    */
    public double getLimit() {
        return this.limit;
    }
    
    /**
    * Optional. Gets or sets the current limit of the metric.
    * @param limitValue The Limit value.
    */
    public void setLimit(final double limitValue) {
        this.limit = limitValue;
    }
    
    private Calendar nextResetTime;
    
    /**
    * Optional. Gets or sets the next reset time for the metric.
    * @return The NextResetTime value.
    */
    public Calendar getNextResetTime() {
        return this.nextResetTime;
    }
    
    /**
    * Optional. Gets or sets the next reset time for the metric.
    * @param nextResetTimeValue The NextResetTime value.
    */
    public void setNextResetTime(final Calendar nextResetTimeValue) {
        this.nextResetTime = nextResetTimeValue;
    }
    
    private String resourceName;
    
    /**
    * Optional. Gets or sets the name of the resource.
    * @return The ResourceName value.
    */
    public String getResourceName() {
        return this.resourceName;
    }
    
    /**
    * Optional. Gets or sets the name of the resource.
    * @param resourceNameValue The ResourceName value.
    */
    public void setResourceName(final String resourceNameValue) {
        this.resourceName = resourceNameValue;
    }
    
    private String unit;
    
    /**
    * Optional. Gets or sets the units of the metric.
    * @return The Unit value.
    */
    public String getUnit() {
        return this.unit;
    }
    
    /**
    * Optional. Gets or sets the units of the metric.
    * @param unitValue The Unit value.
    */
    public void setUnit(final String unitValue) {
        this.unit = unitValue;
    }
}
