/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Represents the response to a List Azure Sql Elastic Pool Database Activity
* request.
*/
public class ElasticPoolDatabaseActivityListResponse extends OperationResponse implements Iterable<ElasticPoolDatabaseActivity> {
    private ArrayList<ElasticPoolDatabaseActivity> elasticPoolDatabaseActivities;
    
    /**
    * Optional. Gets or sets the list of Azure Sql Elastic Pool Database
    * Activities.
    * @return The ElasticPoolDatabaseActivities value.
    */
    public ArrayList<ElasticPoolDatabaseActivity> getElasticPoolDatabaseActivities() {
        return this.elasticPoolDatabaseActivities;
    }
    
    /**
    * Optional. Gets or sets the list of Azure Sql Elastic Pool Database
    * Activities.
    * @param elasticPoolDatabaseActivitiesValue The
    * ElasticPoolDatabaseActivities value.
    */
    public void setElasticPoolDatabaseActivities(final ArrayList<ElasticPoolDatabaseActivity> elasticPoolDatabaseActivitiesValue) {
        this.elasticPoolDatabaseActivities = elasticPoolDatabaseActivitiesValue;
    }
    
    /**
    * Initializes a new instance of the ElasticPoolDatabaseActivityListResponse
    * class.
    *
    */
    public ElasticPoolDatabaseActivityListResponse() {
        super();
        this.setElasticPoolDatabaseActivities(new LazyArrayList<ElasticPoolDatabaseActivity>());
    }
    
    /**
    * Gets the sequence of ElasticPoolDatabaseActivities.
    *
    */
    public Iterator<ElasticPoolDatabaseActivity> iterator() {
        return this.getElasticPoolDatabaseActivities().iterator();
    }
}
