/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import java.util.Calendar;

/**
* Represents the properties of an Azure SQL Database Elastic Pool.
*/
public class ElasticPoolProperties {
    private Calendar creationDate;
    
    /**
    * Optional. Gets the creation date of the Azure SQL Database Elastic Pool.
    * @return The CreationDate value.
    */
    public Calendar getCreationDate() {
        return this.creationDate;
    }
    
    /**
    * Optional. Gets the creation date of the Azure SQL Database Elastic Pool.
    * @param creationDateValue The CreationDate value.
    */
    public void setCreationDate(final Calendar creationDateValue) {
        this.creationDate = creationDateValue;
    }
    
    private int databaseDtuMax;
    
    /**
    * Optional. Gets the maximum DTU any one Sql Azure Database can consume.
    * @return The DatabaseDtuMax value.
    */
    public int getDatabaseDtuMax() {
        return this.databaseDtuMax;
    }
    
    /**
    * Optional. Gets the maximum DTU any one Sql Azure Database can consume.
    * @param databaseDtuMaxValue The DatabaseDtuMax value.
    */
    public void setDatabaseDtuMax(final int databaseDtuMaxValue) {
        this.databaseDtuMax = databaseDtuMaxValue;
    }
    
    private int databaseDtuMin;
    
    /**
    * Optional. Gets the minimum DTU all Sql Azure Databases are guaranteed.
    * @return The DatabaseDtuMin value.
    */
    public int getDatabaseDtuMin() {
        return this.databaseDtuMin;
    }
    
    /**
    * Optional. Gets the minimum DTU all Sql Azure Databases are guaranteed.
    * @param databaseDtuMinValue The DatabaseDtuMin value.
    */
    public void setDatabaseDtuMin(final int databaseDtuMinValue) {
        this.databaseDtuMin = databaseDtuMinValue;
    }
    
    private int dtu;
    
    /**
    * Optional. Gets the total shared DTU for the Sql Azure Database Elastic
    * Pool.
    * @return The Dtu value.
    */
    public int getDtu() {
        return this.dtu;
    }
    
    /**
    * Optional. Gets the total shared DTU for the Sql Azure Database Elastic
    * Pool.
    * @param dtuValue The Dtu value.
    */
    public void setDtu(final int dtuValue) {
        this.dtu = dtuValue;
    }
    
    private String edition;
    
    /**
    * Optional. Gets the edition of the Azure SQL Database Elastic Pool.  The
    * DatabaseEditions enumeration contains all the valid editions.
    * @return The Edition value.
    */
    public String getEdition() {
        return this.edition;
    }
    
    /**
    * Optional. Gets the edition of the Azure SQL Database Elastic Pool.  The
    * DatabaseEditions enumeration contains all the valid editions.
    * @param editionValue The Edition value.
    */
    public void setEdition(final String editionValue) {
        this.edition = editionValue;
    }
    
    private String state;
    
    /**
    * Optional. Gets the state of the Azure SQL Database Elastic Pool.
    * @return The State value.
    */
    public String getState() {
        return this.state;
    }
    
    /**
    * Optional. Gets the state of the Azure SQL Database Elastic Pool.
    * @param stateValue The State value.
    */
    public void setState(final String stateValue) {
        this.state = stateValue;
    }
    
    private int storageMB;
    
    /**
    * Optional. Gets storage limit for the Sql Azure Database Elastic Pool in
    * MB.
    * @return The StorageMB value.
    */
    public int getStorageMB() {
        return this.storageMB;
    }
    
    /**
    * Optional. Gets storage limit for the Sql Azure Database Elastic Pool in
    * MB.
    * @param storageMBValue The StorageMB value.
    */
    public void setStorageMB(final int storageMBValue) {
        this.storageMB = storageMBValue;
    }
}
