/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Represents the Azure SQL capabilities for a region.
*/
public class LocationCapability {
    private String name;
    
    /**
    * Optional. Gets the region name.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets the region name.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String status;
    
    /**
    * Optional. Gets the status for the region with respect to Azure SQL.
    * @return The Status value.
    */
    public String getStatus() {
        return this.status;
    }
    
    /**
    * Optional. Gets the status for the region with respect to Azure SQL.
    * @param statusValue The Status value.
    */
    public void setStatus(final String statusValue) {
        this.status = statusValue;
    }
    
    private ArrayList<ServerVersionCapability> supportedServerVersions;
    
    /**
    * Optional. Gets the list of supported Azure SQL Server versions.
    * @return The SupportedServerVersions value.
    */
    public ArrayList<ServerVersionCapability> getSupportedServerVersions() {
        return this.supportedServerVersions;
    }
    
    /**
    * Optional. Gets the list of supported Azure SQL Server versions.
    * @param supportedServerVersionsValue The SupportedServerVersions value.
    */
    public void setSupportedServerVersions(final ArrayList<ServerVersionCapability> supportedServerVersionsValue) {
        this.supportedServerVersions = supportedServerVersionsValue;
    }
    
    /**
    * Initializes a new instance of the LocationCapability class.
    *
    */
    public LocationCapability() {
        this.setSupportedServerVersions(new LazyArrayList<ServerVersionCapability>());
    }
}
