/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* Represents an Azure SQL Database Elastic Pool metric.
*/
public class Metric {
    private Calendar endTime;
    
    /**
    * Optional. Gets or sets the end time for the metrics.
    * @return The EndTime value.
    */
    public Calendar getEndTime() {
        return this.endTime;
    }
    
    /**
    * Optional. Gets or sets the end time for the metrics.
    * @param endTimeValue The EndTime value.
    */
    public void setEndTime(final Calendar endTimeValue) {
        this.endTime = endTimeValue;
    }
    
    private Name name;
    
    /**
    * Optional. Gets or sets the units for the metric
    * @return The Name value.
    */
    public Name getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets the units for the metric
    * @param nameValue The Name value.
    */
    public void setName(final Name nameValue) {
        this.name = nameValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. Gets or sets the start time for the metrics.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. Gets or sets the start time for the metrics.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
    
    private String timeGrain;
    
    /**
    * Optional. Gets or sets the time grain for the metrics
    * @return The TimeGrain value.
    */
    public String getTimeGrain() {
        return this.timeGrain;
    }
    
    /**
    * Optional. Gets or sets the time grain for the metrics
    * @param timeGrainValue The TimeGrain value.
    */
    public void setTimeGrain(final String timeGrainValue) {
        this.timeGrain = timeGrainValue;
    }
    
    private String unit;
    
    /**
    * Optional. Gets or sets the units for the metric
    * @return The Unit value.
    */
    public String getUnit() {
        return this.unit;
    }
    
    /**
    * Optional. Gets or sets the units for the metric
    * @param unitValue The Unit value.
    */
    public void setUnit(final String unitValue) {
        this.unit = unitValue;
    }
    
    private ArrayList<Value> values;
    
    /**
    * Optional. Gets or sets the units for the metric
    * @return The Values value.
    */
    public ArrayList<Value> getValues() {
        return this.values;
    }
    
    /**
    * Optional. Gets or sets the units for the metric
    * @param valuesValue The Values value.
    */
    public void setValues(final ArrayList<Value> valuesValue) {
        this.values = valuesValue;
    }
    
    /**
    * Initializes a new instance of the Metric class.
    *
    */
    public Metric() {
        this.setValues(new LazyArrayList<Value>());
    }
}
