/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Represents an Azure SQL Database Elastic Pool metric definition.
*/
public class MetricDefinition {
    private ArrayList<MetricAvailability> metricAvailabilities;
    
    /**
    * Optional. Gets or sets the availabilities for the metric.
    * @return The MetricAvailabilities value.
    */
    public ArrayList<MetricAvailability> getMetricAvailabilities() {
        return this.metricAvailabilities;
    }
    
    /**
    * Optional. Gets or sets the availabilities for the metric.
    * @param metricAvailabilitiesValue The MetricAvailabilities value.
    */
    public void setMetricAvailabilities(final ArrayList<MetricAvailability> metricAvailabilitiesValue) {
        this.metricAvailabilities = metricAvailabilitiesValue;
    }
    
    private MetricName name;
    
    /**
    * Optional. Gets or sets the name for the metric
    * @return The Name value.
    */
    public MetricName getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets the name for the metric
    * @param nameValue The Name value.
    */
    public void setName(final MetricName nameValue) {
        this.name = nameValue;
    }
    
    private String primaryAggregationType;
    
    /**
    * Optional. Gets or sets the aggregation type for the metric.
    * @return The PrimaryAggregationType value.
    */
    public String getPrimaryAggregationType() {
        return this.primaryAggregationType;
    }
    
    /**
    * Optional. Gets or sets the aggregation type for the metric.
    * @param primaryAggregationTypeValue The PrimaryAggregationType value.
    */
    public void setPrimaryAggregationType(final String primaryAggregationTypeValue) {
        this.primaryAggregationType = primaryAggregationTypeValue;
    }
    
    private String unit;
    
    /**
    * Optional. Gets or sets the units for the metric
    * @return The Unit value.
    */
    public String getUnit() {
        return this.unit;
    }
    
    /**
    * Optional. Gets or sets the units for the metric
    * @param unitValue The Unit value.
    */
    public void setUnit(final String unitValue) {
        this.unit = unitValue;
    }
    
    /**
    * Initializes a new instance of the MetricDefinition class.
    *
    */
    public MetricDefinition() {
        this.setMetricAvailabilities(new LazyArrayList<MetricAvailability>());
    }
}
