/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* Represents an Azure SQL Recommended Elastic Pool.
*/
public class RecommendedElasticPool extends ResourceBaseExtended {
    private RecommendedElasticPoolProperties properties;
    
    /**
    * Optional. Gets or sets the properites representing the resource.
    * @return The Properties value.
    */
    public RecommendedElasticPoolProperties getProperties() {
        return this.properties;
    }
    
    /**
    * Optional. Gets or sets the properites representing the resource.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final RecommendedElasticPoolProperties propertiesValue) {
        this.properties = propertiesValue;
    }
    
    /**
    * Initializes a new instance of the RecommendedElasticPool class.
    *
    */
    public RecommendedElasticPool() {
        super();
    }
    
    /**
    * Initializes a new instance of the RecommendedElasticPool class with
    * required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public RecommendedElasticPool(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
