/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Represents the response to a List Azure Sql Recommended Elastic Pool request.
*/
public class RecommendedElasticPoolListResponse extends OperationResponse implements Iterable<RecommendedElasticPool> {
    private ArrayList<RecommendedElasticPool> recommendedElasticPools;
    
    /**
    * Optional. Gets or sets the list of Azure Sql Recommended Elastic Pools
    * hosted in the server.
    * @return The RecommendedElasticPools value.
    */
    public ArrayList<RecommendedElasticPool> getRecommendedElasticPools() {
        return this.recommendedElasticPools;
    }
    
    /**
    * Optional. Gets or sets the list of Azure Sql Recommended Elastic Pools
    * hosted in the server.
    * @param recommendedElasticPoolsValue The RecommendedElasticPools value.
    */
    public void setRecommendedElasticPools(final ArrayList<RecommendedElasticPool> recommendedElasticPoolsValue) {
        this.recommendedElasticPools = recommendedElasticPoolsValue;
    }
    
    /**
    * Initializes a new instance of the RecommendedElasticPoolListResponse
    * class.
    *
    */
    public RecommendedElasticPoolListResponse() {
        super();
        this.setRecommendedElasticPools(new LazyArrayList<RecommendedElasticPool>());
    }
    
    /**
    * Gets the sequence of RecommendedElasticPools.
    *
    */
    public Iterator<RecommendedElasticPool> iterator() {
        return this.getRecommendedElasticPools().iterator();
    }
}
