/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* Represents the properties of an Azure SQL Recommended Elastic Pool.
*/
public class RecommendedElasticPoolProperties {
    private double databaseDtuMax;
    
    /**
    * Optional. Gets the maximum DTU for the database.
    * @return The DatabaseDtuMax value.
    */
    public double getDatabaseDtuMax() {
        return this.databaseDtuMax;
    }
    
    /**
    * Optional. Gets the maximum DTU for the database.
    * @param databaseDtuMaxValue The DatabaseDtuMax value.
    */
    public void setDatabaseDtuMax(final double databaseDtuMaxValue) {
        this.databaseDtuMax = databaseDtuMaxValue;
    }
    
    private double databaseDtuMin;
    
    /**
    * Optional. Gets the minimum DTU for the database.
    * @return The DatabaseDtuMin value.
    */
    public double getDatabaseDtuMin() {
        return this.databaseDtuMin;
    }
    
    /**
    * Optional. Gets the minimum DTU for the database.
    * @param databaseDtuMinValue The DatabaseDtuMin value.
    */
    public void setDatabaseDtuMin(final double databaseDtuMinValue) {
        this.databaseDtuMin = databaseDtuMinValue;
    }
    
    private String databaseEdition;
    
    /**
    * Optional. Gets the edition of the Azure SQL Recommended Elastic Pool. The
    * DatabaseEditions enumeration contains all the valid editions.
    * @return The DatabaseEdition value.
    */
    public String getDatabaseEdition() {
        return this.databaseEdition;
    }
    
    /**
    * Optional. Gets the edition of the Azure SQL Recommended Elastic Pool. The
    * DatabaseEditions enumeration contains all the valid editions.
    * @param databaseEditionValue The DatabaseEdition value.
    */
    public void setDatabaseEdition(final String databaseEditionValue) {
        this.databaseEdition = databaseEditionValue;
    }
    
    private ArrayList<Database> databases;
    
    /**
    * Optional. Gets the list of Azure Sql Databases in this pool. Expanded
    * property
    * @return The Databases value.
    */
    public ArrayList<Database> getDatabases() {
        return this.databases;
    }
    
    /**
    * Optional. Gets the list of Azure Sql Databases in this pool. Expanded
    * property
    * @param databasesValue The Databases value.
    */
    public void setDatabases(final ArrayList<Database> databasesValue) {
        this.databases = databasesValue;
    }
    
    private double dtu;
    
    /**
    * Optional. Gets the DTU for the Sql Azure Recommended Elastic Pool.
    * @return The Dtu value.
    */
    public double getDtu() {
        return this.dtu;
    }
    
    /**
    * Optional. Gets the DTU for the Sql Azure Recommended Elastic Pool.
    * @param dtuValue The Dtu value.
    */
    public void setDtu(final double dtuValue) {
        this.dtu = dtuValue;
    }
    
    private double maxObservedDtu;
    
    /**
    * Optional. Gets maximum observed DTU.
    * @return The MaxObservedDtu value.
    */
    public double getMaxObservedDtu() {
        return this.maxObservedDtu;
    }
    
    /**
    * Optional. Gets maximum observed DTU.
    * @param maxObservedDtuValue The MaxObservedDtu value.
    */
    public void setMaxObservedDtu(final double maxObservedDtuValue) {
        this.maxObservedDtu = maxObservedDtuValue;
    }
    
    private double maxObservedStorageMB;
    
    /**
    * Optional. Gets maximum observed storage in megabytes.
    * @return The MaxObservedStorageMB value.
    */
    public double getMaxObservedStorageMB() {
        return this.maxObservedStorageMB;
    }
    
    /**
    * Optional. Gets maximum observed storage in megabytes.
    * @param maxObservedStorageMBValue The MaxObservedStorageMB value.
    */
    public void setMaxObservedStorageMB(final double maxObservedStorageMBValue) {
        this.maxObservedStorageMB = maxObservedStorageMBValue;
    }
    
    private ArrayList<RecommendedElasticPoolMetric> metrics;
    
    /**
    * Optional. Gets or sets the list of Azure Sql Databases housed in the
    * server. Expanded property
    * @return The Metrics value.
    */
    public ArrayList<RecommendedElasticPoolMetric> getMetrics() {
        return this.metrics;
    }
    
    /**
    * Optional. Gets or sets the list of Azure Sql Databases housed in the
    * server. Expanded property
    * @param metricsValue The Metrics value.
    */
    public void setMetrics(final ArrayList<RecommendedElasticPoolMetric> metricsValue) {
        this.metrics = metricsValue;
    }
    
    private Calendar observationPeriodEnd;
    
    /**
    * Optional. Gets the observation period start.
    * @return The ObservationPeriodEnd value.
    */
    public Calendar getObservationPeriodEnd() {
        return this.observationPeriodEnd;
    }
    
    /**
    * Optional. Gets the observation period start.
    * @param observationPeriodEndValue The ObservationPeriodEnd value.
    */
    public void setObservationPeriodEnd(final Calendar observationPeriodEndValue) {
        this.observationPeriodEnd = observationPeriodEndValue;
    }
    
    private Calendar observationPeriodStart;
    
    /**
    * Optional. Gets the observation period start.
    * @return The ObservationPeriodStart value.
    */
    public Calendar getObservationPeriodStart() {
        return this.observationPeriodStart;
    }
    
    /**
    * Optional. Gets the observation period start.
    * @param observationPeriodStartValue The ObservationPeriodStart value.
    */
    public void setObservationPeriodStart(final Calendar observationPeriodStartValue) {
        this.observationPeriodStart = observationPeriodStartValue;
    }
    
    private double storageMB;
    
    /**
    * Optional. Gets storage size in megabytes.
    * @return The StorageMB value.
    */
    public double getStorageMB() {
        return this.storageMB;
    }
    
    /**
    * Optional. Gets storage size in megabytes.
    * @param storageMBValue The StorageMB value.
    */
    public void setStorageMB(final double storageMBValue) {
        this.storageMB = storageMBValue;
    }
    
    /**
    * Initializes a new instance of the RecommendedElasticPoolProperties class.
    *
    */
    public RecommendedElasticPoolProperties() {
        this.setDatabases(new LazyArrayList<Database>());
        this.setMetrics(new LazyArrayList<RecommendedElasticPoolMetric>());
    }
}
