/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Represents the response to a List Azure Sql Database restore points request.
*/
public class RestorePointListResponse extends OperationResponse implements Iterable<RestorePoint> {
    private ArrayList<RestorePoint> restorePoints;
    
    /**
    * Optional. Gets or sets the list of a given Azure Sql Database restore
    * points.
    * @return The RestorePoints value.
    */
    public ArrayList<RestorePoint> getRestorePoints() {
        return this.restorePoints;
    }
    
    /**
    * Optional. Gets or sets the list of a given Azure Sql Database restore
    * points.
    * @param restorePointsValue The RestorePoints value.
    */
    public void setRestorePoints(final ArrayList<RestorePoint> restorePointsValue) {
        this.restorePoints = restorePointsValue;
    }
    
    /**
    * Initializes a new instance of the RestorePointListResponse class.
    *
    */
    public RestorePointListResponse() {
        super();
        this.setRestorePoints(new LazyArrayList<RestorePoint>());
    }
    
    /**
    * Gets the sequence of RestorePoints.
    *
    */
    public Iterator<RestorePoint> iterator() {
        return this.getRestorePoints().iterator();
    }
}
