/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import java.util.Calendar;

/**
* Represents the properties of an Azure SQL Database restore point.
*/
public class RestorePointProperties {
    private Calendar earliestRestoreDate;
    
    /**
    * Optional. Earliest restore time. Populated when restorePointType =
    * DISCRETE. Null otherwise.
    * @return The EarliestRestoreDate value.
    */
    public Calendar getEarliestRestoreDate() {
        return this.earliestRestoreDate;
    }
    
    /**
    * Optional. Earliest restore time. Populated when restorePointType =
    * DISCRETE. Null otherwise.
    * @param earliestRestoreDateValue The EarliestRestoreDate value.
    */
    public void setEarliestRestoreDate(final Calendar earliestRestoreDateValue) {
        this.earliestRestoreDate = earliestRestoreDateValue;
    }
    
    private Calendar restorePointCreationDate;
    
    /**
    * Optional. Restore point creation time. Populated when restorePointType =
    * CONTINUOUS. Null otherwise.
    * @return The RestorePointCreationDate value.
    */
    public Calendar getRestorePointCreationDate() {
        return this.restorePointCreationDate;
    }
    
    /**
    * Optional. Restore point creation time. Populated when restorePointType =
    * CONTINUOUS. Null otherwise.
    * @param restorePointCreationDateValue The RestorePointCreationDate value.
    */
    public void setRestorePointCreationDate(final Calendar restorePointCreationDateValue) {
        this.restorePointCreationDate = restorePointCreationDateValue;
    }
    
    private String restorePointType;
    
    /**
    * Optional. Gets the restore point type of the Azure SQL Database restore
    * point.
    * @return The RestorePointType value.
    */
    public String getRestorePointType() {
        return this.restorePointType;
    }
    
    /**
    * Optional. Gets the restore point type of the Azure SQL Database restore
    * point.
    * @param restorePointTypeValue The RestorePointType value.
    */
    public void setRestorePointType(final String restorePointTypeValue) {
        this.restorePointType = restorePointTypeValue;
    }
}
