/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Represents the response to a List Azure SQL Active Directory Administrators
* request.
*/
public class ServerAdministratorListResponse extends OperationResponse implements Iterable<ServerAdministrator> {
    private ArrayList<ServerAdministrator> administrators;
    
    /**
    * Optional. Gets or sets the list of Azure SQL Server Active Directory
    * Administrators for the server.
    * @return The Administrators value.
    */
    public ArrayList<ServerAdministrator> getAdministrators() {
        return this.administrators;
    }
    
    /**
    * Optional. Gets or sets the list of Azure SQL Server Active Directory
    * Administrators for the server.
    * @param administratorsValue The Administrators value.
    */
    public void setAdministrators(final ArrayList<ServerAdministrator> administratorsValue) {
        this.administrators = administratorsValue;
    }
    
    /**
    * Initializes a new instance of the ServerAdministratorListResponse class.
    *
    */
    public ServerAdministratorListResponse() {
        super();
        this.setAdministrators(new LazyArrayList<ServerAdministrator>());
    }
    
    /**
    * Gets the sequence of Administrators.
    *
    */
    public Iterator<ServerAdministrator> iterator() {
        return this.getAdministrators().iterator();
    }
}
