/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* Represents an Azure SQL Database server auditing policy.
*/
public class ServerAuditingPolicy extends ResourceBaseExtended {
    private ServerAuditingPolicyProperties properties;
    
    /**
    * Optional. Represents the properties of the resource.
    * @return The Properties value.
    */
    public ServerAuditingPolicyProperties getProperties() {
        return this.properties;
    }
    
    /**
    * Optional. Represents the properties of the resource.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final ServerAuditingPolicyProperties propertiesValue) {
        this.properties = propertiesValue;
    }
    
    /**
    * Initializes a new instance of the ServerAuditingPolicy class.
    *
    */
    public ServerAuditingPolicy() {
        super();
    }
    
    /**
    * Initializes a new instance of the ServerAuditingPolicy class with
    * required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public ServerAuditingPolicy(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
