/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* Start Azure SQL Database Server Upgrade properties.
*/
public class ServerUpgradeProperties {
    private ArrayList<RecommendedDatabaseProperties> databaseCollection;
    
    /**
    * Optional. Gets or sets the collection of recommended database properties
    * to upgrade the Azure SQL Database Server.
    * @return The DatabaseCollection value.
    */
    public ArrayList<RecommendedDatabaseProperties> getDatabaseCollection() {
        return this.databaseCollection;
    }
    
    /**
    * Optional. Gets or sets the collection of recommended database properties
    * to upgrade the Azure SQL Database Server.
    * @param databaseCollectionValue The DatabaseCollection value.
    */
    public void setDatabaseCollection(final ArrayList<RecommendedDatabaseProperties> databaseCollectionValue) {
        this.databaseCollection = databaseCollectionValue;
    }
    
    private ArrayList<UpgradeRecommendedElasticPoolProperties> elasticPoolCollection;
    
    /**
    * Optional. Gets or sets the collection of recommended elastic pool
    * properties to upgrade the Azure SQL Database Server.
    * @return The ElasticPoolCollection value.
    */
    public ArrayList<UpgradeRecommendedElasticPoolProperties> getElasticPoolCollection() {
        return this.elasticPoolCollection;
    }
    
    /**
    * Optional. Gets or sets the collection of recommended elastic pool
    * properties to upgrade the Azure SQL Database Server.
    * @param elasticPoolCollectionValue The ElasticPoolCollection value.
    */
    public void setElasticPoolCollection(final ArrayList<UpgradeRecommendedElasticPoolProperties> elasticPoolCollectionValue) {
        this.elasticPoolCollection = elasticPoolCollectionValue;
    }
    
    private Calendar scheduleUpgradeAfterUtcDateTime;
    
    /**
    * Optional. Gets or sets the earliest time to upgrade the Azure SQL
    * Database Server.
    * @return The ScheduleUpgradeAfterUtcDateTime value.
    */
    public Calendar getScheduleUpgradeAfterUtcDateTime() {
        return this.scheduleUpgradeAfterUtcDateTime;
    }
    
    /**
    * Optional. Gets or sets the earliest time to upgrade the Azure SQL
    * Database Server.
    * @param scheduleUpgradeAfterUtcDateTimeValue The
    * ScheduleUpgradeAfterUtcDateTime value.
    */
    public void setScheduleUpgradeAfterUtcDateTime(final Calendar scheduleUpgradeAfterUtcDateTimeValue) {
        this.scheduleUpgradeAfterUtcDateTime = scheduleUpgradeAfterUtcDateTimeValue;
    }
    
    private String version;
    
    /**
    * Required. Gets or sets the version for the Azure SQL Database Server
    * being upgraded.
    * @return The Version value.
    */
    public String getVersion() {
        return this.version;
    }
    
    /**
    * Required. Gets or sets the version for the Azure SQL Database Server
    * being upgraded.
    * @param versionValue The Version value.
    */
    public void setVersion(final String versionValue) {
        this.version = versionValue;
    }
    
    /**
    * Initializes a new instance of the ServerUpgradeProperties class.
    *
    */
    public ServerUpgradeProperties() {
        this.setDatabaseCollection(new LazyArrayList<RecommendedDatabaseProperties>());
        this.setElasticPoolCollection(new LazyArrayList<UpgradeRecommendedElasticPoolProperties>());
    }
    
    /**
    * Initializes a new instance of the ServerUpgradeProperties class with
    * required arguments.
    *
    * @param version Gets or sets the version for the Azure SQL Database Server
    * being upgraded.
    */
    public ServerUpgradeProperties(String version) {
        this();
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.setVersion(version);
    }
}
