/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

/**
* Represents the properties of an Azure SQL Database Service Objective.
*/
public class ServiceObjectiveProperties {
    private String description;
    
    /**
    * Optional. Gets the description for the service level objective.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. Gets the description for the service level objective.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private boolean enabled;
    
    /**
    * Optional. Gets whether the service level objective is enabled.
    * @return The Enabled value.
    */
    public boolean isEnabled() {
        return this.enabled;
    }
    
    /**
    * Optional. Gets whether the service level objective is enabled.
    * @param enabledValue The Enabled value.
    */
    public void setEnabled(final boolean enabledValue) {
        this.enabled = enabledValue;
    }
    
    private boolean isDefault;
    
    /**
    * Optional. Gets whether the service level objective is the default service
    * objective.
    * @return The IsDefault value.
    */
    public boolean isDefault() {
        return this.isDefault;
    }
    
    /**
    * Optional. Gets whether the service level objective is the default service
    * objective.
    * @param isDefaultValue The IsDefault value.
    */
    public void setIsDefault(final boolean isDefaultValue) {
        this.isDefault = isDefaultValue;
    }
    
    private boolean isSystem;
    
    /**
    * Optional. Gets whether the service level objective is a system service
    * objective.
    * @return The IsSystem value.
    */
    public boolean isSystem() {
        return this.isSystem;
    }
    
    /**
    * Optional. Gets whether the service level objective is a system service
    * objective.
    * @param isSystemValue The IsSystem value.
    */
    public void setIsSystem(final boolean isSystemValue) {
        this.isSystem = isSystemValue;
    }
    
    private String serviceObjectiveName;
    
    /**
    * Optional. Gets the name for the service objective.
    * @return The ServiceObjectiveName value.
    */
    public String getServiceObjectiveName() {
        return this.serviceObjectiveName;
    }
    
    /**
    * Optional. Gets the name for the service objective.
    * @param serviceObjectiveNameValue The ServiceObjectiveName value.
    */
    public void setServiceObjectiveName(final String serviceObjectiveNameValue) {
        this.serviceObjectiveName = serviceObjectiveNameValue;
    }
}
