/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* Represents the properties of a Service Tier Advisor.
*/
public class ServiceTierAdvisorProperties {
    private Double activeTimeRatio;
    
    /**
    * Optional. Gets the activeTimeRatio for service tier advisor.
    * @return The ActiveTimeRatio value.
    */
    public Double getActiveTimeRatio() {
        return this.activeTimeRatio;
    }
    
    /**
    * Optional. Gets the activeTimeRatio for service tier advisor.
    * @param activeTimeRatioValue The ActiveTimeRatio value.
    */
    public void setActiveTimeRatio(final Double activeTimeRatioValue) {
        this.activeTimeRatio = activeTimeRatioValue;
    }
    
    private Double avgDtu;
    
    /**
    * Optional. Gets or sets avgDtu for service tier advisor.
    * @return The AvgDtu value.
    */
    public Double getAvgDtu() {
        return this.avgDtu;
    }
    
    /**
    * Optional. Gets or sets avgDtu for service tier advisor.
    * @param avgDtuValue The AvgDtu value.
    */
    public void setAvgDtu(final Double avgDtuValue) {
        this.avgDtu = avgDtuValue;
    }
    
    private double confidence;
    
    /**
    * Optional. Gets or sets confidence for service tier advisor.
    * @return The Confidence value.
    */
    public double getConfidence() {
        return this.confidence;
    }
    
    /**
    * Optional. Gets or sets confidence for service tier advisor.
    * @param confidenceValue The Confidence value.
    */
    public void setConfidence(final double confidenceValue) {
        this.confidence = confidenceValue;
    }
    
    private String currentServiceLevelObjective;
    
    /**
    * Optional. Gets or sets currentServiceLevelObjective for service tier
    * advisor.
    * @return The CurrentServiceLevelObjective value.
    */
    public String getCurrentServiceLevelObjective() {
        return this.currentServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets currentServiceLevelObjective for service tier
    * advisor.
    * @param currentServiceLevelObjectiveValue The CurrentServiceLevelObjective
    * value.
    */
    public void setCurrentServiceLevelObjective(final String currentServiceLevelObjectiveValue) {
        this.currentServiceLevelObjective = currentServiceLevelObjectiveValue;
    }
    
    private String currentServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets currentServiceLevelObjectiveId for service tier
    * advisor.
    * @return The CurrentServiceLevelObjectiveId value.
    */
    public String getCurrentServiceLevelObjectiveId() {
        return this.currentServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets currentServiceLevelObjectiveId for service tier
    * advisor.
    * @param currentServiceLevelObjectiveIdValue The
    * CurrentServiceLevelObjectiveId value.
    */
    public void setCurrentServiceLevelObjectiveId(final String currentServiceLevelObjectiveIdValue) {
        this.currentServiceLevelObjectiveId = currentServiceLevelObjectiveIdValue;
    }
    
    private String databaseSizeBasedRecommendationServiceLevelObjective;
    
    /**
    * Optional. Gets or sets
    * databaseSizeBasedRecommendationServiceLevelObjective for service tier
    * advisor.
    * @return The DatabaseSizeBasedRecommendationServiceLevelObjective value.
    */
    public String getDatabaseSizeBasedRecommendationServiceLevelObjective() {
        return this.databaseSizeBasedRecommendationServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets
    * databaseSizeBasedRecommendationServiceLevelObjective for service tier
    * advisor.
    * @param databaseSizeBasedRecommendationServiceLevelObjectiveValue The
    * DatabaseSizeBasedRecommendationServiceLevelObjective value.
    */
    public void setDatabaseSizeBasedRecommendationServiceLevelObjective(final String databaseSizeBasedRecommendationServiceLevelObjectiveValue) {
        this.databaseSizeBasedRecommendationServiceLevelObjective = databaseSizeBasedRecommendationServiceLevelObjectiveValue;
    }
    
    private String databaseSizeBasedRecommendationServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets
    * databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier
    * advisor.
    * @return The DatabaseSizeBasedRecommendationServiceLevelObjectiveId value.
    */
    public String getDatabaseSizeBasedRecommendationServiceLevelObjectiveId() {
        return this.databaseSizeBasedRecommendationServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets
    * databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier
    * advisor.
    * @param databaseSizeBasedRecommendationServiceLevelObjectiveIdValue The
    * DatabaseSizeBasedRecommendationServiceLevelObjectiveId value.
    */
    public void setDatabaseSizeBasedRecommendationServiceLevelObjectiveId(final String databaseSizeBasedRecommendationServiceLevelObjectiveIdValue) {
        this.databaseSizeBasedRecommendationServiceLevelObjectiveId = databaseSizeBasedRecommendationServiceLevelObjectiveIdValue;
    }
    
    private String disasterPlanBasedRecommendationServiceLevelObjective;
    
    /**
    * Optional. Gets or sets
    * disasterPlanBasedRecommendationServiceLevelObjective for service tier
    * advisor.
    * @return The DisasterPlanBasedRecommendationServiceLevelObjective value.
    */
    public String getDisasterPlanBasedRecommendationServiceLevelObjective() {
        return this.disasterPlanBasedRecommendationServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets
    * disasterPlanBasedRecommendationServiceLevelObjective for service tier
    * advisor.
    * @param disasterPlanBasedRecommendationServiceLevelObjectiveValue The
    * DisasterPlanBasedRecommendationServiceLevelObjective value.
    */
    public void setDisasterPlanBasedRecommendationServiceLevelObjective(final String disasterPlanBasedRecommendationServiceLevelObjectiveValue) {
        this.disasterPlanBasedRecommendationServiceLevelObjective = disasterPlanBasedRecommendationServiceLevelObjectiveValue;
    }
    
    private String disasterPlanBasedRecommendationServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets
    * disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier
    * advisor.
    * @return The DisasterPlanBasedRecommendationServiceLevelObjectiveId value.
    */
    public String getDisasterPlanBasedRecommendationServiceLevelObjectiveId() {
        return this.disasterPlanBasedRecommendationServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets
    * disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier
    * advisor.
    * @param disasterPlanBasedRecommendationServiceLevelObjectiveIdValue The
    * DisasterPlanBasedRecommendationServiceLevelObjectiveId value.
    */
    public void setDisasterPlanBasedRecommendationServiceLevelObjectiveId(final String disasterPlanBasedRecommendationServiceLevelObjectiveIdValue) {
        this.disasterPlanBasedRecommendationServiceLevelObjectiveId = disasterPlanBasedRecommendationServiceLevelObjectiveIdValue;
    }
    
    private Double maxDtu;
    
    /**
    * Optional. Gets or sets maxDtu for service tier advisor.
    * @return The MaxDtu value.
    */
    public Double getMaxDtu() {
        return this.maxDtu;
    }
    
    /**
    * Optional. Gets or sets maxDtu for service tier advisor.
    * @param maxDtuValue The MaxDtu value.
    */
    public void setMaxDtu(final Double maxDtuValue) {
        this.maxDtu = maxDtuValue;
    }
    
    private Double maxSizeInGB;
    
    /**
    * Optional. Gets or sets maxSizeInGB for service tier advisor.
    * @return The MaxSizeInGB value.
    */
    public Double getMaxSizeInGB() {
        return this.maxSizeInGB;
    }
    
    /**
    * Optional. Gets or sets maxSizeInGB for service tier advisor.
    * @param maxSizeInGBValue The MaxSizeInGB value.
    */
    public void setMaxSizeInGB(final Double maxSizeInGBValue) {
        this.maxSizeInGB = maxSizeInGBValue;
    }
    
    private Double minDtu;
    
    /**
    * Optional. Gets or sets minDtu for service tier advisor.
    * @return The MinDtu value.
    */
    public Double getMinDtu() {
        return this.minDtu;
    }
    
    /**
    * Optional. Gets or sets minDtu for service tier advisor.
    * @param minDtuValue The MinDtu value.
    */
    public void setMinDtu(final Double minDtuValue) {
        this.minDtu = minDtuValue;
    }
    
    private Calendar observationPeriodEnd;
    
    /**
    * Optional. Gets the observation period start.
    * @return The ObservationPeriodEnd value.
    */
    public Calendar getObservationPeriodEnd() {
        return this.observationPeriodEnd;
    }
    
    /**
    * Optional. Gets the observation period start.
    * @param observationPeriodEndValue The ObservationPeriodEnd value.
    */
    public void setObservationPeriodEnd(final Calendar observationPeriodEndValue) {
        this.observationPeriodEnd = observationPeriodEndValue;
    }
    
    private Calendar observationPeriodStart;
    
    /**
    * Optional. Gets the observation period start.
    * @return The ObservationPeriodStart value.
    */
    public Calendar getObservationPeriodStart() {
        return this.observationPeriodStart;
    }
    
    /**
    * Optional. Gets the observation period start.
    * @param observationPeriodStartValue The ObservationPeriodStart value.
    */
    public void setObservationPeriodStart(final Calendar observationPeriodStartValue) {
        this.observationPeriodStart = observationPeriodStartValue;
    }
    
    private String overallRecommendationServiceLevelObjective;
    
    /**
    * Optional. Gets or sets overallRecommendationServiceLevelObjective for
    * service tier advisor.
    * @return The OverallRecommendationServiceLevelObjective value.
    */
    public String getOverallRecommendationServiceLevelObjective() {
        return this.overallRecommendationServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets overallRecommendationServiceLevelObjective for
    * service tier advisor.
    * @param overallRecommendationServiceLevelObjectiveValue The
    * OverallRecommendationServiceLevelObjective value.
    */
    public void setOverallRecommendationServiceLevelObjective(final String overallRecommendationServiceLevelObjectiveValue) {
        this.overallRecommendationServiceLevelObjective = overallRecommendationServiceLevelObjectiveValue;
    }
    
    private String overallRecommendationServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets overallRecommendationServiceLevelObjectiveId for
    * service tier advisor.
    * @return The OverallRecommendationServiceLevelObjectiveId value.
    */
    public String getOverallRecommendationServiceLevelObjectiveId() {
        return this.overallRecommendationServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets overallRecommendationServiceLevelObjectiveId for
    * service tier advisor.
    * @param overallRecommendationServiceLevelObjectiveIdValue The
    * OverallRecommendationServiceLevelObjectiveId value.
    */
    public void setOverallRecommendationServiceLevelObjectiveId(final String overallRecommendationServiceLevelObjectiveIdValue) {
        this.overallRecommendationServiceLevelObjectiveId = overallRecommendationServiceLevelObjectiveIdValue;
    }
    
    private ArrayList<SloUsageMetric> serviceLevelObjectiveUsageMetrics;
    
    /**
    * Optional. Gets or sets serviceLevelObjectiveUsageMetrics for the service
    * tier advisor.
    * @return The ServiceLevelObjectiveUsageMetrics value.
    */
    public ArrayList<SloUsageMetric> getServiceLevelObjectiveUsageMetrics() {
        return this.serviceLevelObjectiveUsageMetrics;
    }
    
    /**
    * Optional. Gets or sets serviceLevelObjectiveUsageMetrics for the service
    * tier advisor.
    * @param serviceLevelObjectiveUsageMetricsValue The
    * ServiceLevelObjectiveUsageMetrics value.
    */
    public void setServiceLevelObjectiveUsageMetrics(final ArrayList<SloUsageMetric> serviceLevelObjectiveUsageMetricsValue) {
        this.serviceLevelObjectiveUsageMetrics = serviceLevelObjectiveUsageMetricsValue;
    }
    
    private String usageBasedRecommendationServiceLevelObjective;
    
    /**
    * Optional. Gets or sets usageBasedRecommendationServiceLevelObjective for
    * service tier advisor.
    * @return The UsageBasedRecommendationServiceLevelObjective value.
    */
    public String getUsageBasedRecommendationServiceLevelObjective() {
        return this.usageBasedRecommendationServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets usageBasedRecommendationServiceLevelObjective for
    * service tier advisor.
    * @param usageBasedRecommendationServiceLevelObjectiveValue The
    * UsageBasedRecommendationServiceLevelObjective value.
    */
    public void setUsageBasedRecommendationServiceLevelObjective(final String usageBasedRecommendationServiceLevelObjectiveValue) {
        this.usageBasedRecommendationServiceLevelObjective = usageBasedRecommendationServiceLevelObjectiveValue;
    }
    
    private String usageBasedRecommendationServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets usageBasedRecommendationServiceLevelObjectiveId
    * for service tier advisor.
    * @return The UsageBasedRecommendationServiceLevelObjectiveId value.
    */
    public String getUsageBasedRecommendationServiceLevelObjectiveId() {
        return this.usageBasedRecommendationServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets usageBasedRecommendationServiceLevelObjectiveId
    * for service tier advisor.
    * @param usageBasedRecommendationServiceLevelObjectiveIdValue The
    * UsageBasedRecommendationServiceLevelObjectiveId value.
    */
    public void setUsageBasedRecommendationServiceLevelObjectiveId(final String usageBasedRecommendationServiceLevelObjectiveIdValue) {
        this.usageBasedRecommendationServiceLevelObjectiveId = usageBasedRecommendationServiceLevelObjectiveIdValue;
    }
    
    /**
    * Initializes a new instance of the ServiceTierAdvisorProperties class.
    *
    */
    public ServiceTierAdvisorProperties() {
        this.setServiceLevelObjectiveUsageMetrics(new LazyArrayList<SloUsageMetric>());
    }
}
