/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* Represents a Slo Usage Metric.
*/
public class SloUsageMetric extends ResourceBaseExtended {
    private double inRangeTimeRatio;
    
    /**
    * Optional. Gets or sets inRangeTimeRatio for SLO usage metric.
    * @return The InRangeTimeRatio value.
    */
    public double getInRangeTimeRatio() {
        return this.inRangeTimeRatio;
    }
    
    /**
    * Optional. Gets or sets inRangeTimeRatio for SLO usage metric.
    * @param inRangeTimeRatioValue The InRangeTimeRatio value.
    */
    public void setInRangeTimeRatio(final double inRangeTimeRatioValue) {
        this.inRangeTimeRatio = inRangeTimeRatioValue;
    }
    
    private String serviceLevelObjective;
    
    /**
    * Optional. Gets or sets serviceLevelObjective for SLO usage metric.
    * @return The ServiceLevelObjective value.
    */
    public String getServiceLevelObjective() {
        return this.serviceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets serviceLevelObjective for SLO usage metric.
    * @param serviceLevelObjectiveValue The ServiceLevelObjective value.
    */
    public void setServiceLevelObjective(final String serviceLevelObjectiveValue) {
        this.serviceLevelObjective = serviceLevelObjectiveValue;
    }
    
    private String serviceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets serviceLevelObjectiveId for SLO usage metric.
    * @return The ServiceLevelObjectiveId value.
    */
    public String getServiceLevelObjectiveId() {
        return this.serviceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets serviceLevelObjectiveId for SLO usage metric.
    * @param serviceLevelObjectiveIdValue The ServiceLevelObjectiveId value.
    */
    public void setServiceLevelObjectiveId(final String serviceLevelObjectiveIdValue) {
        this.serviceLevelObjectiveId = serviceLevelObjectiveIdValue;
    }
    
    /**
    * Initializes a new instance of the SloUsageMetric class.
    *
    */
    public SloUsageMetric() {
        super();
    }
    
    /**
    * Initializes a new instance of the SloUsageMetric class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public SloUsageMetric(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
