/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.sql.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* Represents a Upgrade Hint.
*/
public class UpgradeHint extends ResourceBaseExtended {
    private String targetServiceLevelObjective;
    
    /**
    * Optional. Gets or sets targetServiceLevelObjective for upgrade hint.
    * @return The TargetServiceLevelObjective value.
    */
    public String getTargetServiceLevelObjective() {
        return this.targetServiceLevelObjective;
    }
    
    /**
    * Optional. Gets or sets targetServiceLevelObjective for upgrade hint.
    * @param targetServiceLevelObjectiveValue The TargetServiceLevelObjective
    * value.
    */
    public void setTargetServiceLevelObjective(final String targetServiceLevelObjectiveValue) {
        this.targetServiceLevelObjective = targetServiceLevelObjectiveValue;
    }
    
    private String targetServiceLevelObjectiveId;
    
    /**
    * Optional. Gets or sets targetServiceLevelObjectiveId for upgrade hint.
    * @return The TargetServiceLevelObjectiveId value.
    */
    public String getTargetServiceLevelObjectiveId() {
        return this.targetServiceLevelObjectiveId;
    }
    
    /**
    * Optional. Gets or sets targetServiceLevelObjectiveId for upgrade hint.
    * @param targetServiceLevelObjectiveIdValue The
    * TargetServiceLevelObjectiveId value.
    */
    public void setTargetServiceLevelObjectiveId(final String targetServiceLevelObjectiveIdValue) {
        this.targetServiceLevelObjectiveId = targetServiceLevelObjectiveIdValue;
    }
    
    /**
    * Initializes a new instance of the UpgradeHint class.
    *
    */
    public UpgradeHint() {
        super();
    }
    
    /**
    * Initializes a new instance of the UpgradeHint class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public UpgradeHint(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
