/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.storage.models;

import com.microsoft.windowsazure.core.OperationResponse;

/**
* The CheckNameAvailability operation response.
*/
public class CheckNameAvailabilityResponse extends OperationResponse {
    private String message;
    
    /**
    * Optional. Gets an error message explaining the Reason value in more
    * detail.
    * @return The Message value.
    */
    public String getMessage() {
        return this.message;
    }
    
    /**
    * Optional. Gets an error message explaining the Reason value in more
    * detail.
    * @param messageValue The Message value.
    */
    public void setMessage(final String messageValue) {
        this.message = messageValue;
    }
    
    private boolean nameAvailable;
    
    /**
    * Optional. Gets a boolean value that indicates whether the name is
    * available for you to use. If true, the name is available. If false, the
    * name has already been taken or invalid and cannot be used.
    * @return The NameAvailable value.
    */
    public boolean isNameAvailable() {
        return this.nameAvailable;
    }
    
    /**
    * Optional. Gets a boolean value that indicates whether the name is
    * available for you to use. If true, the name is available. If false, the
    * name has already been taken or invalid and cannot be used.
    * @param nameAvailableValue The NameAvailable value.
    */
    public void setNameAvailable(final boolean nameAvailableValue) {
        this.nameAvailable = nameAvailableValue;
    }
    
    private Reason reason;
    
    /**
    * Optional. Gets the reason that a storage account name could not be used.
    * The Reason element is only returned if NameAvailable is false.
    * @return The Reason value.
    */
    public Reason getReason() {
        return this.reason;
    }
    
    /**
    * Optional. Gets the reason that a storage account name could not be used.
    * The Reason element is only returned if NameAvailable is false.
    * @param reasonValue The Reason value.
    */
    public void setReason(final Reason reasonValue) {
        this.reason = reasonValue;
    }
}
