/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.storage.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

import java.util.Calendar;

/**
* The storage account.
*/
public class StorageAccount extends ResourceBaseExtended {
    private AccountType accountType;
    
    /**
    * Optional. Gets the type of the storage account.
    * @return The AccountType value.
    */
    public AccountType getAccountType() {
        return this.accountType;
    }
    
    /**
    * Optional. Gets the type of the storage account.
    * @param accountTypeValue The AccountType value.
    */
    public void setAccountType(final AccountType accountTypeValue) {
        this.accountType = accountTypeValue;
    }
    
    private Calendar creationTime;
    
    /**
    * Optional. Gets the creation date and time of the storage account in UTC.
    * @return The CreationTime value.
    */
    public Calendar getCreationTime() {
        return this.creationTime;
    }
    
    /**
    * Optional. Gets the creation date and time of the storage account in UTC.
    * @param creationTimeValue The CreationTime value.
    */
    public void setCreationTime(final Calendar creationTimeValue) {
        this.creationTime = creationTimeValue;
    }
    
    private CustomDomain customDomain;
    
    /**
    * Optional. Gets the user assigned custom domain assigned to this storage
    * account.
    * @return The CustomDomain value.
    */
    public CustomDomain getCustomDomain() {
        return this.customDomain;
    }
    
    /**
    * Optional. Gets the user assigned custom domain assigned to this storage
    * account.
    * @param customDomainValue The CustomDomain value.
    */
    public void setCustomDomain(final CustomDomain customDomainValue) {
        this.customDomain = customDomainValue;
    }
    
    private Calendar lastGeoFailoverTime;
    
    /**
    * Optional. Gets the timestamp of the most recent instance of a failover to
    * the secondary location. Only the most recent timestamp is retained. This
    * element is not returned if there has never been a failover instance.
    * Only available if the accountType is StandardGRS or StandardRAGRS.
    * @return The LastGeoFailoverTime value.
    */
    public Calendar getLastGeoFailoverTime() {
        return this.lastGeoFailoverTime;
    }
    
    /**
    * Optional. Gets the timestamp of the most recent instance of a failover to
    * the secondary location. Only the most recent timestamp is retained. This
    * element is not returned if there has never been a failover instance.
    * Only available if the accountType is StandardGRS or StandardRAGRS.
    * @param lastGeoFailoverTimeValue The LastGeoFailoverTime value.
    */
    public void setLastGeoFailoverTime(final Calendar lastGeoFailoverTimeValue) {
        this.lastGeoFailoverTime = lastGeoFailoverTimeValue;
    }
    
    private Endpoints primaryEndpoints;
    
    /**
    * Optional. Gets the URLs that are used to perform a retrieval of a public
    * blob, queue or table object.Note that StandardZRS and PremiumLRS
    * accounts only return the blob endpoint.
    * @return The PrimaryEndpoints value.
    */
    public Endpoints getPrimaryEndpoints() {
        return this.primaryEndpoints;
    }
    
    /**
    * Optional. Gets the URLs that are used to perform a retrieval of a public
    * blob, queue or table object.Note that StandardZRS and PremiumLRS
    * accounts only return the blob endpoint.
    * @param primaryEndpointsValue The PrimaryEndpoints value.
    */
    public void setPrimaryEndpoints(final Endpoints primaryEndpointsValue) {
        this.primaryEndpoints = primaryEndpointsValue;
    }
    
    private String primaryLocation;
    
    /**
    * Optional. Gets the location of the primary for the storage account.
    * @return The PrimaryLocation value.
    */
    public String getPrimaryLocation() {
        return this.primaryLocation;
    }
    
    /**
    * Optional. Gets the location of the primary for the storage account.
    * @param primaryLocationValue The PrimaryLocation value.
    */
    public void setPrimaryLocation(final String primaryLocationValue) {
        this.primaryLocation = primaryLocationValue;
    }
    
    private ProvisioningState provisioningState;
    
    /**
    * Optional. Gets the status of the storage account at the time the
    * operation was called.
    * @return The ProvisioningState value.
    */
    public ProvisioningState getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets the status of the storage account at the time the
    * operation was called.
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final ProvisioningState provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private Endpoints secondaryEndpoints;
    
    /**
    * Optional. Gets the URLs that are used to perform a retrieval of a public
    * blob, queue or table object from the secondary location of the storage
    * account. Only available if the accountType is StandardRAGRS.
    * @return The SecondaryEndpoints value.
    */
    public Endpoints getSecondaryEndpoints() {
        return this.secondaryEndpoints;
    }
    
    /**
    * Optional. Gets the URLs that are used to perform a retrieval of a public
    * blob, queue or table object from the secondary location of the storage
    * account. Only available if the accountType is StandardRAGRS.
    * @param secondaryEndpointsValue The SecondaryEndpoints value.
    */
    public void setSecondaryEndpoints(final Endpoints secondaryEndpointsValue) {
        this.secondaryEndpoints = secondaryEndpointsValue;
    }
    
    private String secondaryLocation;
    
    /**
    * Optional. Gets the location of the geo replicated secondary for the
    * storage account. Only available if the accountType is StandardGRS or
    * StandardRAGRS.
    * @return The SecondaryLocation value.
    */
    public String getSecondaryLocation() {
        return this.secondaryLocation;
    }
    
    /**
    * Optional. Gets the location of the geo replicated secondary for the
    * storage account. Only available if the accountType is StandardGRS or
    * StandardRAGRS.
    * @param secondaryLocationValue The SecondaryLocation value.
    */
    public void setSecondaryLocation(final String secondaryLocationValue) {
        this.secondaryLocation = secondaryLocationValue;
    }
    
    private AccountStatus statusOfPrimary;
    
    /**
    * Optional. Gets the status indicating whether the primary location of the
    * storage account is available or unavailable.
    * @return The StatusOfPrimary value.
    */
    public AccountStatus getStatusOfPrimary() {
        return this.statusOfPrimary;
    }
    
    /**
    * Optional. Gets the status indicating whether the primary location of the
    * storage account is available or unavailable.
    * @param statusOfPrimaryValue The StatusOfPrimary value.
    */
    public void setStatusOfPrimary(final AccountStatus statusOfPrimaryValue) {
        this.statusOfPrimary = statusOfPrimaryValue;
    }
    
    private AccountStatus statusOfSecondary;
    
    /**
    * Optional. Gets the status indicating whether the secondary location of
    * the storage account is available or unavailable. Only available if the
    * accountType is StandardGRS or StandardRAGRS.
    * @return The StatusOfSecondary value.
    */
    public AccountStatus getStatusOfSecondary() {
        return this.statusOfSecondary;
    }
    
    /**
    * Optional. Gets the status indicating whether the secondary location of
    * the storage account is available or unavailable. Only available if the
    * accountType is StandardGRS or StandardRAGRS.
    * @param statusOfSecondaryValue The StatusOfSecondary value.
    */
    public void setStatusOfSecondary(final AccountStatus statusOfSecondaryValue) {
        this.statusOfSecondary = statusOfSecondaryValue;
    }
    
    /**
    * Initializes a new instance of the StorageAccount class.
    *
    */
    public StorageAccount() {
        super();
    }
    
    /**
    * Initializes a new instance of the StorageAccount class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public StorageAccount(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
