/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.storage.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* The parameters to provide for the account.
*/
public class StorageAccountCreateParameters {
    private AccountType accountType;
    
    /**
    * Required. Gets or sets the account type.
    * @return The AccountType value.
    */
    public AccountType getAccountType() {
        return this.accountType;
    }
    
    /**
    * Required. Gets or sets the account type.
    * @param accountTypeValue The AccountType value.
    */
    public void setAccountType(final AccountType accountTypeValue) {
        this.accountType = accountTypeValue;
    }
    
    private String location;
    
    /**
    * Required. Gets or sets the location of the resource. This will be one of
    * the supported and registered Azure Geo Regions (e.g. West US, East US,
    * Southeast Asia, etc.). The geo region of a resource cannot be changed
    * once it is created.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Required. Gets or sets the location of the resource. This will be one of
    * the supported and registered Azure Geo Regions (e.g. West US, East US,
    * Southeast Asia, etc.). The geo region of a resource cannot be changed
    * once it is created.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private HashMap<String, String> tags;
    
    /**
    * Optional. Gets or sets a list of key value pairs that describe the
    * resource. These tags can be used in viewing and grouping this resource
    * (across resource groups). A maximum of 15 tags can be provided for a
    * resource. Each tag must have a key no greater than 128 characters and
    * value no greater than 256 characters.
    * @return The Tags value.
    */
    public HashMap<String, String> getTags() {
        return this.tags;
    }
    
    /**
    * Optional. Gets or sets a list of key value pairs that describe the
    * resource. These tags can be used in viewing and grouping this resource
    * (across resource groups). A maximum of 15 tags can be provided for a
    * resource. Each tag must have a key no greater than 128 characters and
    * value no greater than 256 characters.
    * @param tagsValue The Tags value.
    */
    public void setTags(final HashMap<String, String> tagsValue) {
        this.tags = tagsValue;
    }
    
    /**
    * Initializes a new instance of the StorageAccountCreateParameters class.
    *
    */
    public StorageAccountCreateParameters() {
        this.setTags(new LazyHashMap<String, String>());
    }
    
    /**
    * Initializes a new instance of the StorageAccountCreateParameters class
    * with required arguments.
    *
    * @param accountType Gets or sets the account type.
    * @param location Gets or sets the location of the resource. This will be
    * one of the supported and registered Azure Geo Regions (e.g. West US,
    * East US, Southeast Asia, etc.). The geo region of a resource cannot be
    * changed once it is created.
    */
    public StorageAccountCreateParameters(AccountType accountType, String location) {
        this();
        if (accountType == null) {
            throw new NullPointerException("accountType");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setAccountType(accountType);
        this.setLocation(location);
    }
}
