/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.storage.models;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;

/**
* The Create storage account operation response.
*/
public class StorageAccountCreateResponse extends OperationResponse {
    private String operationStatusLink;
    
    /**
    * Optional. Gets the URL where the status of the create operation can be
    * checked.
    * @return The OperationStatusLink value.
    */
    public String getOperationStatusLink() {
        return this.operationStatusLink;
    }
    
    /**
    * Optional. Gets the URL where the status of the create operation can be
    * checked.
    * @param operationStatusLinkValue The OperationStatusLink value.
    */
    public void setOperationStatusLink(final String operationStatusLinkValue) {
        this.operationStatusLink = operationStatusLinkValue;
    }
    
    private int retryAfter;
    
    /**
    * Optional. Gets the delay that the client should use when checking for the
    * status of the operation. This delay is specified in seconds as an
    * integer; min 5 seconds, max 900 seconds (15 minutes). The storage
    * resource provider will return 25 seconds initially.
    * @return The RetryAfter value.
    */
    public int getRetryAfter() {
        return this.retryAfter;
    }
    
    /**
    * Optional. Gets the delay that the client should use when checking for the
    * status of the operation. This delay is specified in seconds as an
    * integer; min 5 seconds, max 900 seconds (15 minutes). The storage
    * resource provider will return 25 seconds initially.
    * @param retryAfterValue The RetryAfter value.
    */
    public void setRetryAfter(final int retryAfterValue) {
        this.retryAfter = retryAfterValue;
    }
    
    private OperationStatus status;
    
    /**
    * Optional. Gets the status of the create request.
    * @return The Status value.
    */
    public OperationStatus getStatus() {
        return this.status;
    }
    
    /**
    * Optional. Gets the status of the create request.
    * @param statusValue The Status value.
    */
    public void setStatus(final OperationStatus statusValue) {
        this.status = statusValue;
    }
    
    private StorageAccount storageAccount;
    
    /**
    * Optional. Gets the storage account with the created properties populated.
    * @return The StorageAccount value.
    */
    public StorageAccount getStorageAccount() {
        return this.storageAccount;
    }
    
    /**
    * Optional. Gets the storage account with the created properties populated.
    * @param storageAccountValue The StorageAccount value.
    */
    public void setStorageAccount(final StorageAccount storageAccountValue) {
        this.storageAccount = storageAccountValue;
    }
}
