/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.storage.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* The parameters to update on the account.
*/
public class StorageAccountUpdateParameters {
    private AccountType accountType;
    
    /**
    * Optional. Gets or sets the account type. Note that StandardZRS and
    * PremiumLRS accounts cannot be changed to other account types, and other
    * account types cannot be changed to StandardZRS or PremiumLRS.
    * @return The AccountType value.
    */
    public AccountType getAccountType() {
        return this.accountType;
    }
    
    /**
    * Optional. Gets or sets the account type. Note that StandardZRS and
    * PremiumLRS accounts cannot be changed to other account types, and other
    * account types cannot be changed to StandardZRS or PremiumLRS.
    * @param accountTypeValue The AccountType value.
    */
    public void setAccountType(final AccountType accountTypeValue) {
        this.accountType = accountTypeValue;
    }
    
    private CustomDomain customDomain;
    
    /**
    * Optional. User domain assigned to the storage account. Name is the CNAME
    * source. Only one custom domain is supported per storage account at this
    * time. To clear the existing custom domain, use an empty string for the
    * custom domain name property.
    * @return The CustomDomain value.
    */
    public CustomDomain getCustomDomain() {
        return this.customDomain;
    }
    
    /**
    * Optional. User domain assigned to the storage account. Name is the CNAME
    * source. Only one custom domain is supported per storage account at this
    * time. To clear the existing custom domain, use an empty string for the
    * custom domain name property.
    * @param customDomainValue The CustomDomain value.
    */
    public void setCustomDomain(final CustomDomain customDomainValue) {
        this.customDomain = customDomainValue;
    }
    
    private HashMap<String, String> tags;
    
    /**
    * Optional. Gets or sets a list of key value pairs that describe the
    * resource. These tags can be used in viewing and grouping this resource
    * (across resource groups). A maximum of 15 tags can be provided for a
    * resource. Each tag must have a key no greater than 128 characters and
    * value no greater than 256 characters. This is a full replace so all the
    * existing tags will be replaced on Update.
    * @return The Tags value.
    */
    public HashMap<String, String> getTags() {
        return this.tags;
    }
    
    /**
    * Optional. Gets or sets a list of key value pairs that describe the
    * resource. These tags can be used in viewing and grouping this resource
    * (across resource groups). A maximum of 15 tags can be provided for a
    * resource. Each tag must have a key no greater than 128 characters and
    * value no greater than 256 characters. This is a full replace so all the
    * existing tags will be replaced on Update.
    * @param tagsValue The Tags value.
    */
    public void setTags(final HashMap<String, String> tagsValue) {
        this.tags = tagsValue;
    }
    
    /**
    * Initializes a new instance of the StorageAccountUpdateParameters class.
    *
    */
    public StorageAccountUpdateParameters() {
        this.setTags(new LazyHashMap<String, String>());
    }
}
